/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import codechicken.lib.vec.Vector3;
import java.util.Random;
import mrtjp.projectred.core.fx.ParticleLogic;

public final class ParticleLogicOrbitPoint
extends ParticleLogic {
    private Vector3 target;
    private double distance;
    private boolean rotateClockwise;
    private double targetY;
    private double targetDistance;
    private double orbitSpeed;
    private double orbitAngle;
    private double orbitY = -512.0;
    private boolean useCurrentDistance;
    private boolean ignoreYCoord;
    private boolean shrinkingOrbit;
    private double shrinkSpeed = 0.0;
    private double shrinkTargetDistance = 0.0;

    public ParticleLogicOrbitPoint(Vector3 point) {
        this.target = point.copy();
        this.orbitAngle = this.rand.nextInt(360);
        this.rotateClockwise = this.rand.nextInt(10) < 5;
        this.generateNewTargetY();
        this.targetDistance = 1.0 + this.rand.nextDouble() * 0.5;
    }

    public ParticleLogicOrbitPoint setOrbitY(double orbitY) {
        this.orbitY = orbitY;
        return this;
    }

    public ParticleLogicOrbitPoint setIgnoreYCoordinate(boolean ignore) {
        this.ignoreYCoord = ignore;
        return this;
    }

    public ParticleLogicOrbitPoint setTargetDistance(double targetDistance) {
        this.targetDistance = targetDistance;
        this.useCurrentDistance = false;
        return this;
    }

    public ParticleLogicOrbitPoint setUseCurrentDistance() {
        this.useCurrentDistance = true;
        return this;
    }

    public ParticleLogicOrbitPoint setOrbitSpeed(double speed) {
        this.orbitSpeed = speed;
        return this;
    }

    public ParticleLogicOrbitPoint setShrinkingOrbit(double shrinkSpeed, double newTargetDistance) {
        this.shrinkingOrbit = true;
        this.shrinkSpeed = shrinkSpeed;
        this.shrinkTargetDistance = newTargetDistance;
        return this;
    }

    private void generateNewTargetY() {
        this.targetY = this.target != null ? new Random().nextDouble() * 2.0 : 0.0;
    }

    private void generateNewDistance() {
        this.targetDistance = this.target != null ? new Random().nextDouble() * 2.0 : 0.0;
    }

    public ParticleLogicOrbitPoint setRotateDirection(boolean clockwise) {
        this.rotateClockwise = clockwise;
        return this;
    }

    public ParticleLogicOrbitPoint setStartAngle(float angle) {
        this.orbitAngle = angle;
        return this;
    }

    @Override
    public void doUpdate() {
        double posZ;
        double posX;
        double posY = this.particle.v;
        double relativeTargetY = this.target.y + this.targetY;
        if (!this.ignoreYCoord && Math.abs(this.particle.v - relativeTargetY) < 0.1) {
            this.generateNewTargetY();
        }
        if (this.useCurrentDistance) {
            double deltaz = this.target.z - this.particle.w;
            double deltax = this.target.x - this.particle.u;
            double currentDistance = Math.sqrt(deltaz * deltaz + deltax * deltax);
            posX = this.target.x + Math.cos(this.orbitAngle) * currentDistance;
            posZ = this.target.z + Math.sin(this.orbitAngle) * currentDistance;
        } else {
            if (this.shrinkingOrbit) {
                if (this.targetDistance <= this.shrinkTargetDistance) {
                    this.shrinkingOrbit = false;
                } else if (this.targetDistance < this.shrinkTargetDistance + this.shrinkSpeed * 10.0) {
                    double delta = this.targetDistance - this.shrinkTargetDistance;
                    this.targetDistance -= delta * this.shrinkSpeed;
                } else {
                    this.targetDistance -= this.shrinkSpeed;
                }
            }
            posX = this.target.x + Math.cos(this.orbitAngle) * this.targetDistance;
            posZ = this.target.z + Math.sin(this.orbitAngle) * this.targetDistance;
        }
        if (!this.ignoreYCoord) {
            if (this.particle.v < relativeTargetY) {
                this.particle.v += 0.1;
            } else if (this.particle.v > relativeTargetY) {
                this.particle.v -= 0.1;
            }
        }
        this.orbitAngle = this.rotateClockwise ? (this.orbitAngle += this.orbitSpeed) : (this.orbitAngle -= this.orbitSpeed);
        if (this.orbitAngle > 360.0) {
            this.orbitAngle -= 360.0;
        } else if (this.orbitAngle < 0.0) {
            this.orbitAngle += 360.0;
        }
        if (this.orbitY != -512.0) {
            posY = this.target.y + this.orbitY;
        }
        this.particle.b(posX, posY, posZ);
    }

    @Override
    public ParticleLogic clone() {
        ParticleLogicOrbitPoint clone = new ParticleLogicOrbitPoint(this.target);
        if (this.useCurrentDistance) {
            clone.setUseCurrentDistance();
        } else {
            clone.setTargetDistance(this.targetDistance);
        }
        if (this.orbitY != -512.0) {
            clone.setOrbitY(this.orbitY);
        }
        clone.setOrbitSpeed(this.orbitSpeed);
        clone.setIgnoreYCoordinate(this.ignoreYCoord);
        clone.setRotateDirection(this.rotateClockwise);
        clone.setStartAngle((float)this.orbitAngle);
        if (this.shrinkingOrbit) {
            clone.setShrinkingOrbit(this.shrinkSpeed, this.shrinkTargetDistance);
        }
        return clone.setFinal(this.finalLogic).setPriority(this.priority);
    }
}

