/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import java.util.Random;
import mrtjp.projectred.core.fx.ParticleLogic;

public final class ParticleLogicOrbitEntity
extends ParticleLogic {
    private final nn target;
    private double distance;
    private final boolean rotateClockwise;
    private double targetY;
    private double curYOffset;
    private double targetDistance;
    private final double orbitSpeed;
    private double orbitAngle;
    private double orbitY = -512.0;
    private boolean ignoreYCoordinate = false;

    public ParticleLogicOrbitEntity(nn orbitTarget, double orbitSpeed) {
        this.target = orbitTarget;
        this.orbitAngle = this.rand.nextInt(360);
        this.rotateClockwise = this.rand.nextBoolean();
        this.generateNewTargetY();
        this.targetDistance = 1.0 + this.rand.nextDouble() * 0.5;
        this.orbitSpeed = orbitSpeed;
    }

    public ParticleLogicOrbitEntity setOrbitY(double orbitY) {
        this.orbitY = orbitY;
        return this;
    }

    public ParticleLogicOrbitEntity setTargetDistance(double targetDistance) {
        this.targetDistance = targetDistance;
        return this;
    }

    private void generateNewTargetY() {
        this.targetY = this.target != null ? new Random().nextDouble() * (double)this.target.P : 0.0;
    }

    private void generateNewDistance() {
        this.targetDistance = this.target != null ? new Random().nextDouble() * 2.0 : 0.0;
    }

    @Override
    public void doUpdate() {
        if (this.firstTick) {
            this.curYOffset = this.particle.v - (this.target.v + (double)this.target.f());
        }
        if (this.target == null || this.target.M) {
            this.finishLogic();
            return;
        }
        double posY = this.particle.v;
        if (Math.abs(this.targetY - this.curYOffset) < 0.1) {
            this.generateNewTargetY();
        }
        double posX = this.target.u + Math.cos(this.orbitAngle) * this.targetDistance;
        double posZ = this.target.w + Math.sin(this.orbitAngle) * this.targetDistance;
        if (this.targetY < this.curYOffset) {
            this.curYOffset -= this.orbitSpeed / 4.0;
        } else if (this.targetY > this.curYOffset) {
            this.curYOffset += this.orbitSpeed / 4.0;
        }
        this.orbitAngle = this.rotateClockwise ? (this.orbitAngle += this.orbitSpeed) : (this.orbitAngle -= this.orbitSpeed);
        if (this.orbitAngle > 360.0) {
            this.orbitAngle -= 360.0;
        } else if (this.orbitAngle < 0.0) {
            this.orbitAngle += 360.0;
        }
        if (!this.ignoreYCoordinate) {
            if (this.orbitY != -512.0) {
                posY = this.target.v + (double)this.target.f() + this.orbitY;
            } else {
                int offset = 0;
                if (this.target instanceof uf && !(this.target instanceof bdi)) {
                    offset = (int)((float)offset + 2.0f * this.target.P);
                }
                posY = this.target.v - (double)this.target.f() + this.curYOffset + (double)offset;
            }
        }
        this.particle.b(posX, posY, posZ);
    }

    @Override
    public ParticleLogic clone() {
        ParticleLogicOrbitEntity clone = new ParticleLogicOrbitEntity(this.target, this.orbitSpeed).setTargetDistance(this.targetDistance);
        if (this.orbitY != -512.0) {
            clone.setOrbitY(this.orbitY);
        }
        clone.setIgnoreYCoordinate(this.ignoreYCoordinate);
        return clone.setFinal(this.finalLogic).setPriority(this.priority);
    }

    public ParticleLogicOrbitEntity setIgnoreYCoordinate(boolean b) {
        this.ignoreYCoordinate = b;
        return this;
    }
}

