/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import mrtjp.projectred.core.fx.ParticleLogic;

public class ParticleLogicFleeEntity
extends ParticleLogic {
    private nn target;
    private double fleeSpeed;
    private double targetDistance;

    public ParticleLogicFleeEntity(nn fleeEntity, double fleeSpeed, double targetDistance) {
        this.target = fleeEntity;
        this.fleeSpeed = fleeSpeed;
        this.targetDistance = targetDistance;
    }

    @Override
    public void doUpdate() {
        double deltaY;
        double angle;
        double distanceToTarget = this.particle.d(this.target);
        double deltaZ = this.particle.w - this.target.w;
        double deltaX = this.particle.u - this.target.u;
        double radians = angle = Math.atan2(deltaZ, deltaX);
        double posX = this.particle.u + this.fleeSpeed * Math.cos(radians);
        double posY = this.particle.v;
        double posZ = this.particle.w + this.fleeSpeed * Math.sin(radians);
        if (this.target instanceof og) {
            og entityliving = (og)this.target;
            deltaY = posY - (entityliving.v + (double)entityliving.f());
        } else {
            deltaY = (this.target.E.b + this.target.E.e) / 2.0 - posY;
        }
        double horizontalDistance = ls.a((double)(deltaX * deltaX + deltaZ * deltaZ));
        float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
        double pitchRadians = pitchRotation;
        posY = this.particle.v + this.fleeSpeed * Math.sin(pitchRadians);
        if (distanceToTarget > this.targetDistance) {
            this.finishLogic();
        } else {
            this.particle.b(posX, posY, posZ);
        }
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicFleeEntity(this.target, this.fleeSpeed, this.targetDistance).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

