/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.fx.ParticleLogic;
import mrtjp.projectred.core.utils.MathLib;

public class ParticleLogicArcToEntity
extends ParticleLogic {
    private Vector3 start;
    private nn target;
    private Vector3 firstControl;
    private Vector3 secondControl;
    private float percent;
    private float speed;
    private float offsetFactor;
    private float halfOffsetFactor;

    public ParticleLogicArcToEntity(Vector3 start, nn target) {
        this.start = start.copy();
        this.percent = 0.0f;
        this.speed = 0.03f;
        this.offsetFactor = 10.0f;
        this.halfOffsetFactor = this.offsetFactor / 2.0f;
        this.target = target;
        this.generateControlPoints();
    }

    public ParticleLogicArcToEntity generateControlPoints() {
        this.firstControl = new Vector3(this.start.x + (this.target.u - this.start.x) / 3.0, this.start.y + (this.target.v - this.start.y) / 3.0, this.start.z + (this.target.w - this.start.z) / 3.0);
        this.secondControl = new Vector3(this.start.x + (this.target.u - this.start.x) / 3.0 * 2.0, this.start.y + (this.target.v - this.start.y) / 3.0 * 2.0, this.start.z + (this.target.w - this.start.z) / 3.0 * 2.0);
        double offsetX = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetZ = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        Vector3 offset = new Vector3(offsetX, 0.0, offsetZ);
        this.firstControl = this.firstControl.add(offset);
        this.secondControl = this.secondControl.add(offset);
        return this;
    }

    public ParticleLogicArcToEntity setControlPoints(Vector3 first, Vector3 second) {
        this.firstControl = first;
        this.secondControl = second;
        return this;
    }

    public ParticleLogicArcToEntity setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public void doUpdate() {
        this.percent += this.speed;
        if (this.percent >= 1.0f) {
            this.finishLogic();
            return;
        }
        Vector3 bez = MathLib.bezier(this.start, this.firstControl, this.secondControl, new Vector3(this.target.u, this.target.v, this.target.w).add(new Vector3(0.0, (double)this.target.f(), 0.0)), this.percent);
        this.particle.b(bez.x, bez.y, bez.z);
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicArcToEntity(this.particle.position(), this.target).setSpeed(this.speed).setControlPoints(this.firstControl, this.secondControl).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

