/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.fx.ParticleLogic;

public class ParticleLogicApproachPoint
extends ParticleLogic {
    protected double targetX;
    protected double targetY;
    protected double targetZ;
    protected double approachSpeed;
    protected double targetDistance;
    protected boolean ignoreY;

    public ParticleLogicApproachPoint(Vector3 point, double approachSpeed, double targetDistance) {
        this.targetX = point.x;
        this.targetY = point.y;
        this.targetZ = point.z;
        this.approachSpeed = approachSpeed;
        this.targetDistance = targetDistance;
    }

    private double getDistanceSqToPoint(double x, double y, double z2) {
        double var2 = this.particle.u - x;
        double var4 = this.particle.v - y;
        double var6 = this.particle.w - z2;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public ParticleLogicApproachPoint setIgnoreY(boolean ignore) {
        this.ignoreY = ignore;
        return this;
    }

    @Override
    public void doUpdate() {
        double posX = this.particle.u;
        double posZ = this.particle.w;
        double posY = this.particle.v;
        double distanceToTarget = this.getDistanceSqToPoint(this.targetX, this.targetY, this.targetZ);
        double deltaZ = this.targetZ - this.particle.w;
        double deltaX = this.targetX - this.particle.u;
        if (Math.abs(deltaX) > this.targetDistance || Math.abs(deltaZ) > this.targetDistance) {
            double angle;
            double radians = angle = Math.atan2(deltaZ, deltaX);
            posX = this.particle.u + this.approachSpeed * Math.cos(radians);
            posZ = this.particle.w + this.approachSpeed * Math.sin(radians);
        }
        if (!this.ignoreY) {
            double deltaY = posY - this.targetY;
            double horizontalDistance = ls.a((double)(deltaX * deltaX + deltaZ * deltaZ));
            float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
            double pitchRadians = pitchRotation;
            posY = this.particle.v + this.approachSpeed * Math.sin(pitchRadians);
        }
        if (distanceToTarget <= this.targetDistance * this.targetDistance) {
            this.onDestinationReached();
        } else {
            this.particle.b(posX, posY, posZ);
        }
    }

    public void onDestinationReached() {
        this.finishLogic();
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicApproachPoint(new Vector3(this.targetX, this.targetY, this.targetZ), this.approachSpeed, this.targetDistance).setIgnoreY(this.ignoreY).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

