/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.projectred.core.PRLogger;
import mrtjp.projectred.core.blockutil.RenderMulti;

@SideOnly(value=Side.CLIENT)
public class BasicRenderUtils {
    public static int coreRenderHandlerID = -1;
    private static IndexedRender[] renderers = new IndexedRender[4096];

    private static RenderMulti makeRenderer(aqz bl, Class renderer) {
        try {
            return (RenderMulti)renderer.getDeclaredConstructor(aqz.class).newInstance(bl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setRenderer(aqz b, int meta, Class<? extends RenderMulti> renderer) {
        RenderMulti render = BasicRenderUtils.makeRenderer(b, renderer);
        if (renderers[b.cF] == null) {
            BasicRenderUtils.renderers[b.cF] = new IndexedRender();
        }
        BasicRenderUtils.renderers[b.cF].indexedRenders[meta] = render;
    }

    public static RenderMulti getInvRenderer(int id, int meta) {
        IndexedRender ir = renderers[id];
        if (ir == null) {
            return null;
        }
        int damage = ir.damage(meta);
        if (damage > 15) {
            return ir.defaultRender;
        }
        return ir.indexedRenders[ir.damage(meta)];
    }

    public static RenderMulti getRenderer(int id, int meta) {
        IndexedRender ir = renderers[id];
        if (ir == null) {
            return null;
        }
        return ir.indexedRenders[meta];
    }

    public static class MultiRenderHandler
    implements ISimpleBlockRenderingHandler {
        public static MultiRenderHandler instance = new MultiRenderHandler();

        public void renderInventoryBlock(aqz b, int md, int modelID, bfr r) {
            if (modelID != coreRenderHandlerID) {
                return;
            }
            RenderMulti render = BasicRenderUtils.getInvRenderer(b.cF, md);
            if (render == null) {
                PRLogger.severe("No render mapping found for " + b.cF + ":" + md);
                return;
            }
            render.renderInvBlock(r, md);
        }

        public boolean renderWorldBlock(acf w, int x, int y, int z2, aqz b, int modelId, bfr r) {
            if (r.d != null) {
                return true;
            }
            if (modelId != coreRenderHandlerID) {
                return false;
            }
            int meta = w.h(x, y, z2);
            RenderMulti render = BasicRenderUtils.getRenderer(b.cF, meta);
            if (render == null) {
                PRLogger.severe("No render mapping found for " + b.cF + ":" + meta);
                return true;
            }
            render.renderWorldBlock(r, w, x, y, z2, meta);
            return true;
        }

        public boolean shouldRender3DInInventory() {
            return true;
        }

        public int getRenderId() {
            return coreRenderHandlerID;
        }
    }

    private static class IndexedRender {
        public RenderMulti[] indexedRenders = new RenderMulti[16];
        RenderMulti defaultRender;

        private IndexedRender() {
        }

        public int damage(int meta) {
            return meta;
        }
    }
}

