/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.Button;
import codechicken.nei.Image;
import codechicken.nei.LayoutManager;
import codechicken.nei.LayoutStyleDefault;
import codechicken.nei.forge.GuiContainerManager;

public class LayoutStyleTMIOld
extends LayoutStyleDefault {
    public static final Image stateOff = new Image(48, 0, 8, 12);
    public static final Image stateOn = new Image(56, 0, 8, 12);
    public static final Image stateDisabled = new Image(64, 0, 8, 12);
    int stateButtonCount;
    int clickButtonCount;

    @Override
    public String getName() {
        return "oldtmi";
    }

    @Override
    public void init() {
        LayoutManager.delete.icon = new Image(24, 12, 12, 12);
        LayoutManager.gamemode.icons[0] = new Image(12, 12, 12, 12);
        LayoutManager.gamemode.icons[1] = new Image(36, 12, 12, 12);
        LayoutManager.gamemode.icons[2] = new Image(48, 12, 12, 12);
        LayoutManager.rain.icon = new Image(0, 12, 12, 12);
        LayoutManager.magnet.icon = new Image(60, 24, 12, 12);
        LayoutManager.timeButtons[0].icon = new Image(12, 24, 12, 12);
        LayoutManager.timeButtons[1].icon = new Image(0, 24, 12, 12);
        LayoutManager.timeButtons[2].icon = new Image(24, 24, 12, 12);
        LayoutManager.timeButtons[3].icon = new Image(36, 24, 12, 12);
        LayoutManager.heal.icon = new Image(48, 24, 12, 12);
        LayoutManager.dropDown.x = 93;
    }

    @Override
    public void reset() {
        this.clickButtonCount = 0;
        this.stateButtonCount = 0;
    }

    @Override
    public void layoutButton(Button button) {
        int offsetx = 2;
        int offsety = 2;
        if ((button.state & 4) != 0) {
            button.x = offsetx + this.stateButtonCount * 22;
            button.y = offsety;
            ++this.stateButtonCount;
        } else {
            button.x = offsetx + this.clickButtonCount % 4 * 22;
            button.y = offsety + (1 + this.clickButtonCount / 4) * 17;
            ++this.clickButtonCount;
        }
        button.height = 14;
        button.width = button.contentWidth() + 2;
        if ((button.state & 4) != 0) {
            button.width += LayoutStyleTMIOld.stateOff.width;
        }
    }

    @Override
    public void drawBackground(GuiContainerManager gui) {
        if (this.clickButtonCount == 0 && this.stateButtonCount == 0) {
            return;
        }
        int maxx = Math.max(this.stateButtonCount, this.clickButtonCount);
        if (maxx > 4) {
            maxx = 4;
        }
        int maxy = this.clickButtonCount == 0 ? 1 : this.clickButtonCount / 4 + 2;
        GuiDraw.drawRect((int)0, (int)0, (int)(2 + 22 * maxx), (int)(1 + maxy * 17), (int)-16777216);
    }

    @Override
    public void drawButton(Button b, int mousex, int mousey) {
        int cwidth = b.contentWidth();
        if ((b.state & 4) != 0) {
            cwidth += LayoutStyleTMIOld.stateOff.width;
        }
        int textx = b.x + (b.width - cwidth) / 2;
        int texty = b.y + (b.height - 8) / 2;
        GuiDraw.drawRect((int)b.x, (int)b.y, (int)b.width, (int)b.height, (int)(b.contains(mousex, mousey) ? -297791480 : -301989888));
        Image icon = b.getRenderIcon();
        if (icon == null) {
            GuiDraw.drawString((String)b.getRenderLabel(), (int)textx, (int)texty, (int)-1);
        } else {
            int icony = b.y + (b.height - icon.height) / 2;
            LayoutManager.drawIcon(textx, icony, icon);
            if ((b.state & 3) == 2) {
                GuiDraw.drawRect((int)textx, (int)icony, (int)icon.width, (int)icon.height, (int)Integer.MIN_VALUE);
            }
            if ((b.state & 4) != 0) {
                Image stateimage = (b.state & 3) == 1 ? stateOn : ((b.state & 3) == 2 ? stateDisabled : stateOff);
                LayoutManager.drawIcon(textx + icon.width, icony, stateimage);
            }
        }
    }

    @Override
    public boolean texturedButtons() {
        return false;
    }
}

