/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.IChargeConductor;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataInPacket;
import factorization.api.datahelpers.DataInPacketClientEdited;
import factorization.api.datahelpers.DataOutNBT;
import factorization.api.datahelpers.DataOutPacket;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.servo.LoggerDataHelper;
import factorization.servo.ServoMotor;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.TileEntityCommon;
import factorization.sockets.GuiDataConfig;
import factorization.sockets.ISocketHolder;
import factorization.sockets.SocketEmpty;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class TileEntitySocketBase
extends TileEntityCommon
implements ISocketHolder,
IDataSerializable {
    public static Random rand = new Random();
    public ForgeDirection facing = ForgeDirection.UP;
    private static final Vec3 nullVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private static float[] pitch = new float[]{-90.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static float[] yaw = new float[]{0.0f, 0.0f, 180.0f, 0.0f, 90.0f, -90.0f, 0.0f};

    @Override
    public final BlockClass getBlockClass() {
        return BlockClass.Socket;
    }

    @Override
    public final byte getExtraInfo() {
        return (byte)this.facing.ordinal();
    }

    @Override
    public final void useExtraInfo(byte b) {
        this.facing = ForgeDirection.getOrientation((int)b);
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        super.onPlacedBy(player, is, side);
        this.facing = ForgeDirection.getOrientation((int)side);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.facing = ForgeDirection.getOrientation((int)tag.func_74771_c("fc"));
        try {
            this.serialize("", new DataInNBT(tag));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74774_a("fc", (byte)this.facing.ordinal());
        try {
            this.serialize("", new DataOutNBT(tag));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean sanitize(ServoMotor motor) {
        LoggerDataHelper dh = new LoggerDataHelper(motor);
        try {
            this.serialize("", dh);
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        return dh.hadError;
    }

    protected Iterable<Entity> getEntities(ISocketHolder socket, Coord c, ForgeDirection top, int d) {
        Entity ent = null;
        if (socket instanceof Entity) {
            ent = (Entity)socket;
        }
        int one = 1;
        AxisAlignedBB ab = AxisAlignedBB.func_72332_a().func_72299_a((double)(c.x + top.offsetX), (double)(c.y + top.offsetY), (double)(c.z + top.offsetZ), (double)(c.x + one + top.offsetX), (double)(c.y + one + top.offsetY), (double)(c.z + one + top.offsetZ));
        if (d != 0) {
            ab.field_72340_a -= (double)d;
            ab.field_72338_b -= (double)d;
            ab.field_72339_c -= (double)d;
            ab.field_72336_d += (double)d;
            ab.field_72337_e += (double)d;
            ab.field_72334_f += (double)d;
            if (top.offsetX + top.offsetY + top.offsetZ > 1) {
                ab.field_72340_a += (double)(d * top.offsetX);
                ab.field_72338_b += (double)(d * top.offsetY);
                ab.field_72339_c += (double)(d * top.offsetZ);
            } else {
                ab.field_72336_d -= (double)(d * top.offsetX);
                ab.field_72337_e -= (double)(d * top.offsetY);
                ab.field_72334_f -= (double)(d * top.offsetZ);
            }
        }
        return this.field_70331_k.func_72839_b(ent, ab);
    }

    protected final boolean rayTrace(ISocketHolder socket, Coord coord, FzOrientation orientation, boolean powered, boolean lookAround, boolean onlyFirst) {
        ForgeDirection top = orientation.top;
        ForgeDirection face = orientation.facing;
        ForgeDirection right = face.getRotation(top);
        for (Entity entity : this.getEntities(socket, coord, top, 0)) {
            if (entity == socket || !this.handleRay(socket, new MovingObjectPosition(entity), false, powered)) continue;
            return true;
        }
        TileEntitySocketBase.nullVec.field_72449_c = 0.0;
        TileEntitySocketBase.nullVec.field_72448_b = 0.0;
        TileEntitySocketBase.nullVec.field_72450_a = 0.0;
        Coord targetBlock = coord.add(top);
        if (this.mopBlock(targetBlock, top.getOpposite(), socket, false, powered)) {
            return true;
        }
        if (onlyFirst) {
            return false;
        }
        if (this.mopBlock(targetBlock.add(top), top.getOpposite(), socket, false, powered)) {
            return true;
        }
        if (this.mopBlock(coord, top, socket, true, powered)) {
            return true;
        }
        if (!lookAround) {
            return false;
        }
        if (this.mopBlock(targetBlock.add(face), face.getOpposite(), socket, false, powered)) {
            return true;
        }
        if (this.mopBlock(targetBlock.add(face.getOpposite()), face, socket, false, powered)) {
            return true;
        }
        if (this.mopBlock(targetBlock.add(right), right.getOpposite(), socket, false, powered)) {
            return true;
        }
        return this.mopBlock(targetBlock.add(right.getOpposite()), right, socket, false, powered);
    }

    boolean mopBlock(Coord target, ForgeDirection side, ISocketHolder socket, boolean mopIsThis, boolean powered) {
        TileEntitySocketBase.nullVec.field_72450_a = this.field_70329_l + side.offsetX;
        TileEntitySocketBase.nullVec.field_72448_b = this.field_70330_m + side.offsetY;
        TileEntitySocketBase.nullVec.field_72449_c = this.field_70327_n + side.offsetZ;
        return this.handleRay(socket, target.createMop(side, nullVec), mopIsThis, powered);
    }

    @Override
    public final ForgeDirection[] getValidRotations() {
        return full_rotation_array;
    }

    @Override
    public final boolean rotate(ForgeDirection axis) {
        if (axis == this.facing) {
            return false;
        }
        this.facing = axis;
        return true;
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return side == this.facing.getOpposite().ordinal();
    }

    @Override
    public final void sendMessage(int msgType, Object ... msg) {
        this.broadcastMessage(null, msgType, msg);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        if (dir == this.facing || dir.getOpposite() == this.facing) {
            return BlockIcons.socket$face;
        }
        return BlockIcons.socket$side;
    }

    protected boolean isBlockPowered() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean dumpBuffer(List<ItemStack> buffer) {
        if (buffer.size() == 0) {
            return false;
        }
        ItemStack is = buffer.get(0);
        if (is == null) {
            buffer.remove(0);
            return true;
        }
        Coord here = this.getCoord();
        here.adjust(this.facing.getOpposite());
        IInventory invTe = here.getTE(IInventory.class);
        if (invTe == null) {
            return true;
        }
        FzUtil.FzInv inv = FzUtil.openInventory(invTe, this.facing);
        if (inv == null) {
            return true;
        }
        int origSize = is.field_77994_a;
        int newSize = 0;
        if (inv.push(is) == null) {
            buffer.remove(0);
        } else {
            newSize = is.field_77994_a;
        }
        if (origSize != newSize) {
            this.func_70296_d();
        }
        return !buffer.isEmpty();
    }

    public void func_70316_g() {
        this.genericUpdate(this, this.getCoord(), this.isBlockPowered());
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        this.uninstall();
        if (!(this instanceof SocketEmpty)) {
            this.getCoord().spawnItem(new ItemStack((Item)Core.registry.socket_part, 1, this.getFactoryType().md));
        }
    }

    @Override
    public ItemStack getPickedBlock() {
        if (this instanceof SocketEmpty) {
            return FactoryType.SOCKET_EMPTY.itemStack();
        }
        return new ItemStack((Item)Core.registry.socket_part, 1, this.getFactoryType().md);
    }

    @Override
    public ItemStack getDroppedBlock() {
        return FactoryType.SOCKET_EMPTY.itemStack();
    }

    protected EntityPlayer getFakePlayer() {
        int i;
        EntityPlayer player = FzUtil.makePlayer(this.getCoord(), "socket");
        player.field_70170_p = this.field_70331_k;
        player.field_70169_q = player.field_70165_t = (double)this.field_70329_l + 0.5 + (double)this.facing.offsetX;
        player.field_70167_r = player.field_70163_u = (double)this.field_70330_m + 0.5 - (double)player.func_70047_e() + (double)this.facing.offsetY;
        player.field_70166_s = player.field_70161_v = (double)this.field_70327_n + 0.5 + (double)this.facing.offsetZ;
        for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            player.field_71071_by.field_70462_a[i] = null;
        }
        i = this.facing.ordinal();
        player.field_70125_A = player.field_70127_C = pitch[i];
        player.field_70177_z = player.field_70126_B = yaw[i];
        return player;
    }

    protected IInventory getBackingInventory(ISocketHolder socket) {
        if (socket == this) {
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l - this.facing.offsetX, this.field_70330_m - this.facing.offsetY, this.field_70327_n - this.facing.offsetZ);
            if (te instanceof IInventory) {
                return (IInventory)te;
            }
            return null;
        }
        if (socket instanceof IInventory) {
            return (IInventory)socket;
        }
        return null;
    }

    @Override
    public boolean extractCharge(int amount) {
        if (this instanceof IChargeConductor) {
            IChargeConductor cc = (IChargeConductor)((Object)this);
            return cc.getCharge().tryTake(amount) >= amount;
        }
        return false;
    }

    public void genericUpdate(ISocketHolder socket, Coord coord, boolean powered) {
    }

    @Override
    public abstract FactoryType getFactoryType();

    public abstract boolean canUpdate();

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 4) {
            if (!this.field_70331_k.field_72995_K) {
                return false;
            }
            DataInPacket dip = new DataInPacket(input, Side.CLIENT);
            this.serialize("", dip);
            Minecraft.func_71410_x().func_71373_a((GuiScreen)new GuiDataConfig(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromClient(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromClient(messageType, input)) {
            return true;
        }
        if (messageType == 3) {
            DataInPacketClientEdited di = new DataInPacketClientEdited(input);
            this.serialize("", di);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean handleRay(ISocketHolder socket, MovingObjectPosition mop, boolean mopIsThis, boolean powered) {
        return true;
    }

    public void uninstall() {
    }

    @Override
    public boolean activate(EntityPlayer player, ForgeDirection side) {
        if (this.field_70331_k.field_72995_K) {
            return false;
        }
        ItemStack held = player.func_70694_bm();
        if (held == null) {
            return false;
        }
        if (held.func_77973_b() != Core.registry.logicMatrixProgrammer) {
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        DataOutPacket dop = new DataOutPacket(dos, Side.SERVER);
        try {
            Coord coord = this.getCoord();
            Core.network.prefixTePacket(dos, coord, 4);
            this.serialize("", dop);
            Core.network.broadcastPacket(player, coord, Core.network.TEmessagePacket(baos));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean activateOnServo(EntityPlayer player, ServoMotor motor) {
        if (this.field_70331_k.field_72995_K) {
            return false;
        }
        ItemStack held = player.func_70694_bm();
        if (held == null) {
            return false;
        }
        if (held.func_77973_b() != Core.registry.logicMatrixProgrammer) {
            return false;
        }
        if (!this.getFactoryType().hasGui) {
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        DataOutPacket dop = new DataOutPacket(dos, Side.SERVER);
        try {
            Coord coord = this.getCoord();
            Core.network.prefixEntityPacket(dos, motor, 4);
            this.serialize("", dop);
            Core.network.broadcastPacket(player, coord, Core.network.entityPacket(baos));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTesr(ServoMotor motor, float partial) {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(ServoMotor motor, Tessellator tess) {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInServo(ServoMotor motor, float partial) {
        float s = 0.75f;
        GL11.glScalef((float)s, (float)s, (float)s);
        float d = -0.5f;
        float y = -0.125f;
        GL11.glTranslatef((float)d, (float)y, (float)d);
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        this.renderTesr(motor, partial);
        GL11.glPopMatrix();
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        this.renderStatic(motor, tess);
        tess.func_78381_a();
        GL11.glTranslatef((float)(-d), (float)(-y), (float)(-d));
        GL11.glEnable((int)2896);
    }
}

