/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.servo.ServoMotor;
import factorization.shared.BlockRenderHelper;
import factorization.shared.FzUtil;
import factorization.sockets.ISocketHolder;
import factorization.sockets.TileEntitySocketBase;
import java.io.IOException;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;

public class SocketShifter
extends TileEntitySocketBase {
    public ShifterMode mode = ShifterMode.MODE_STREAM;
    public int foreignSlot = -1;
    public boolean exporting = true;
    public byte transferLimit = 1;
    byte cooldown = 0;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOCKET_SHIFTER;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.exporting = data.as(Share.MUTABLE, "exp").putBoolean(this.exporting);
        this.mode = data.hasLegacy("strm") ? (data.as(Share.MUTABLE, "strm").putBoolean(true) ? ShifterMode.MODE_STREAM : ShifterMode.MODE_PULSE_EXACT) : data.as(Share.MUTABLE, "mode").putEnum(this.mode);
        this.transferLimit = data.as(Share.MUTABLE, "lim").putByte(this.transferLimit);
        this.foreignSlot = data.as(Share.MUTABLE, "for").putInt(this.foreignSlot);
        this.cooldown = data.as(Share.PRIVATE, "wait").putByte(this.cooldown);
        if (data.isWriter()) {
            return this;
        }
        if (this.mode == ShifterMode.MODE_STREAM && this.transferLimit != 1) {
            this.transferLimit = 1;
            data.log("transfer limit must be 1 in stream mode");
        }
        if (this.foreignSlot < -1) {
            this.foreignSlot = -1;
            data.log("foreign slot was < -1");
        }
        if (this.transferLimit > 64) {
            this.transferLimit = (byte)64;
            data.log("transfer limit was > 64");
        }
        if (this.transferLimit < 1) {
            this.transferLimit = 1;
            data.log("transfer limit was < 1");
        }
        return this;
    }

    @Override
    public void genericUpdate(ISocketHolder socket, Coord coord, boolean powered) {
        boolean had_change;
        FzUtil.FzInv pushInv;
        FzUtil.FzInv pullInv;
        block39: {
            int pushEnd;
            int pushStart;
            int pullEnd;
            int pullStart;
            FzUtil.FzInv localInv;
            if (this.field_70331_k.field_72995_K) {
                return;
            }
            if (this.mode == ShifterMode.MODE_STREAM) {
                if (this.cooldown > 0) {
                    this.cooldown = (byte)(this.cooldown - 1);
                    return;
                }
                if (!powered) {
                    return;
                }
            } else {
                if (!powered && this.cooldown > 0) {
                    this.cooldown = (byte)(this.cooldown - 1);
                    return;
                }
                if (this.cooldown > 0) {
                    return;
                }
                if (!powered) {
                    return;
                }
            }
            ForgeDirection back = this.facing.getOpposite();
            if (socket != this) {
                localInv = FzUtil.openInventory((IInventory)socket, this.facing);
            } else {
                coord.adjust(back);
                localInv = FzUtil.openInventory(coord.getTE(IInventory.class), this.facing);
                coord.adjust(this.facing);
            }
            if (localInv == null) {
                return;
            }
            coord.adjust(this.facing);
            FzUtil.FzInv foreignInv = FzUtil.openInventory(coord.getTE(IInventory.class), back);
            coord.adjust(back);
            if (foreignInv == null) {
                ForgeDirection top = this.facing;
                for (Entity entity : this.getEntities(socket, coord, top, 0)) {
                    if (entity instanceof IInventory && (foreignInv = FzUtil.openInventory(entity, false)) != null) break;
                }
                if (foreignInv == null) {
                    return;
                }
            }
            if (this.foreignSlot >= foreignInv.size()) {
                return;
            }
            if (this.exporting) {
                pullInv = localInv;
                pushInv = foreignInv;
                pullStart = 0;
                pullEnd = localInv.size() - 1;
                if (this.foreignSlot == -1) {
                    pushStart = 0;
                    pushEnd = foreignInv.size() - 1;
                } else {
                    pushStart = pushEnd = this.foreignSlot;
                }
            } else {
                pullInv = foreignInv;
                pushInv = localInv;
                pushStart = 0;
                pushEnd = localInv.size() - 1;
                if (this.foreignSlot == -1) {
                    pullStart = 0;
                    pullEnd = foreignInv.size() - 1;
                } else {
                    pullStart = pullEnd = this.foreignSlot;
                }
            }
            pushInv.setCallOnInventoryChanged(false);
            pullInv.setCallOnInventoryChanged(false);
            had_change = false;
            if (this.mode == ShifterMode.MODE_PULSE_SOME) {
                int toMove = this.transferLimit;
                for (int pull = pullStart; pull <= pullEnd; ++pull) {
                    int delta;
                    int push;
                    for (push = 0; push < pushInv.size(); ++push) {
                        if (pushInv.get(push) == null) continue;
                        delta = pullInv.transfer(pull, pushInv, push, toMove);
                        toMove -= delta;
                        if (delta > 0) {
                            had_change = true;
                        }
                        if (toMove > 0) {
                            continue;
                        }
                        break block39;
                    }
                    if (toMove <= 0) break;
                    for (push = 0; push < pushInv.size(); ++push) {
                        if (pushInv.get(push) != null) continue;
                        delta = pullInv.transfer(pull, pushInv, push, toMove);
                        toMove -= delta;
                        if (delta > 0) {
                            had_change = true;
                        }
                        if (toMove > 0) {
                            continue;
                        }
                        break block39;
                    }
                    if (!had_change) {
                        continue;
                    }
                    break;
                }
            } else {
                boolean[] visitedSlots = new boolean[pullInv.size()];
                for (int pull = pullStart; pull <= pullEnd; ++pull) {
                    ItemStack is;
                    int freeForIs;
                    if (this.countItem(pullInv, pull, this.transferLimit, visitedSlots) < this.transferLimit || (freeForIs = pushInv.getFreeSpaceFor(is = pullInv.get(pull), this.transferLimit)) < this.transferLimit) continue;
                    had_change = true;
                    int limit = this.transferLimit;
                    block5: for (int i = pull; i <= pullEnd; ++i) {
                        if (!FzUtil.couldMerge(is, pullInv.get(i))) continue;
                        while (limit > 0) {
                            int delta;
                            int push;
                            int origLimit = limit;
                            for (push = pushStart; push <= pushEnd; ++push) {
                                if (pushInv.get(push) == null || (limit -= (delta = pullInv.transfer(i, pushInv, push, limit))) > 0) {
                                    continue;
                                }
                                break block39;
                            }
                            if (limit <= 0) break block39;
                            for (push = pushStart; push <= pushEnd; ++push) {
                                if (pushInv.get(push) != null || (limit -= (delta = pullInv.transfer(i, pushInv, push, limit))) > 0) {
                                    continue;
                                }
                                break block39;
                            }
                            if (limit != origLimit) continue;
                            continue block5;
                        }
                    }
                    break;
                }
            }
        }
        if (had_change) {
            pullInv.setCallOnInventoryChanged(true);
            pushInv.setCallOnInventoryChanged(true);
            pullInv.onInvChanged();
            pushInv.onInvChanged();
        }
        this.cooldown = (byte)(this.mode == ShifterMode.MODE_STREAM ? 8 : 1);
    }

    int countItem(FzUtil.FzInv inv, int start, int minimum, boolean[] visitedSlots) {
        if (visitedSlots[start]) {
            return 0;
        }
        visitedSlots[start] = true;
        ItemStack seed = inv.get(start);
        if (seed == null || seed.field_77994_a == 0) {
            return 0;
        }
        if (!inv.canExtract(start, seed)) {
            return 0;
        }
        int count = seed.field_77994_a;
        if (count >= minimum) {
            return count;
        }
        for (int i = ++start; i < inv.size(); ++i) {
            if (visitedSlots[i]) continue;
            ItemStack is = inv.get(i);
            if (is == null) {
                visitedSlots[i] = true;
                continue;
            }
            if (!FzUtil.couldMerge(seed, is)) continue;
            visitedSlots[i] = true;
            if (!inv.canExtract(i, is) || (count += is.field_77994_a) < minimum) continue;
            return count;
        }
        return count;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(ServoMotor motor, Tessellator tess) {
        BlockRenderHelper block = BlockRenderHelper.instance;
        block.useTextures(BlockIcons.socket$shifter_front, null, BlockIcons.socket$shifter_side, BlockIcons.socket$shifter_side, BlockIcons.socket$shifter_side, BlockIcons.socket$shifter_side, BlockIcons.socket$shifter_side, BlockIcons.socket$shifter_side);
        float[] minYs = new float[]{0.5f, 0.1875f, -0.125f};
        float[] ds = new float[]{0.25f, 0.3125f, 0.375f};
        int end = ds.length;
        if (motor != null) {
            --end;
        }
        for (int i = 0; i < end; ++i) {
            float d = ds[i];
            float minY = minYs[i];
            block.func_71905_a(d, minY, d, 1.0f - d, 0.75f, 1.0f - d);
            block.begin();
            block.rotateCenter(Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite())));
            block.renderRotated(tess, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public static enum ShifterMode {
        MODE_STREAM,
        MODE_PULSE_EXACT,
        MODE_PULSE_SOME;

    }
}

