/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.ChargeMetalBlockConductance;
import factorization.charge.TileEntitySolarBoiler;
import factorization.common.FactorizationProxy;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.common.Registry;
import factorization.compat.CompatManager;
import factorization.oreprocessing.FactorizationOreProcessingHandler;
import factorization.servo.ServoMotor;
import factorization.shared.ItemFactorization;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityFzNull;
import factorization.wrath.TileEntityWrathFire;
import factorization.wrath.TileEntityWrathLamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="factorization", name="Factorization", version="0.8.29")
@NetworkMod(clientSideRequired=true, tinyPacketHandler=NetworkFactorization.class)
public class Core {
    public static final String modId = "factorization";
    public static final String name = "Factorization";
    public static final String version = "0.8.29";
    public static Core instance;
    public static FzConfig fzconfig;
    public static Registry registry;
    public static FactorizationOreProcessingHandler foph;
    @SidedProxy(clientSide="factorization.common.FactorizationClientProxy", serverSide="factorization.common.FactorizationProxy")
    public static FactorizationProxy proxy;
    public static NetworkFactorization network;
    public static int factory_rendertype;
    public static boolean finished_loading;
    public static boolean cheat;
    public static boolean cheat_servo_energy;
    public static boolean debug_network;
    public static boolean show_fine_logging;
    public static boolean dev_environ;
    public static boolean serverStarted;
    public static Logger FZLogger;
    static ThreadLocal<Boolean> isMainClientThread;
    static ThreadLocal<Boolean> isMainServerThread;
    public static final String hintFormat;
    public static final String shiftFormat;
    public static CreativeTabs tabFactorization;
    public static final String texture_dir = "factorization:";
    public static final String model_dir = "/mods/factorization/models/";
    public static final String real_texture_dir = "/mods/factorization/textures/";
    public static final String gui_dir = "/mods/factorization/textures/gui/";
    public static final String gui_nei = "factorization:textures/gui/";
    public static final ResourceLocation blockAtlas;
    public static final ResourceLocation itemAtlas;
    public static Icon blockMissingIcon;
    public static Icon itemMissingIcon;

    public Core() {
        instance = this;
        fzconfig = new FzConfig();
        registry = new Registry();
        foph = new FactorizationOreProcessingHandler();
    }

    void checkForge() {
        int maxForge = 953;
        if (ForgeVersion.getBuildVersion() > maxForge && ForgeVersion.getBuildVersion() != 965) {
            if (System.getProperty("factorization.ignoreForgeVersion", "").equalsIgnoreCase("true")) {
                Core.logSevere("Loading despite scary-looking forge version > " + maxForge, new Object[0]);
            } else {
                String msg = "This forge is for pre-1.7 use only! The Forge version must be <= " + maxForge + ".\n" + "Get a compatible forge from http://files.minecraftforge.net/minecraftforge/index_legacy.html\n" + "You can force loading to continue by passing -Dfactorization.ignoreForgeVersion=true to the JVM.";
                Core.logSevere(msg, new Object[0]);
                throw new RuntimeException(msg);
            }
        }
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)registry);
        this.checkForge();
        fzconfig.loadConfig(event.getSuggestedConfigurationFile());
        registry.makeBlocks();
        TickRegistry.registerTickHandler((ITickHandler)registry, (Side)Side.SERVER);
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        this.registerSimpleTileEntities();
        registry.makeItems();
        FzConfig.config.save();
        registry.makeRecipes();
        registry.setToolEffectiveness();
        proxy.registerKeys();
        proxy.registerRenderers();
        FzConfig.config.save();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            isMainClientThread.set(true);
        }
    }

    void registerSimpleTileEntities() {
        FactoryType.registerTileEntities();
        GameRegistry.registerTileEntity(TileEntityFzNull.class, (String)"fz.null");
        EntityRegistry.registerModEntity(TileEntityWrathLamp.RelightTask.class, (String)"factory_relight_task", (int)0, (Object)instance, (int)1, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(ServoMotor.class, (String)"factory_servo", (int)1, (Object)instance, (int)100, (int)1, (boolean)true);
    }

    @Mod.EventHandler
    public void handleInteractions(FMLInitializationEvent event) {
        registry.sendIMC();
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        TileEntityWrathFire.setupBurning();
        TileEntitySolarBoiler.setupSteam();
        foph.addDictOres();
        registry.addOtherRecipes();
        new CompatManager().loadCompat();
        ChargeMetalBlockConductance.setup();
        for (FactoryType ft : FactoryType.values()) {
            ft.getRepresentative();
        }
        finished_loading = true;
    }

    @Mod.EventHandler
    public void registerServerCommands(FMLServerStartingEvent event) {
        isMainServerThread.set(true);
        serverStarted = true;
    }

    ItemStack getExternalItem(String className, String classField, String description) {
        try {
            Class<?> c = Class.forName(className);
            return (ItemStack)c.getField(classField).get(null);
        }
        catch (Exception err) {
            Core.logWarning("Could not get %s (from %s.%s)", description, className, classField);
            return null;
        }
    }

    public static void logWarning(String format, Object ... formatParameters) {
        FZLogger.log(Level.WARNING, String.format(format, formatParameters));
    }

    public static void logInfo(String format, Object ... formatParameters) {
        FZLogger.log(Level.INFO, String.format(format, formatParameters));
    }

    public static void logFine(String format, Object ... formatParameters) {
        FZLogger.log(dev_environ ? Level.INFO : Level.FINE, String.format(format, formatParameters));
    }

    public static void logSevere(String format, Object ... formatParameters) {
        FZLogger.log(Level.SEVERE, String.format(format, formatParameters));
    }

    public static void addBlockToCreativeList(List tab, Block block) {
        ArrayList a = new ArrayList();
        block.addCreativeItems(a);
        for (Object o : a) {
            if (o == null) continue;
            tab.add(o);
        }
    }

    public static void profileStart(String section) {
        if (isMainClientThread.get().booleanValue()) {
            proxy.getProfiler().func_76320_a(section);
        }
    }

    public static void profileEnd() {
        if (isMainClientThread.get().booleanValue()) {
            proxy.getProfiler().func_76319_b();
        }
    }

    public static void profileStartRender(String section) {
        Core.profileStart(modId);
        Core.profileStart(section);
    }

    public static void profileEndRender() {
        Core.profileEnd();
        Core.profileEnd();
    }

    private static void addTranslationHints(String hint_key, List list, String prefix) {
        String hint;
        if (StatCollector.func_94522_b((String)hint_key) && (hint = StatCollector.func_74838_a((String)hint_key)) != null && (hint = hint.trim()).length() > 0) {
            for (String s : hint.split("\\\\n")) {
                list.add(prefix + s);
            }
        }
    }

    public static void brand(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        Item it = is.func_77973_b();
        String name2 = it.func_77667_c(is);
        Core.addTranslationHints(name2 + ".hint", list, hintFormat);
        if (player != null && proxy.isClientHoldingShift()) {
            Core.addTranslationHints(name2 + ".shift", list, shiftFormat);
        }
        ArrayList<String> untranslated = new ArrayList<String>();
        if (it instanceof ItemFactorization) {
            ((ItemFactorization)it).addExtraInformation(is, player, untranslated, verbose);
        }
        String brand = "";
        if (FzConfig.add_branding) {
            brand = brand + name;
        }
        if (cheat) {
            brand = brand + " Cheat mode!";
        }
        if (dev_environ) {
            brand = brand + " Development!";
        }
        if (brand.length() > 0) {
            untranslated.add(EnumChatFormatting.BLUE + brand.trim());
        }
        for (String s : untranslated) {
            list.add(StatCollector.func_74838_a((String)s));
        }
    }

    public static Item tab(Item item, TabType tabType) {
        item.func_77637_a(tabFactorization);
        return item;
    }

    public static Block tab(Block block, TabType tabType) {
        block.func_71849_a(tabFactorization);
        return block;
    }

    public static String getProperKey(ItemStack is) {
        String n = is.func_77977_a();
        if (n == null || n.length() == 0) {
            n = "???";
        }
        return n;
    }

    public static String getTranslationKey(ItemStack is) {
        if (is == null) {
            return "<null itemstack; bug?>";
        }
        try {
            String s = is.func_82833_r();
            if (s != null && s.length() > 0) {
                return s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String key = Core.getProperKey(is);
        if (Core.canTranslate(key + ".name")) {
            return key + ".name";
        }
        if (Core.canTranslate(key)) {
            return key;
        }
        return key + ".name";
    }

    static boolean canTranslate(String str) {
        String ret = StatCollector.func_74838_a((String)str);
        if (ret == null || ret.length() == 0) {
            return false;
        }
        return !ret.equals(str);
    }

    public static String getTranslationKey(Item i) {
        if (i == null) {
            return "<null item; bug?>";
        }
        return i.func_77658_a() + ".name";
    }

    public static String translate(String key) {
        return ("" + StatCollector.func_74838_a((String)(key + ".name"))).trim();
    }

    public static String translateThis(String key) {
        return ("" + StatCollector.func_74838_a((String)key)).trim();
    }

    public static String translateExact(String key) {
        String ret = StatCollector.func_74838_a((String)key);
        if (ret == key) {
            return null;
        }
        return ret;
    }

    public static String tryTranslate(String key, String fallback) {
        String ret = Core.translateExact(key);
        if (ret == null) {
            return fallback;
        }
        return ret;
    }

    public static boolean canTranslateExact(String key) {
        return Core.translateExact(key) != null;
    }

    public static String translateWithCorrectableFormat(String key, Object ... params) {
        String format = Core.translate(key);
        String ret = String.format(format, params);
        String correctedTranslation = Core.translateExact("factorization.replace:" + ret);
        if (correctedTranslation != null) {
            return correctedTranslation;
        }
        return ret;
    }

    public static void sendChatMessage(boolean raw, ICommandSender sender, String msg) {
        sender.func_70006_a(raw ? ChatMessageComponent.func_111066_d((String)msg) : ChatMessageComponent.func_111077_e((String)msg));
    }

    public static void sendUnlocalizedChatMessage(ICommandSender sender, String format, Object ... params) {
        sender.func_70006_a(ChatMessageComponent.func_111082_b((String)format, (Object[])params));
    }

    @SideOnly(value=Side.CLIENT)
    public static Icon texture(IconRegister reg, String name2) {
        name2 = name2.replace('.', '/');
        return reg.func_94245_a(texture_dir + name2);
    }

    public static ResourceLocation getResource(String name2) {
        return new ResourceLocation(modId, name2);
    }

    @SideOnly(value=Side.CLIENT)
    public static void bindGuiTexture(String name2) {
        TextureManager tex = Minecraft.func_71410_x().field_71446_o;
        tex.func_110577_a(Core.getResource("textures/gui/" + name2 + ".png"));
    }

    static {
        factory_rendertype = -1;
        finished_loading = false;
        cheat = false;
        cheat_servo_energy = false;
        debug_network = false;
        show_fine_logging = false;
        dev_environ = (Boolean)ReflectionHelper.getPrivateValue(CoreModManager.class, null, (String[])new String[]{"deobfuscatedEnvironment"});
        if (!dev_environ) {
            cheat = false;
            cheat_servo_energy = false;
        }
        serverStarted = false;
        FZLogger = Logger.getLogger("FZ");
        FZLogger.setParent(FMLLog.getLogger());
        Core.logInfo("This is Factorization 0.8.29", new Object[0]);
        isMainClientThread = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        isMainServerThread = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        hintFormat = "" + EnumChatFormatting.DARK_PURPLE;
        shiftFormat = "" + EnumChatFormatting.DARK_GRAY + EnumChatFormatting.ITALIC;
        tabFactorization = new CreativeTabs("factorizationTab"){

            public Item func_78016_d() {
                return Core.registry.logicMatrixProgrammer;
            }
        };
        blockAtlas = new ResourceLocation("textures/atlas/blocks.png");
        itemAtlas = new ResourceLocation("textures/atlas/items.png");
    }

    public static enum TabType {
        ART,
        CHARGE,
        OREP,
        SERVOS,
        ROCKETRY,
        TOOLS,
        BLOCKS,
        MATERIALS;

    }
}

