/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockComparator;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHalfSlab;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockMushroomCap;
import net.minecraft.block.BlockNetherStalk;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockTripWire;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockHelper {
    static BlockStyle getBlockStyle(Block block) {
        return BlockHelper.classifyBlock(block);
    }

    private static BlockStyle classifyBlock(Block block) {
        if (block == Block.field_72009_bg) {
            return BlockStyle.CAKE;
        }
        if (block == Block.field_72047_aN || block == Block.field_72048_aO) {
            return BlockStyle.REDSTONE_ORE;
        }
        if (block == Block.field_72099_aa) {
            return BlockStyle.PISTON_EXTENSION;
        }
        if (block == Block.field_71999_bt || block == Block.field_71996_bs) {
            return BlockStyle.STEM;
        }
        if (block instanceof BlockSign || block instanceof BlockFlowerPot || block instanceof BlockRedstoneWire || block instanceof BlockBrewingStand || block instanceof BlockReed || block instanceof BlockTripWire || block instanceof BlockCauldron || block instanceof BlockRedstoneRepeater || block instanceof BlockComparator || block instanceof BlockRedstoneTorch || block instanceof BlockFarmland || block instanceof BlockFurnace || block instanceof BlockMushroomCap || block instanceof BlockRedstoneLight) {
            return BlockStyle.USE_ID_DROPPED;
        }
        if (block instanceof BlockCocoa || block instanceof BlockNetherStalk || block instanceof BlockSkull) {
            return BlockStyle.USE_GET_BLOCK_DROPPED;
        }
        if (block instanceof BlockPistonMoving || block instanceof BlockPortal || block instanceof BlockEndPortal || block instanceof BlockSilverfish || block instanceof BlockMobSpawner) {
            return BlockStyle.NOTHING;
        }
        if (block instanceof BlockOre) {
            return BlockStyle.CLONE_MD;
        }
        if (block instanceof BlockHalfSlab) {
            return BlockStyle.SLAB;
        }
        if (block instanceof BlockCrops) {
            return BlockStyle.CROP;
        }
        if (block instanceof BlockBed) {
            return BlockStyle.BED;
        }
        if (block instanceof BlockDoor) {
            return BlockStyle.DOOR;
        }
        return BlockStyle.USE_GET_DAMAGE_VALUE;
    }

    private static ItemStack makeItemStack(int itemId, int stackSize, int damage) {
        if (itemId == 0) {
            return null;
        }
        return new ItemStack(itemId, stackSize, damage);
    }

    public static ItemStack getPlacingItem(Block block, MovingObjectPosition target, World world, int x, int y, int z) {
        switch (BlockHelper.classifyBlock(block)) {
            default: {
                return null;
            }
            case USE_GET_DAMAGE_VALUE: {
                return new ItemStack(block, 1, block.func_71873_h(world, x, y, z));
            }
            case USE_ID_DROPPED: 
            case BED: {
                int md = world.func_72805_g(x, y, z);
                return BlockHelper.makeItemStack(block.func_71885_a(md, world.field_73012_v, 0), 1, 0);
            }
            case USE_GET_BLOCK_DROPPED: {
                int md = world.func_72805_g(x, y, z);
                ArrayList drops = block.getBlockDropped(world, x, y, z, md, 0);
                if (drops.isEmpty()) {
                    return null;
                }
                return (ItemStack)drops.get(0);
            }
            case CLONE_MD: {
                int md = world.func_72805_g(x, y, z);
                return new ItemStack(block, 1, md);
            }
            case STEM: {
                if (block == Block.field_71996_bs) {
                    return new ItemStack(Item.field_77739_bg);
                }
                if (block == Block.field_71999_bt) {
                    return new ItemStack(Item.field_77740_bh);
                }
                return null;
            }
            case SLAB: {
                int md = world.func_72805_g(x, y, z);
                int slabId = block.func_71885_a(md, world.field_73012_v, 0);
                int dropped = block.func_71925_a(world.field_73012_v);
                return BlockHelper.makeItemStack(slabId, dropped, block.func_71899_b(md));
            }
            case CAKE: {
                int md = world.func_72805_g(x, y, z);
                return md == 0 ? new ItemStack(Item.field_77746_aZ) : null;
            }
            case CROP: {
                return new ItemStack(block.func_71885_a(0, world.field_73012_v, 0), 1, block.func_71873_h(world, x, y, z));
            }
            case DOOR: {
                int md = world.func_72805_g(x, y, z);
                int doorId = block.func_71885_a(md, world.field_73012_v, 0);
                if (doorId == 0) {
                    return null;
                }
                return new ItemStack(doorId, 1, 0);
            }
            case REDSTONE_ORE: 
        }
        return new ItemStack(Block.field_72047_aN);
    }

    public static enum BlockStyle {
        UNDECIDED,
        NOTHING,
        USE_GET_DAMAGE_VALUE,
        USE_ID_DROPPED,
        USE_GET_BLOCK_DROPPED,
        CLONE_MD,
        STEM,
        SLAB,
        CAKE,
        CROP,
        DOOR,
        REDSTONE_ORE,
        PISTON_EXTENSION,
        BED;

    }
}

