/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class Spin
extends Instruction {
    boolean cc = true;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.cc = data.as(Share.VISIBLE, prefix + "cc").putBoolean(this.cc);
        return this;
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (Spin.playerHasProgrammer(player)) {
            this.cc = !this.cc;
            return true;
        }
        return false;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Item.field_77683_K);
    }

    @Override
    public void motorHit(ServoMotor motor) {
        int i;
        ForgeDirection newTop = motor.orientation.top;
        int n = i = this.cc ? 3 : 1;
        while (i > 0) {
            newTop = newTop.getRotation(motor.orientation.facing);
            --i;
        }
        FzOrientation next = motor.orientation.pointTopTo(newTop);
        if (next != FzOrientation.UNKNOWN) {
            motor.orientation = next;
        }
    }

    @Override
    public Icon getIcon(ForgeDirection side) {
        return this.cc ? BlockIcons.servo$spin_cc : BlockIcons.servo$spin_ccc;
    }

    @Override
    public String getName() {
        return "fz.instruction.spin";
    }
}

