/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import factorization.shared.Core;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class SocketCtrl
extends Instruction {
    byte mode = 0;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.mode = data.as(Share.VISIBLE, "mode").putByte(this.mode);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return Core.registry.empty_socket_item;
    }

    @Override
    public void motorHit(ServoMotor motor) {
        if (this.mode == 1) {
            motor.isSocketActive = true;
        } else if (this.mode == 2) {
            motor.isSocketActive = false;
        } else {
            motor.isSocketPulsed = true;
        }
    }

    @Override
    public Icon getIcon(ForgeDirection side) {
        if (this.mode == 1) {
            return BlockIcons.servo$socket_on;
        }
        if (this.mode == 2) {
            return BlockIcons.servo$socket_off;
        }
        return BlockIcons.servo$socket_pulse;
    }

    @Override
    public String getInfo() {
        if (this.mode == 1) {
            return "Socket Powered";
        }
        if (this.mode == 2) {
            return "Socket Unpowered";
        }
        return "Socket Pulse";
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (!SocketCtrl.playerHasProgrammer(player)) {
            return false;
        }
        this.mode = (byte)(this.mode + 1);
        if (this.mode > 2) {
            this.mode = 0;
        }
        return true;
    }

    @Override
    public String getName() {
        return "fz.instruction.socketCtrl";
    }
}

