/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import factorization.servo.ServoStack;
import factorization.sockets.SocketShifter;
import factorization.sockets.TileEntitySocketBase;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class ShifterControl
extends Instruction {
    static final byte EXPORT_MODE = 0;
    static final byte IMPORT_MODE = 1;
    static final byte TRANSFER_LIMIT = 2;
    static final byte TARGET_SLOT = 3;
    static final byte STREAM = 4;
    static final byte PULSE_EXACT = 5;
    static final byte PULSE_SOME = 6;
    static final byte MODE_MAX = 7;
    byte mode = 0;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.mode = data.as(Share.VISIBLE, "mode").putByte(this.mode);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return FactoryType.SOCKET_SHIFTER.asSocketItem();
    }

    @Override
    public void motorHit(ServoMotor motor) {
        TileEntitySocketBase socket = motor.socket;
        if (!(socket instanceof SocketShifter)) {
            motor.putError("Socket is not an Item Shifter");
            return;
        }
        SocketShifter shifter = (SocketShifter)socket;
        switch (this.mode) {
            default: {
                shifter.exporting = this.mode == 0;
                return;
            }
            case 4: {
                shifter.mode = SocketShifter.ShifterMode.MODE_STREAM;
                return;
            }
            case 5: {
                shifter.mode = SocketShifter.ShifterMode.MODE_PULSE_EXACT;
                return;
            }
            case 6: {
                shifter.mode = SocketShifter.ShifterMode.MODE_PULSE_SOME;
                return;
            }
            case 2: 
            case 3: 
        }
        ServoStack ss = motor.getServoStack(4);
        Integer the_val = ss.popType(Integer.class);
        if (the_val == null) {
            motor.putError("Stack underflow");
            return;
        }
        int val = the_val;
        if (this.mode == 2) {
            shifter.transferLimit = (byte)val;
        } else {
            shifter.foreignSlot = val;
        }
        shifter.sanitize(motor);
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (!ShifterControl.playerHasProgrammer(player)) {
            return false;
        }
        this.mode = (byte)(this.mode + 1);
        if (this.mode == 7) {
            this.mode = 0;
        }
        return true;
    }

    @Override
    public String getInfo() {
        switch (this.mode) {
            default: {
                return "Export Items";
            }
            case 1: {
                return "Import Items";
            }
            case 2: {
                return "Set Transfer Limit";
            }
            case 3: {
                return "Set Target Slot";
            }
            case 4: {
                return "Stream Transfer";
            }
            case 5: {
                return "Pulse Transfer Exact";
            }
            case 6: 
        }
        return "Pulse Transfer Some";
    }

    @Override
    public Icon getIcon(ForgeDirection side) {
        switch (this.mode) {
            default: {
                return BlockIcons.servo$ctrl$shift_export;
            }
            case 1: {
                return BlockIcons.servo$ctrl$shift_import;
            }
            case 2: {
                return BlockIcons.servo$ctrl$shift_transfer_limit;
            }
            case 3: {
                return BlockIcons.servo$ctrl$shift_target_slot;
            }
            case 5: {
                return BlockIcons.servo$ctrl$shift_pulse_exact;
            }
            case 6: {
                return BlockIcons.servo$ctrl$shift_pulse_some;
            }
            case 4: 
        }
        return BlockIcons.servo$ctrl$shift_stream;
    }

    @Override
    public String getName() {
        return "fz.instruction.shifterctrl";
    }
}

