/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.BlockIcons;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class SetSpeed
extends Instruction {
    byte speed = (byte)3;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.speed = data.putByte(this.speed);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Item.field_77747_aY);
    }

    @Override
    public void motorHit(ServoMotor motor) {
        motor.target_speed_index = (byte)(this.speed - 1);
        motor.stacks_changed = true;
    }

    @Override
    public Icon getIcon(ForgeDirection side) {
        switch (this.speed) {
            default: {
                return BlockIcons.servo$speed1;
            }
            case 2: {
                return BlockIcons.servo$speed2;
            }
            case 3: {
                return BlockIcons.servo$speed3;
            }
            case 4: {
                return BlockIcons.servo$speed4;
            }
            case 5: 
        }
        return BlockIcons.servo$speed5;
    }

    @Override
    public String getName() {
        return "fz.instruction.setspeed";
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (!SetSpeed.playerHasProgrammer(player)) {
            return false;
        }
        this.speed = (byte)(this.speed + 1);
        if (this.speed == 6) {
            this.speed = 1;
        }
        return true;
    }

    @Override
    public String getInfo() {
        switch (this.speed) {
            default: {
                return "Slowest";
            }
            case 2: {
                return "Slow";
            }
            case 3: {
                return "Normal";
            }
            case 4: {
                return "Fast";
            }
            case 5: 
        }
        return "Faster";
    }
}

