/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.BlockIcons;
import factorization.servo.Decorator;
import factorization.servo.ServoMotor;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class ServoEquipmentBay
extends Decorator {
    String error = null;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        return this;
    }

    @Override
    public void motorHit(ServoMotor motor) {
        if (motor.field_70170_p.field_72995_K) {
            return;
        }
        Coord c = motor.getCurrentPos();
        ForgeDirection facing = motor.orientation.facing;
        ForgeDirection top = motor.orientation.top;
        if (facing == ForgeDirection.DOWN) {
            return;
        }
        if (this.try_(motor, c.add(top), top)) {
            return;
        }
        if (this.try_(motor, c.add(facing), facing)) {
            return;
        }
        if (this.error != null) {
            motor.putError(this.error);
            this.error = null;
        } else if (facing == ForgeDirection.UP) {
            motor.putError("Unequip failed");
        } else {
            motor.putError("Equip failed");
        }
    }

    boolean try_(ServoMotor motor, Coord inv, ForgeDirection dir) {
        return this.equip(motor, FzUtil.openInventory(inv.getTE(IInventory.class), dir));
    }

    boolean equip(ServoMotor motor, FzUtil.FzInv inv) {
        if (inv == null) {
            this.error = "Not facing an inventory";
            return false;
        }
        ForgeDirection direwolf20 = motor.orientation.facing;
        if (direwolf20 == ForgeDirection.UP) {
            if (!motor.getInv().transfer(inv, 1, null)) {
                if (motor.getInv().isEmpty()) {
                    motor.putError("Servo Inventory is empty");
                } else {
                    motor.putError("Transfer failed");
                }
            }
            return true;
        }
        if (!inv.transfer(motor.getInv(), 1, null)) {
            if (inv.isEmpty()) {
                motor.putError("Source inventory is empty");
            } else {
                motor.putError("Transfer failed");
            }
        }
        return true;
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        return false;
    }

    @Override
    public boolean onClick(EntityPlayer player, ServoMotor motor) {
        return false;
    }

    @Override
    public String getName() {
        return "fz.decorator.equipmentBay";
    }

    @Override
    public Icon getIcon(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return BlockIcons.servo$bay_bottom;
        }
        if (side == ForgeDirection.UP) {
            return BlockIcons.servo$bay_top;
        }
        return BlockIcons.servo$bay;
    }

    @Override
    public float getSize() {
        return 0.0f;
    }

    @Override
    public boolean stretchIcon() {
        return true;
    }

    @Override
    protected void addRecipes() {
        Core.registry.recipe(this.toItem(), "IHI", "IGI", "III", Character.valueOf('G'), Core.registry.dark_iron_sprocket, Character.valueOf('H'), Block.field_94340_cs, Character.valueOf('I'), Item.field_77703_o);
    }
}

