/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class Jump
extends Instruction {
    byte mode = 1;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.mode = data.as(Share.MUTABLE, "mode").putByte(this.mode);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack((Block)Block.field_71963_Z);
    }

    @Override
    public void motorHit(ServoMotor motor) {
        if (this.mode == 1) {
            Boolean b = motor.getServoStack(4).popType(Boolean.class);
            motor.stacks_changed = true;
            if (b == null) {
                motor.putError("Jump: Stack Underflow of Boolean");
                return;
            }
            if (b.booleanValue()) {
                motor.jmp = this.mode;
                motor.penalizeSpeed();
            }
        } else {
            motor.jmp = this.mode;
        }
    }

    @Override
    public Icon getIcon(ForgeDirection side) {
        if (this.mode == 1) {
            return BlockIcons.servo$jmp_instruction;
        }
        if (this.mode == 2) {
            return BlockIcons.servo$jmp_tile;
        }
        return BlockIcons.error;
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (!Jump.playerHasProgrammer(player)) {
            return super.onClick(player, block, side);
        }
        this.mode = this.mode == 1 ? (byte)2 : (byte)1;
        return true;
    }

    @Override
    public String getInfo() {
        if (this.mode == 1) {
            return "Jump next";
        }
        if (this.mode == 2) {
            return "Unconditional Skip";
        }
        return "?";
    }

    @Override
    public String getName() {
        return "fz.instruction.jmp";
    }
}

