/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class BooleanValue
extends Instruction {
    boolean val = true;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.val = data.as(Share.VISIBLE, "val").putBoolean(this.val);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Block.field_72043_aJ);
    }

    @Override
    public void motorHit(ServoMotor motor) {
        motor.getServoStack(4).push(this.val);
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (BooleanValue.playerHasProgrammer(player)) {
            this.val = !this.val;
            return true;
        }
        return false;
    }

    @Override
    public Icon getIcon(ForgeDirection side) {
        return this.val ? BlockIcons.servo$true : BlockIcons.servo$false;
    }

    @Override
    public String getName() {
        return "fz.instruction.boolean";
    }

    @Override
    public String getInfo() {
        return Boolean.toString(this.val);
    }
}

