/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.IChargeConductor;
import factorization.api.IEntityMessage;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataInPacket;
import factorization.api.datahelpers.DataInPacketClientEdited;
import factorization.api.datahelpers.DataOutNBT;
import factorization.api.datahelpers.DataOutPacket;
import factorization.api.datahelpers.Share;
import factorization.common.FactoryType;
import factorization.notify.Notify;
import factorization.servo.ServoStack;
import factorization.servo.TileEntityServoRail;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.sockets.GuiDataConfig;
import factorization.sockets.ISocketHolder;
import factorization.sockets.SocketEmpty;
import factorization.sockets.TileEntitySocketBase;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeDirection;

public class ServoMotor
extends Entity
implements IEntityAdditionalSpawnData,
IEntityMessage,
IInventory,
ISocketHolder {
    public static final int STACKS = 16;
    public static final int STACK_EQUIPMENT = 0;
    public static final int STACK_ARGUMENT = 4;
    public static final int STACK_IO = 2;
    public static final int STACK_CONFIG = 3;
    public static final int STACK_ERRNO = 15;
    private ServoStack[] stacks = new ServoStack[16];
    public boolean stacks_changed;
    private ItemStack[] inv;
    private ItemStack[] inv_last_sent;
    public byte jmp;
    public static final byte JMP_NONE = 0;
    public static final byte JMP_NEXT_INSTRUCTION = 1;
    public static final byte JMP_NEXT_TILE = 2;
    Coord pos_prev;
    Coord pos_next;
    float pos_progress;
    public TileEntitySocketBase socket;
    public boolean isSocketActive;
    public boolean isSocketPulsed;
    public FzOrientation prevOrientation;
    public FzOrientation orientation;
    public FzOrientation pendingClientOrientation;
    public ForgeDirection nextDirection;
    public ForgeDirection lastDirection;
    private byte speed_b;
    public byte target_speed_index;
    private static final byte max_speed_b = 127;
    double accumulated_motion;
    private boolean stopped;
    double sprocket_rotation;
    double prev_sprocket_rotation;
    double servo_reorient;
    double prev_servo_reorient;
    private static final byte normal_speed_byte = 31;
    private static final byte[] target_speeds_b = new byte[]{10, 15, 31, 62, 124};
    private static final double normal_speed_double = 0.0875;
    private static final double max_speed_double = 0.35;
    private static Quaternion target_orientation = new Quaternion();
    private static final ItemStack EMPTY_ITEM = new ItemStack(0, 0, 0);
    private FzUtil.FzInv my_fz_inv;
    private final ArrayList<MovingObjectPosition> ret;
    private static final Vec3 nullVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);

    public ServoMotor(World world) {
        super(world);
        for (int i = 0; i < this.stacks.length; ++i) {
            this.stacks[i] = new ServoStack(this);
        }
        this.stacks_changed = false;
        this.inv = new ItemStack[4];
        this.inv_last_sent = new ItemStack[this.inv.length];
        this.jmp = 0;
        this.socket = new SocketEmpty();
        this.isSocketActive = false;
        this.isSocketPulsed = false;
        this.prevOrientation = FzOrientation.UNKNOWN;
        this.orientation = FzOrientation.UNKNOWN;
        this.pendingClientOrientation = FzOrientation.UNKNOWN;
        this.nextDirection = ForgeDirection.UNKNOWN;
        this.lastDirection = ForgeDirection.UNKNOWN;
        this.target_speed_index = (byte)2;
        this.stopped = false;
        this.sprocket_rotation = 0.0;
        this.prev_sprocket_rotation = 0.0;
        this.servo_reorient = 0.0;
        this.prev_servo_reorient = 0.0;
        this.my_fz_inv = FzUtil.openInventory((IInventory)this, 0);
        this.ret = new ArrayList();
        this.func_70105_a(1.0f, 1.0f);
        double d = 0.5;
        this.pos_prev = new Coord(world, 0, 0, 0);
        this.pos_next = this.pos_prev.copy();
        this.field_70178_ae = true;
    }

    public void spawnServoMotor() {
        this.pos_prev = new Coord(this);
        this.pos_next = this.pos_prev.copy();
        this.pickNextOrientation();
        this.pickNextOrientation();
        this.interpolatePosition(0.0f);
        this.prevOrientation = this.orientation;
        this.field_70170_p.func_72838_d((Entity)this);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        try {
            this.putData(new DataInNBT(nbttagcompound));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        try {
            this.putData(new DataOutNBT(nbttagcompound));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteArrayDataInput data) {
        try {
            this.putData(new DataInPacket((DataInput)data, Side.CLIENT));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        try {
            this.putData(new DataOutPacket((DataOutput)data, Side.SERVER));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    void putData(DataHelper data) throws IOException {
        int i;
        data.as(Share.VISIBLE, "controller");
        this.orientation = data.as(Share.VISIBLE, "Orient").putFzOrientation(this.orientation);
        this.nextDirection = data.as(Share.VISIBLE, "nextDir").putEnum(this.nextDirection);
        this.lastDirection = data.as(Share.VISIBLE, "lastDir").putEnum(this.lastDirection);
        this.speed_b = data.as(Share.VISIBLE, "speedb").putByte(this.speed_b);
        this.target_speed_index = data.as(Share.VISIBLE, "speedt").putByte(this.target_speed_index);
        this.accumulated_motion = data.as(Share.VISIBLE, "accumulated_motion").putDouble(this.accumulated_motion);
        this.pos_next = data.as(Share.VISIBLE, "pos_next").put(this.pos_next);
        this.pos_prev = data.as(Share.VISIBLE, "pos_prev").put(this.pos_prev);
        this.pos_progress = data.as(Share.VISIBLE, "pos_progress").putFloat(this.pos_progress);
        this.jmp = data.hasLegacy("skip") ? (data.as(Share.VISIBLE, "skip").putBoolean(this.jmp == 0) ? (byte)1 : 0) : data.as(Share.VISIBLE, "jmp").putByte(this.jmp);
        for (i = 0; i < 16; ++i) {
            String name2 = "stack" + i;
            this.stacks[i] = data.as(Share.VISIBLE, name2).put(this.stacks[i]);
        }
        for (i = 0; i < this.inv.length; ++i) {
            ItemStack is = this.inv[i] == null ? EMPTY_ITEM : this.inv[i];
            is = data.as(Share.VISIBLE, "inv" + i).putItemStack(is);
            this.inv[i] = is == null ? is : (is.field_77993_c == 0 ? null : is);
        }
        data.as(Share.VISIBLE, "sock");
        if (data.isReader()) {
            NBTTagCompound tag = data.putTag(new NBTTagCompound());
            TileEntity te = TileEntity.func_70317_c((NBTTagCompound)tag);
            this.socket = te instanceof TileEntitySocketBase ? (TileEntitySocketBase)te : new SocketEmpty();
        } else {
            NBTTagCompound output = new NBTTagCompound();
            this.socket.func_70310_b(output);
            data.putTag(output);
        }
        this.isSocketActive = data.as(Share.VISIBLE, "sockon").putBoolean(this.isSocketActive);
        this.isSocketPulsed = data.as(Share.VISIBLE, "sockpl").putBoolean(this.isSocketPulsed);
        this.stopped = data.as(Share.VISIBLE, "stop").putBoolean(this.stopped);
    }

    boolean validPosition(Coord c, boolean desperate) {
        TileEntityServoRail sr = c.getTE(TileEntityServoRail.class);
        if (sr == null) {
            return false;
        }
        return sr.priority >= 0 || desperate;
    }

    boolean validDirection(ForgeDirection dir, boolean desperate) {
        return this.validPosition(this.getCurrentPos().add(dir), desperate);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K) {
            this.prev_sprocket_rotation = this.sprocket_rotation;
            this.prev_servo_reorient = this.servo_reorient;
            this.doLogic();
            if (this.stopped) {
                this.speed_b = 0;
            }
        } else {
            byte orig_speed = this.speed_b;
            FzOrientation orig_or = this.orientation;
            this.doLogic();
            if (this.stopped) {
                this.speed_b = 0;
            }
            if (orig_speed != this.speed_b || orig_or != this.orientation) {
                this.broadcastBriefUpdate();
            }
            if (this.stacks_changed) {
                try {
                    this.stacks_changed = false;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    Core.network.prefixEntityPacket(dos, this, 176);
                    DataOutPacket data = new DataOutPacket(dos, Side.SERVER);
                    this.putData(data);
                    Packet toSend = Core.network.entityPacket(baos);
                    Core.network.broadcastPacketToLMPers(this, toSend);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.interpolatePosition(this.pos_progress);
        if (this.stopped && this.getCurrentPos().isWeaklyPowered()) {
            this.setStopped(false);
        }
    }

    public void interpolatePosition(float interp) {
        this.func_70107_b(ServoMotor.ip(this.pos_prev.x, this.pos_next.x, interp), ServoMotor.ip(this.pos_prev.y, this.pos_next.y, interp), ServoMotor.ip(this.pos_prev.z, this.pos_next.z, interp));
    }

    static double ip(int a, int b, float interp) {
        return (float)a + (float)(b - a) * interp;
    }

    void updateSpeed() {
        boolean should_accelerate;
        byte target_speed_b = target_speeds_b[this.target_speed_index];
        boolean bl = should_accelerate = this.speed_b < target_speed_b && this.orientation != FzOrientation.UNKNOWN;
        if (this.speed_b > target_speed_b) {
            this.speed_b = (byte)Math.max(target_speed_b, this.speed_b * 3 / 4 - 1);
            return;
        }
        if (Core.cheat_servo_energy && should_accelerate) {
            this.accelerate();
        }
        long now = this.field_70170_p.func_82737_E();
        int m = 1 + this.target_speed_index;
        if (should_accelerate && now % 3L == 0L && this.extractCharge(8)) {
            this.accelerate();
        }
    }

    public void penalizeSpeed() {
        if (this.speed_b > 4) {
            this.speed_b = (byte)(this.speed_b - 1);
        }
    }

    void doLogic() {
        double speed;
        if (this.field_70128_L) {
            return;
        }
        if (this.stopped) {
            this.updateSocket();
            return;
        }
        if (this.orientation == FzOrientation.UNKNOWN) {
            this.pickNextOrientation();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.updateSpeed();
        }
        if ((speed = this.getProperSpeed()) <= 0.0 || this.orientation == FzOrientation.UNKNOWN) {
            this.updateSocket();
            return;
        }
        this.accumulated_motion += speed;
        this.moveMotor();
        if (this.pos_progress >= 1.0f) {
            this.pos_progress -= 1.0f;
            this.accumulated_motion = Math.min((double)this.pos_progress, speed);
            Chunk oldChunk = this.pos_prev.getChunk();
            Chunk newChunk = this.pos_next.getChunk();
            this.pos_prev = this.pos_next;
            this.updateSocket();
            this.onEnterNewBlock();
            this.pickNextOrientation();
            if (oldChunk != newChunk) {
                oldChunk.func_76630_e();
                newChunk.func_76630_e();
            }
        } else {
            this.updateSocket();
        }
    }

    void updateSocket() {
        Coord here = this.getCurrentPos();
        here.setAsTileEntityLocation(this.socket);
        this.socket.facing = this.orientation.top;
        this.socket.genericUpdate(this, here, this.isSocketActive ^ this.isSocketPulsed);
        this.isSocketPulsed = false;
    }

    public Random getRandom() {
        Random rand = FzUtil.dirtyRandomCache();
        long seed = this.field_70157_k + this.getCurrentPos().seed() << 5 + this.orientation.ordinal() << 2 + this.nextDirection.ordinal();
        rand.setSeed(seed);
        return rand;
    }

    public boolean testDirection(ForgeDirection d, boolean desperate) {
        if (d == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.validDirection(d, desperate);
    }

    static int similarity(FzOrientation base, FzOrientation novel) {
        int score = 0;
        return score;
    }

    boolean pickNextOrientation() {
        boolean ret = this.pickNextOrientation_impl();
        this.pos_next = this.pos_prev.add(this.orientation.facing);
        return ret;
    }

    public void changeOrientation(ForgeDirection dir) {
        ForgeDirection orig_direction = this.orientation.facing;
        ForgeDirection orig_top = this.orientation.top;
        FzOrientation start = FzOrientation.fromDirection(dir);
        FzOrientation perfect = start.pointTopTo(orig_top);
        if (perfect == FzOrientation.UNKNOWN) {
            if (dir == orig_top) {
                perfect = start.pointTopTo(orig_direction.getOpposite());
            } else if (dir == orig_top.getOpposite()) {
                perfect = start.pointTopTo(orig_direction);
            }
            if (perfect == FzOrientation.UNKNOWN) {
                perfect = start;
            }
        }
        this.orientation = perfect;
        this.lastDirection = orig_direction;
        if (this.orientation.facing == this.nextDirection) {
            this.nextDirection = ForgeDirection.UNKNOWN;
        }
    }

    boolean pickNextOrientation_impl() {
        ArrayList<ForgeDirection> dirs = FzUtil.getRandomDirections(this.field_70170_p.field_73012_v);
        int available_nonbackwards_directions = 0;
        Coord look = this.pos_next.copy();
        int all_count = 0;
        for (int i = 0; i < dirs.size(); ++i) {
            ForgeDirection fd = dirs.get(i);
            look.set(this.pos_next);
            look.adjust(fd);
            TileEntityServoRail sr = look.getTE(TileEntityServoRail.class);
            if (sr == null) continue;
            ++all_count;
            if (fd == this.orientation.facing.getOpposite()) continue;
            if (sr.priority > 0) {
                this.changeOrientation(fd);
                return true;
            }
            if (sr.priority != 0) continue;
            ++available_nonbackwards_directions;
        }
        if (all_count == 0) {
            this.speed_b = 0;
            return false;
        }
        boolean desperate = available_nonbackwards_directions < 1;
        ForgeDirection direction = this.orientation.facing;
        ForgeDirection opposite = direction.getOpposite();
        if (this.nextDirection != opposite && this.testDirection(this.nextDirection, desperate)) {
            this.changeOrientation(this.nextDirection);
            return true;
        }
        if (this.testDirection(direction, desperate)) {
            return true;
        }
        if (this.lastDirection != opposite && this.testDirection(this.lastDirection, desperate)) {
            this.changeOrientation(this.lastDirection);
            return true;
        }
        ForgeDirection top = this.orientation.top;
        if (this.testDirection(top, desperate)) {
            this.changeOrientation(top);
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = dirs.get(i);
            if (d == this.nextDirection || d == direction || d == opposite || d == this.lastDirection || d == top || !this.validDirection(d, desperate)) continue;
            this.changeOrientation(d);
            return true;
        }
        if (this.validDirection(opposite, true)) {
            this.orientation = FzOrientation.fromDirection(opposite).pointTopTo(top);
            if (this.orientation != FzOrientation.UNKNOWN) {
                return true;
            }
        }
        this.orientation = FzOrientation.UNKNOWN;
        return false;
    }

    void accelerate() {
        this.speed_b = (byte)(this.speed_b + 1);
        this.speed_b = (byte)Math.min(this.speed_b, 127);
    }

    void broadcast(int message_type, Object ... msg) {
        Packet p = Core.network.entityPacket(this, message_type, msg);
        Core.network.broadcastPacket(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, p);
    }

    void moveMotor() {
        if (this.accumulated_motion == 0.0) {
            return;
        }
        double move = Math.min(this.accumulated_motion, (double)(1.0f - this.pos_progress));
        this.accumulated_motion -= move;
        this.pos_progress = (float)((double)this.pos_progress + move);
        if (this.field_70170_p.field_72995_K) {
            this.sprocket_rotation += move;
            if (this.orientation != this.prevOrientation) {
                this.servo_reorient += move;
                if (this.servo_reorient >= 1.0) {
                    this.servo_reorient -= 1.0;
                    this.prev_servo_reorient = this.servo_reorient;
                    this.prevOrientation = this.orientation;
                }
            } else {
                this.servo_reorient = 0.0;
            }
        }
    }

    public Coord getCurrentPos() {
        return this.pos_prev;
    }

    public Coord getNextPos() {
        return this.pos_next;
    }

    void onEnterNewBlock() {
        TileEntityServoRail rail;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int m = this.target_speed_index + 1;
        if (!this.extractCharge(m * 2)) {
            this.speed_b = (byte)Math.max(0, this.speed_b * 3 / 4 - 1);
        }
        if ((rail = this.getCurrentPos().getTE(TileEntityServoRail.class)) == null || rail.decoration == null) {
            if (this.jmp == 2) {
                this.jmp = 0;
            }
            return;
        }
        if (this.getCurrentPos().isWeaklyPowered()) {
            if (this.jmp == 2) {
                this.jmp = 0;
            }
            return;
        }
        if (this.jmp != 0) {
            this.jmp = 0;
            return;
        }
        rail.decoration.motorHit(this);
    }

    public boolean func_130002_c(EntityPlayer player) {
        this.stacks_changed = true;
        ItemStack is = FzUtil.normalize(player.func_70694_bm());
        if (is == null) {
            return false;
        }
        if (this.socket instanceof SocketEmpty && is.func_77973_b() == Core.registry.socket_part) {
            int md = is.func_77960_j();
            if (md > 0 && md < FactoryType.MAX_ID) {
                try {
                    this.socket = (TileEntitySocketBase)FactoryType.fromMd(md).getFactoryTypeClass().newInstance();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Notify.send(null, (Object)this, "Exception; see console log\n" + e.getMessage(), new String[0]);
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --is.field_77994_a;
            }
        } else if (this.socket != null) {
            return this.socket.activateOnServo(player, this);
        }
        return false;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource instanceof EntityDamageSourceIndirect) {
            return false;
        }
        Entity src = damageSource.func_76364_f();
        if (!(src instanceof EntityPlayer)) {
            return false;
        }
        if (this.field_70128_L) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)src;
        this.despawn(player.field_71075_bZ.field_75098_d);
        return true;
    }

    void despawn(boolean creativeModeHit) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.func_70106_y();
        if (creativeModeHit) {
            return;
        }
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        toDrop.add(new ItemStack((Item)Core.registry.servo_placer));
        for (ItemStack is : this.inv) {
            toDrop.add(is);
        }
        if (this.socket != null && !(this.socket instanceof SocketEmpty)) {
            this.socket.uninstall();
            toDrop.add(new ItemStack((Item)Core.registry.socket_part, 1, this.socket.getFactoryType().md));
        }
        this.dropItemStacks(toDrop);
    }

    public boolean func_70067_L() {
        return true;
    }

    public String toString() {
        return super.toString() + (this.field_70170_p.field_72995_K ? " client" : " server") + " " + this.getProperSpeed();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int three) {
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        double neg_size = -0.25;
        double pos_size = 0.75;
        double height = 0.125;
        double dy = 0.5;
        this.field_70121_D.func_72324_b(x - neg_size, dy + y - height, z - neg_size, x + pos_size, dy + y + height, z + pos_size);
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        super.func_70080_a(x, y, z, yaw, pitch);
    }

    @Override
    public boolean handleMessageFromClient(short messageType, DataInputStream input) throws IOException {
        if (messageType == 3) {
            DataInPacketClientEdited di = new DataInPacketClientEdited(input);
            this.socket.serialize("", di);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(short messageType, DataInputStream input) throws IOException {
        switch (messageType) {
            case 4: {
                if (!this.field_70170_p.field_72995_K) {
                    return false;
                }
                DataInPacket dip = new DataInPacket(input, Side.CLIENT);
                this.socket.serialize("", dip);
                Minecraft.func_71410_x().func_71373_a((GuiScreen)new GuiDataConfig(this.socket, this));
                return true;
            }
            case 175: {
                byte index;
                while ((index = input.readByte()) >= 0) {
                    this.inv[index] = FzUtil.readStack(input);
                }
                return true;
            }
            case 174: {
                Coord a = this.getCurrentPos();
                Coord b = this.getNextPos();
                FzOrientation no = FzOrientation.getOrientation(input.readByte());
                if (no != this.prevOrientation) {
                    this.orientation = no;
                }
                this.speed_b = input.readByte();
                a.x = input.readInt();
                a.y = input.readInt();
                a.z = input.readInt();
                b.x = input.readInt();
                b.y = input.readInt();
                b.z = input.readInt();
                this.pos_progress = input.readFloat();
                if (this.speed_b > 0) {
                    this.stopped = false;
                }
                return true;
            }
            case 176: {
                try {
                    DataInPacket data = new DataInPacket(input, Side.CLIENT);
                    this.putData(data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
            case 177: {
                this.stopped = input.readBoolean();
                return true;
            }
        }
        return this.socket.handleMessageFromServer(messageType, input);
    }

    public double getProperSpeed() {
        double perc = (double)this.speed_b / 127.0;
        return 0.35 * perc;
    }

    public void dropItemStacks(Iterable<ItemStack> toDrop) {
        for (ItemStack is : toDrop) {
            FzUtil.spawnItemStack(this, is);
        }
    }

    public ServoStack getServoStack(int stackId) {
        stackId = Math.max(0, stackId);
        stackId = Math.min(stackId, 16);
        return this.stacks[stackId];
    }

    public void putError(Object error) {
        ServoStack ss;
        if (!this.field_70170_p.field_72995_K) {
            Notify.send(this.getCurrentPos(), "%s", error.toString());
        }
        if ((ss = this.getServoStack(15)).getFreeSpace() <= 0) {
            ss.popEnd();
        }
        ss.push(error);
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack ret = this.inv[i].func_77979_a(j);
        this.inv[i] = FzUtil.normalize(this.inv[i]);
        return ret;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv[i] = itemstack;
    }

    public String func_70303_b() {
        return "Servo Motor Inventory";
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        ArrayList<Number> toSend = new ArrayList<Number>(this.inv.length * 2);
        for (byte i = 0; i < this.inv.length; i = (byte)(i + 1)) {
            if (FzUtil.identical(this.inv[i], this.inv_last_sent[i])) continue;
            toSend.add(i);
            toSend.add((Number)(this.inv[i] == null ? EMPTY_ITEM : this.inv[i]));
            this.inv_last_sent[i] = this.inv[i];
        }
        if (toSend.isEmpty()) {
            return;
        }
        toSend.add(-1);
        this.broadcast(175, toSend.toArray());
        this.getCurrentPos().getChunk().func_76630_e();
        this.getNextPos().getChunk().func_76630_e();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public FzUtil.FzInv getInv() {
        return this.my_fz_inv;
    }

    public ItemStack getHeldItem() {
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack is = this.inv[i];
            if (is == null) continue;
            return is;
        }
        return null;
    }

    ArrayList<MovingObjectPosition> rayTrace() {
        this.ret.clear();
        Coord c = this.getCurrentPos();
        ForgeDirection top = this.orientation.top;
        ForgeDirection face = this.orientation.facing;
        ForgeDirection right = face.getRotation(top);
        AxisAlignedBB ab = AxisAlignedBB.func_72332_a().func_72299_a((double)(c.x + top.offsetX), (double)(c.y + top.offsetY), (double)(c.z + top.offsetZ), (double)(c.x + 1 + top.offsetX), (double)(c.y + 1 + top.offsetY), (double)(c.z + 1 + top.offsetZ));
        for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, ab)) {
            if (!entity.func_70067_L()) continue;
            this.ret.add(new MovingObjectPosition(entity));
        }
        ServoMotor.nullVec.field_72449_c = 0.0;
        ServoMotor.nullVec.field_72448_b = 0.0;
        ServoMotor.nullVec.field_72450_a = 0.0;
        Coord targetBlock = c.add(top);
        this.mopBlock(this.ret, targetBlock, top.getOpposite());
        this.mopBlock(this.ret, targetBlock.add(top), top.getOpposite());
        this.mopBlock(this.ret, targetBlock.add(top.getOpposite()), top);
        if (this.ret.size() == 0) {
            this.mopBlock(this.ret, targetBlock.add(face), face.getOpposite());
            this.mopBlock(this.ret, targetBlock.add(face.getOpposite()), face);
            if (this.ret.size() == 0) {
                this.mopBlock(this.ret, targetBlock.add(right), right.getOpposite());
                this.mopBlock(this.ret, targetBlock.add(right.getOpposite()), right);
            }
        }
        return this.ret;
    }

    void mopBlock(ArrayList<MovingObjectPosition> list, Coord target, ForgeDirection side) {
        if (target.isAir()) {
            return;
        }
        list.add(target.createMop(side, nullVec));
    }

    @Override
    public boolean dumpBuffer(List<ItemStack> buffer) {
        if (buffer.isEmpty()) {
            return false;
        }
        FzUtil.FzInv me = FzUtil.openInventory(this, false);
        ItemStack got = buffer.get(0);
        if (got == null) {
            buffer.remove(0);
            return true;
        }
        ItemStack res = me.push(buffer.get(0));
        if (res == null) {
            buffer.remove(0);
        } else {
            buffer.set(0, res);
        }
        return true;
    }

    @Override
    public boolean extractCharge(int amount) {
        IChargeConductor wire = this.getCurrentPos().getTE(IChargeConductor.class);
        if (wire == null) {
            return false;
        }
        return wire.getCharge().tryTake(amount) >= amount;
    }

    @Override
    public void sendMessage(int msgType, Object ... msg) {
        Packet toSend = Core.network.entityPacket(this, msgType, msg);
        Core.network.broadcastPacket(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, toSend);
    }

    public void setStopped(boolean newState) {
        if (this.stopped == newState) {
            return;
        }
        this.stopped = newState;
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public void broadcastBriefUpdate() {
        Coord a = this.getCurrentPos();
        Coord b = this.getNextPos();
        this.broadcast(174, (byte)this.orientation.ordinal(), this.speed_b, a.x, a.y, a.z, b.x, b.y, b.z, Float.valueOf(this.pos_progress));
    }
}

