/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.common.BlockIcons;
import factorization.servo.ServoMotor;
import factorization.servo.ServoStack;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.sockets.TileEntitySocketBase;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelZombie;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderEntity;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderServoMotor
extends RenderEntity {
    static int both_lists = -1;
    static int sprocket_display_list = -1;
    static int chasis_display_list = -1;
    boolean loaded_models = false;
    private static Icon subsetIcon;
    private static Tessellator subsetTessellator;
    static Vec3 quat_vector;
    static Quaternion start;
    static Quaternion end;
    private Quaternion q0 = new Quaternion();
    private Quaternion q1 = new Quaternion();
    private static boolean debug_servo_orientation;
    RenderItem renderItem = new RenderItem();
    static ItemStack equiped_item;
    static EntityLiving item_holder;
    static HolderRenderer holder_render;
    static EntityLiving dummy_entity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadModel(int displayList, String modelName, Icon icon) {
        try {
            WavefrontObject sprocket = null;
            InputStream input = null;
            try {
                ResourceLocation rl = Core.getResource(modelName);
                input = Minecraft.func_71410_x().func_110442_L().func_110536_a(rl).func_110527_b();
                if (input == null) {
                    Core.logWarning("Missing 3D model: " + rl, new Object[0]);
                    return;
                }
                sprocket = new WavefrontObject(rl.toString(), input);
                input.close();
                input = null;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
            GL11.glNewList((int)displayList, (int)4864);
            double modelScale = 0.0625;
            GL11.glScaled((double)modelScale, (double)modelScale, (double)modelScale);
            subsetIcon = icon;
            subsetTessellator.func_78382_b();
            sprocket.tessellateAll(subsetTessellator);
            subsetTessellator.func_78381_a();
            modelScale = 1.0 / modelScale;
            GL11.glScaled((double)modelScale, (double)modelScale, (double)modelScale);
            GL11.glEndList();
        }
        catch (IOException e) {
            Core.logWarning("Failed to load model %s", modelName);
            e.printStackTrace();
        }
    }

    void loadModels() {
        if (both_lists != -1) {
            GLAllocation.func_74523_b((int)both_lists);
        }
        both_lists = GLAllocation.func_74526_a((int)3);
        sprocket_display_list = both_lists + 0;
        chasis_display_list = both_lists + 1;
        RenderServoMotor.loadModel(sprocket_display_list, "models/servo/sprocket.obj", BlockIcons.servo$model$sprocket);
        RenderServoMotor.loadModel(chasis_display_list, "models/servo/chasis.obj", BlockIcons.servo$model$chasis);
    }

    void renderSprocket() {
        GL11.glCallList((int)sprocket_display_list);
    }

    void renderChasis() {
        GL11.glCallList((int)chasis_display_list);
    }

    ForgeDirection getPerpendicular(ForgeDirection a, ForgeDirection b) {
        return a.getRotation(b);
    }

    float interp(double a, double b, double part) {
        double d = a - b;
        float r = (float)(b + d * part);
        double v = Math.min(1.0f, r * r * 4.0f);
        return (float)v;
    }

    public void func_76986_a(Entity ent, double x, double y, double z, float yaw, float partial) {
        Core.profileStartRender("servo");
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        boolean highlighted = mop != null && mop.field_72308_g == ent;
        ServoMotor motor = (ServoMotor)ent;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glPushMatrix();
        motor.interpolatePosition((float)Math.pow(motor.pos_progress, 2.0));
        float reorientInterpolation = this.interp(motor.servo_reorient, motor.prev_servo_reorient, partial);
        this.orientMotor(motor, partial, reorientInterpolation);
        this.renderMainModel(motor, partial, reorientInterpolation, false);
        this.renderSocketAttachment(motor, motor.socket, partial);
        boolean render_details = false;
        if (highlighted) {
            ItemStack is;
            GL11.glDisable((int)3553);
            GL11.glPushAttrib((int)16448);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            float gray = 0.65f;
            GL11.glColor4f((float)gray, (float)gray, (float)gray, (float)0.8f);
            GL11.glLineWidth((float)1.5f);
            float d = 0.5f;
            float h = 0.25f;
            AxisAlignedBB ab = AxisAlignedBB.func_72330_a((double)(-d), (double)(-h), (double)(-d), (double)d, (double)h, (double)d);
            this.drawOutlinedBoundingBox(ab);
            ab.func_72317_d(ab.field_72340_a, ab.field_72338_b, ab.field_72339_c);
            GL11.glPopAttrib();
            GL11.glEnable((int)3553);
            EntityPlayer player = Core.proxy.getClientPlayer();
            if (player != null && (is = player.func_70694_bm()) != null && is.func_77973_b() == Core.registry.logicMatrixProgrammer) {
                render_details = true;
            }
        }
        this.renderInventory(motor, partial);
        GL11.glPopMatrix();
        if (render_details) {
            GL11.glDisable((int)2929);
            GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            this.renderStacks(motor);
            GL11.glEnable((int)2929);
        }
        GL11.glPopMatrix();
        motor.interpolatePosition(motor.pos_progress);
        Core.profileEndRender();
    }

    void drawOutlinedBoundingBox(AxisAlignedBB par1AxisAlignedBB) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(1);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78381_a();
    }

    void orientMotor(ServoMotor motor, float partial, float reorientInterpolation) {
        Quaternion qt;
        FzOrientation orientation = motor.orientation;
        FzOrientation prevOrientation = motor.prevOrientation;
        if (debug_servo_orientation) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)4.0f);
            GL11.glBegin((int)3);
            FzOrientation o = orientation;
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)o.facing.offsetX, (double)o.facing.offsetY, (double)o.facing.offsetZ);
            GL11.glVertex3d((double)(o.facing.offsetX + o.top.offsetX), (double)(o.facing.offsetY + o.top.offsetY), (double)(o.facing.offsetZ + o.top.offsetZ));
            GL11.glEnd();
            GL11.glLineWidth((float)2.0f);
            GL11.glBegin((int)3);
            o = prevOrientation;
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)o.facing.offsetX, (double)o.facing.offsetY, (double)o.facing.offsetZ);
            GL11.glVertex3d((double)(o.facing.offsetX + o.top.offsetX), (double)(o.facing.offsetY + o.top.offsetY), (double)(o.facing.offsetZ + o.top.offsetZ));
            GL11.glEnd();
        }
        if (prevOrientation == orientation) {
            qt = Quaternion.fromOrientation(orientation);
        } else {
            this.q0.update(Quaternion.fromOrientation(prevOrientation));
            this.q1.update(Quaternion.fromOrientation(orientation));
            if (this.q0.dotProduct(this.q1) < 0.0) {
                this.q0.incrScale(-1.0);
            }
            this.q0.incrLerp(this.q1, reorientInterpolation);
            qt = this.q0;
        }
        qt.glRotate();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (debug_servo_orientation) {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glBegin((int)3);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)1.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
        }
    }

    void renderSocketAttachment(ServoMotor motor, TileEntitySocketBase socket, float partial) {
        socket.field_70327_n = 0;
        socket.field_70330_m = 0;
        socket.field_70329_l = 0;
        socket.facing = ForgeDirection.UP;
        socket.renderInServo(motor, partial);
    }

    void renderInventory(ServoMotor motor, float partial) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float s = 0.75f;
        FzUtil.FzInv inv = motor.getInv();
        Minecraft mc = Minecraft.func_71410_x();
        long range = 180L;
        double d = (float)motor.field_70170_p.func_82737_E() + partial;
        float now = (float)(d % (double)range / (double)range);
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack is = inv.get(i);
            if (is == null) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.25f);
            GL11.glRotatef((float)(-90 * i), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.4f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)s, (float)s, (float)s);
            try {
                this.renderItem(motor, is, partial);
            }
            catch (Exception e) {
                System.err.println("Error rendering item: " + is);
                e.printStackTrace();
                inv.set(i, null);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity par1Entity) {
        return Core.blockAtlas;
    }

    void renderMainModel(ServoMotor motor, float partial, double ro, boolean hilighting) {
        double stretch_interp;
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        this.func_110776_a(Core.blockAtlas);
        if (!this.loaded_models) {
            try {
                this.loadModels();
            }
            catch (Throwable e) {
                Core.logWarning("Failed to load servo sprocket model", new Object[0]);
                e.printStackTrace();
            }
            this.loaded_models = true;
        }
        this.renderChasis();
        double rail_width = 0.4375;
        double radius = 0.6230500000000001;
        double constant = Math.PI * 2 * radius;
        double partial_rotation = FzUtil.interp((float)motor.prev_sprocket_rotation, (float)motor.sprocket_rotation, partial);
        double angle = constant * partial_rotation;
        radius = 0.22916666666666666;
        radius = -0.25;
        float rd = (float)(radius + rail_width);
        if (motor.orientation != motor.prevOrientation && (stretch_interp = ro * 2.0) < 1.0) {
            if (stretch_interp > 0.5) {
                stretch_interp = 1.0 - stretch_interp;
            }
            rd = (float)((double)rd + stretch_interp / 8.0);
        }
        float height_d = 0.125f;
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)height_d, (float)rd);
        GL11.glRotatef((float)((float)Math.toDegrees(angle)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderSprocket();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)height_d, (float)(-rd));
        GL11.glRotatef((float)((float)Math.toDegrees(-angle) + 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderSprocket();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    void renderItem(ServoMotor motor, ItemStack is, float partial) {
        equiped_item = is;
        if (equiped_item == null) {
            return;
        }
        RenderServoMotor.dummy_entity.field_70170_p = motor.field_70170_p;
        holder_render.func_76976_a(this.field_76990_c);
        this.do_renderItem(equiped_item);
    }

    public void do_renderItem(ItemStack itemstack) {
        Block block;
        GL11.glPushMatrix();
        float s = 0.25f;
        GL11.glScalef((float)s, (float)s, (float)s);
        boolean needRotationFix = true;
        if (itemstack.func_77973_b() instanceof ItemBlock && itemstack.field_77993_c < Block.field_71973_m.length && (block = Block.field_71973_m[itemstack.field_77993_c]) != null && RenderBlocks.func_78597_b((int)block.func_71857_b())) {
            needRotationFix = false;
        }
        if (needRotationFix) {
            GL11.glTranslatef((float)0.9375f, (float)0.0625f, (float)-0.0f);
            GL11.glRotatef((float)-335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        float f6 = 1.5f;
        GL11.glScalef((float)f6, (float)f6, (float)f6);
        this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)dummy_entity, itemstack, 0);
        if (itemstack.func_77973_b().func_77623_v()) {
            for (int x = 1; x < itemstack.func_77973_b().getRenderPasses(itemstack.func_77960_j()); ++x) {
                this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)dummy_entity, itemstack, x);
            }
        }
        GL11.glPopMatrix();
    }

    protected void func_82422_c() {
        GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
    }

    void renderStacks(ServoMotor motor) {
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        float s = 0.0078125f;
        GL11.glScalef((float)s, (float)s, (float)s);
        for (int i = 0; i < 16; ++i) {
            GL11.glPushMatrix();
            ServoStack ss = motor.getServoStack(i);
            GL11.glRotatef((float)(11.0f * (8.5f + (float)i)), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)(-0.9f / s), (float)0.0f);
            if (this.renderStack(ss, ItemDye.field_77859_b[15 - i])) {
                // empty if block
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    boolean renderStack(ServoStack stack, int color) {
        int i = 0;
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        fr.func_85187_a("\u4dfc", 0, 0, color, false);
        for (Object o : stack) {
            if (i == 0) {
                GL11.glPushMatrix();
            }
            GL11.glTranslatef((float)0.0f, (float)-10.0f, (float)0.0f);
            fr.func_85187_a(o != null ? o.toString() : "null", 0, 0, color, false);
            ++i;
        }
        if (i > 0) {
            GL11.glPopMatrix();
        }
        return i > 0;
    }

    static {
        subsetTessellator = new Tessellator(){

            public void func_78385_a(double u, double v) {
                super.func_78385_a((double)subsetIcon.func_94214_a(u * 16.0), (double)subsetIcon.func_94207_b(v * 16.0));
            }
        };
        quat_vector = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        start = new Quaternion();
        end = new Quaternion();
        debug_servo_orientation = false;
        equiped_item = null;
        item_holder = new EntityLiving(null){

            public ItemStack func_70694_bm() {
                return equiped_item;
            }
        };
        holder_render = new HolderRenderer((ModelBiped)new ModelZombie(), 1.0f);
        dummy_entity = new EntityEnderman(null);
    }

    private static class HolderRenderer
    extends RenderBiped {
        public HolderRenderer(ModelBiped model, float someFloat) {
            super(model, someFloat);
        }

        public void renderItem(float partial) {
            this.func_77029_c((EntityLivingBase)item_holder, partial);
        }
    }
}

