/*
 * Decompiled with CFR 0.152.
 */
package factorization.oreprocessing;

import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.TileEntityFactorization;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityCrystallizer
extends TileEntityFactorization {
    ItemStack[] inputs = new ItemStack[6];
    ItemStack output;
    public ItemStack growing_crystal;
    public ItemStack solution;
    public int heat;
    public int progress;
    public static final int topHeat = 300;
    private static final int[] INPUTS_s = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] OUTPUT_s = new int[]{6};
    int share_delay = 600;
    int current_state = -1;
    int last_state = -1;
    public static ArrayList<CrystalRecipe> recipes = new ArrayList();

    @Override
    public Icon getIcon(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return BlockIcons.cauldron_top;
            }
        }
        return BlockIcons.cauldron_side;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.writeSlotsToNBT(tag);
        tag.func_74768_a("heat", this.heat);
        tag.func_74768_a("progress", this.progress);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.readSlotsFromNBT(tag);
        this.heat = tag.func_74762_e("heat");
        this.progress = tag.func_74762_e("progress");
    }

    public int func_70302_i_() {
        return this.inputs.length + 1;
    }

    public ItemStack func_70301_a(int slot) {
        this.needLogic();
        if (slot == this.inputs.length) {
            return this.output;
        }
        return this.inputs[slot];
    }

    public void func_70299_a(int slot, ItemStack is) {
        if (slot == this.inputs.length) {
            this.output = is;
        } else {
            this.inputs[slot] = is;
        }
        this.func_70296_d();
    }

    public String func_70303_b() {
        return "Crystallizer";
    }

    public int[] func_94128_d(int s) {
        ForgeDirection side = ForgeDirection.getOrientation((int)s);
        if (side == ForgeDirection.DOWN) {
            return OUTPUT_s;
        }
        return INPUTS_s;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return slotIndex < this.inputs.length;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.CRYSTALLIZER;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    int pickInputSlot(ItemStack must_match) {
        int slot = -1;
        int max_size = -99;
        for (int i = 0; i < this.inputs.length; ++i) {
            int here_size;
            if (must_match != null && this.inputs[i] != null && !FzUtil.couldMerge(must_match, this.inputs[i]) || (here_size = FzUtil.getStackSize(this.inputs[i])) <= max_size) continue;
            max_size = here_size;
            slot = i;
        }
        return slot;
    }

    public int getProgressRemaining() {
        return 24000 / this.getLogicSpeed() - this.progress;
    }

    public float getProgress() {
        return (float)this.progress / (float)(this.getProgressRemaining() + this.progress);
    }

    public boolean needHeat() {
        if (this.heat >= 300) {
            return false;
        }
        return this.getMatchingRecipe() != null;
    }

    void empty() {
        this.growing_crystal = null;
        this.solution = null;
        this.shareState();
    }

    @Override
    protected void doLogic() {
        if (this.heat <= 0) {
            this.current_state = 1;
            this.empty();
            return;
        }
        CrystalRecipe match = this.getMatchingRecipe();
        if (match == null) {
            this.heat = Math.max(this.heat - 3, 0);
            this.progress = (int)Math.min((double)this.progress * 0.005 - 1.0, 0.0);
            this.current_state = 2;
            this.empty();
            return;
        }
        if (this.growing_crystal == null) {
            this.growing_crystal = match.output;
            this.solution = match.solution;
            this.share_delay = 0;
            this.current_state = 3;
        }
        if (this.heat < 300) {
            this.current_state = 4;
            this.shareState();
            return;
        }
        this.needLogic();
        if (this.progress == 0) {
            this.share_delay = 0;
            this.current_state = 5;
        }
        ++this.progress;
        if (this.getProgressRemaining() <= 0 || Core.cheat) {
            this.heat = Core.cheat ? 280 : 0;
            this.progress = 0;
            match.apply(this);
            this.share_delay = 0;
            this.current_state = 6;
        }
        this.shareState();
    }

    void shareState() {
        --this.share_delay;
        if (this.share_delay <= 0 || this.current_state != this.last_state) {
            this.share_delay = 300;
            this.broadcastMessage(null, this.getAuxillaryInfoPacket());
            this.last_state = this.current_state;
        }
    }

    int countMaterial(ItemStack toMatch) {
        int count = 0;
        for (ItemStack is : this.inputs) {
            if (is == null || !FzUtil.wildcardSimilar(toMatch, is)) continue;
            count += is.field_77994_a;
        }
        return count;
    }

    public static void addRecipe(ItemStack input, ItemStack output, float output_count, ItemStack solution) {
        if (output.field_77994_a != 1) {
            throw new RuntimeException("Stacksize should be 1");
        }
        if (output_count == 0.0f) {
            throw new RuntimeException("output_count is 0");
        }
        output = output.func_77946_l();
        output.field_77994_a = 0;
        recipes.add(new CrystalRecipe(input, output, output_count, solution));
    }

    CrystalRecipe getMatchingRecipe() {
        for (CrystalRecipe r : recipes) {
            if (!r.matches(this)) continue;
            return r;
        }
        return null;
    }

    ItemStack null2fake(ItemStack is) {
        if (is == null) {
            return Core.registry.crystallizer_item;
        }
        return is;
    }

    @Override
    public Packet getAuxillaryInfoPacket() {
        return this.getDescriptionPacketWith(110, this.null2fake(this.growing_crystal), this.null2fake(this.solution), this.progress);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 110) {
            this.growing_crystal = FzUtil.readStack(input);
            this.solution = FzUtil.readStack(input);
            this.progress = input.readInt();
            return true;
        }
        return false;
    }

    public double func_82115_m() {
        return 576.0;
    }

    public static class CrystalRecipe {
        public ItemStack input;
        public ItemStack output;
        public ItemStack solution;
        public float output_count;

        public CrystalRecipe(ItemStack input, ItemStack output, float output_count, ItemStack solution) {
            this.input = input;
            this.output = output;
            this.output_count = output_count;
            this.solution = solution;
        }

        boolean matches(TileEntityCrystallizer crys) {
            if (crys.output != null) {
                if (!FzUtil.couldMerge(crys.output, this.output)) {
                    return false;
                }
                if ((float)crys.output.field_77994_a + this.output_count > (float)crys.output.func_77976_d()) {
                    return false;
                }
            }
            if (this.solution != null && crys.countMaterial(this.solution) < this.solution.field_77994_a) {
                return false;
            }
            if (this.input != null) {
                return crys.countMaterial(this.input) >= this.input.field_77994_a;
            }
            return true;
        }

        private void applyTo(TileEntityCrystallizer crys, int slot) {
            int delta = (int)this.output_count;
            if ((float)delta != this.output_count && rand.nextFloat() < this.output_count - (float)delta) {
                ++delta;
            }
            if (crys.output != null && crys.output.field_77994_a + delta > crys.output.func_77976_d()) {
                return;
            }
            ItemStack is = this.input.func_77946_l();
            while (is.field_77994_a > 0) {
                --crys.inputs[slot].field_77994_a;
                crys.inputs[slot] = FzUtil.normalize(crys.inputs[slot]);
                --is.field_77994_a;
            }
            if (crys.output == null) {
                crys.output = this.output.func_77946_l();
                assert (this.output.field_77994_a == 0) : "output stack size is specified in the output_count";
                crys.output.field_77994_a = 0;
            }
            crys.output.field_77994_a += delta;
        }

        void apply(TileEntityCrystallizer crys) {
            for (int i = 0; i < crys.inputs.length; ++i) {
                ItemStack is = crys.inputs[i];
                if (is == null || !FzUtil.wildcardSimilar(this.input, is)) continue;
                this.applyTo(crys, i);
            }
        }
    }
}

