/*
 * Decompiled with CFR 0.152.
 */
package factorization.notify;

import factorization.api.Coord;
import factorization.notify.Notify;
import factorization.notify.NotifyImplementation;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

class Message {
    World world;
    Object locus;
    ItemStack item;
    String msg;
    EnumSet<Notify.Style> style;
    long creationTime;
    long lifeTime;
    boolean position_important = false;
    boolean show_item = false;

    public Message(World world, Object locus, ItemStack item, String format, String ... args) {
        this.world = world;
        this.locus = locus;
        this.item = item;
        this.msg = format;
        String[] parts = this.msg.split("\n", 2);
        this.style = NotifyImplementation.loadStyle(parts[0]);
        this.msg = parts[1];
        this.creationTime = System.currentTimeMillis();
        this.lifeTime = 6000L;
        if (this.style.contains((Object)Notify.Style.LONG)) {
            this.lifeTime += 5000L;
        }
        this.position_important = this.style.contains((Object)Notify.Style.EXACTPOSITION);
        this.show_item = this.style.contains((Object)Notify.Style.DRAWITEM);
        this.translate(args);
    }

    void translate(String ... args) {
        this.msg = StatCollector.func_74838_a((String)this.msg);
        for (int i = 0; i < args.length; ++i) {
            String translated;
            args[i] = translated = StatCollector.func_74838_a((String)args[i]);
        }
        String item_name = "null";
        String item_info = "";
        String item_info_newline = "";
        if (this.item != null) {
            item_name = this.item.func_82833_r();
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            ArrayList bits = new ArrayList();
            this.item.func_77973_b().func_77624_a(this.item, (EntityPlayer)player, bits, false);
            boolean tail = false;
            for (String s : bits) {
                if (tail) {
                    item_info = item_info + "\n";
                }
                tail = true;
                item_info = item_info + s;
            }
            item_info_newline = "\n" + item_info;
        }
        String itemString = this.item != null ? this.item.func_82833_r() : "null";
        String[] cp = new String[args.length + 3];
        for (int i = 0; i < args.length; ++i) {
            cp[i] = args[i];
        }
        cp[args.length] = item_name;
        cp[args.length + 1] = item_info;
        cp[args.length + 2] = item_info_newline;
        this.msg = this.msg.replace("{ITEM_NAME}", "%" + (args.length + 1) + "$s");
        this.msg = this.msg.replace("{ITEM_INFOS}", "%" + (args.length + 2) + "$s");
        this.msg = this.msg.replace("{ITEM_INFOS_NEWLINE}", "%" + (args.length + 3) + "$s");
        try {
            this.msg = String.format(this.msg, cp);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.msg = "FORMAT ERROR\n" + this.msg;
        }
    }

    static double interp(double old, double new_, float partial) {
        return old * (double)(1.0f - partial) + new_ * (double)partial;
    }

    Vec3 getPosition(float partial) {
        if (this.locus instanceof Vec3) {
            return (Vec3)this.locus;
        }
        if (this.locus instanceof Entity) {
            Entity e = (Entity)this.locus;
            double w = (double)e.field_70130_N * -1.5;
            double eye_height = (double)e.func_70047_e() + 0.25;
            return Vec3.func_72443_a((double)(Message.interp(e.field_70169_q, e.field_70165_t, partial) + w / 2.0), (double)(Message.interp(e.field_70167_r, e.field_70163_u, partial) + eye_height), (double)(Message.interp(e.field_70166_s, e.field_70161_v, partial) + w / 2.0));
        }
        if (this.locus instanceof TileEntity) {
            TileEntity te = (TileEntity)this.locus;
            return Vec3.func_72443_a((double)te.field_70329_l, (double)te.field_70330_m, (double)te.field_70327_n);
        }
        if (this.locus instanceof Coord) {
            return ((Coord)this.locus).createVector();
        }
        return null;
    }

    boolean stillValid() {
        if (this.locus instanceof Entity) {
            Entity e = (Entity)this.locus;
            return !e.field_70128_L;
        }
        if (this.locus instanceof TileEntity) {
            TileEntity te = (TileEntity)this.locus;
            return !te.func_70320_p();
        }
        return true;
    }

    Coord asCoordMaybe() {
        if (this.locus instanceof Coord) {
            return (Coord)this.locus;
        }
        if (this.locus instanceof TileEntity) {
            return new Coord((TileEntity)this.locus);
        }
        return null;
    }
}

