/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.common.FzConfig;
import factorization.shared.Core;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class Embarkener
implements ITickHandler {
    int wood_rendertype = Block.field_71951_J.func_71857_b();
    ArrayList<EmbarkenEvent> embarkenQueue = new ArrayList();
    EnumSet<TickType> myTicks = EnumSet.of(TickType.SERVER);

    public Embarkener() {
        if (FzConfig.embarken_wood) {
            this.addLogBarkRecipes();
            MinecraftForge.EVENT_BUS.register((Object)this);
            TickRegistry.registerTickHandler((ITickHandler)this, (Side)Side.SERVER);
        }
    }

    boolean isWoodish(Block block) {
        if (block == null) {
            return false;
        }
        return block.field_72018_cp == Material.field_76245_d && block instanceof BlockLog && block.func_71857_b() == this.wood_rendertype;
    }

    void addLogBarkRecipes() {
        int count = 0;
        for (Block block : Block.field_71973_m) {
            if (!this.isWoodish(block)) continue;
            for (int md = 0; md < 4; ++md) {
                ++count;
                ItemStack log = new ItemStack(block, 1, md);
                ItemStack barked = new ItemStack(block, 4, md | 0xC);
                Core.registry.shapelessRecipe(barked, log, log, log, log);
            }
        }
        Core.logInfo("Added %s 'barking' recipes for blocks that look sort of like wood logs; this can be disabled in the config file.", count);
    }

    @ForgeSubscribe
    public void enbarkenWood(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.entityPlayer == null) {
            return;
        }
        ItemStack is = event.entityPlayer.func_70694_bm();
        if (is == null) {
            return;
        }
        if (is.field_77993_c >= Block.field_71973_m.length) {
            return;
        }
        if ((is.func_77960_j() & 0xC) != 12) {
            return;
        }
        if (!(is.func_77973_b() instanceof ItemBlock)) {
            return;
        }
        Block theBlock = Block.field_71973_m[is.field_77993_c];
        if (!this.isWoodish(theBlock)) {
            return;
        }
        Coord target = new Coord(event.entityPlayer.field_70170_p, event.x, event.y, event.z);
        target.adjust(ForgeDirection.getOrientation((int)event.face));
        if (!target.isReplacable()) {
            return;
        }
        this.embarkenQueue.add(new EmbarkenEvent(target, is.field_77994_a, is, event.entityPlayer, (BlockLog)theBlock));
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        for (EmbarkenEvent e : this.embarkenQueue) {
            e.handle();
        }
        this.embarkenQueue.clear();
    }

    public EnumSet<TickType> ticks() {
        return this.myTicks;
    }

    public String getLabel() {
        return "fz.misc.embarken";
    }

    static class EmbarkenEvent {
        Coord target;
        int orig_stacksize;
        ItemStack stack;
        EntityPlayer player;
        BlockLog expectedBlock;

        public EmbarkenEvent(Coord target, int orig_stacksize, ItemStack stack, EntityPlayer player, BlockLog expectedBlock) {
            this.target = target;
            this.orig_stacksize = orig_stacksize;
            this.stack = stack;
            this.player = player;
            this.expectedBlock = expectedBlock;
        }

        void handle() {
            if (this.stack.field_77994_a >= this.orig_stacksize) {
                return;
            }
            if (this.player.field_70128_L) {
                return;
            }
            if (!this.target.blockExists()) {
                return;
            }
            if (this.target.getBlock() != this.expectedBlock) {
                return;
            }
            this.target.setMd(this.target.getMd() | 0xC);
        }
    }
}

