/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.api.IActOnCraft;
import factorization.ceramics.BasicGlazes;
import factorization.ceramics.ItemGlazeBucket;
import factorization.ceramics.ItemSculptingTool;
import factorization.ceramics.TileEntityGreenware;
import factorization.charge.ItemAcidBottle;
import factorization.charge.ItemBattery;
import factorization.charge.ItemChargeMeter;
import factorization.common.BlockResource;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.common.ItemBlockResource;
import factorization.common.ResourceType;
import factorization.common.WorldgenManager;
import factorization.darkiron.BlockDarkIronOre;
import factorization.oreprocessing.BlockOreStorageShatterable;
import factorization.oreprocessing.ItemOreProcessing;
import factorization.oreprocessing.TileEntityCrystallizer;
import factorization.oreprocessing.TileEntityGrinder;
import factorization.oreprocessing.TileEntitySlagFurnace;
import factorization.servo.ItemCommenter;
import factorization.servo.ItemMatrixProgrammer;
import factorization.servo.ItemServoMotor;
import factorization.servo.ItemServoRailWidget;
import factorization.servo.ServoComponent;
import factorization.shared.BlockClass;
import factorization.shared.BlockFactorization;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FzUtil;
import factorization.shared.ItemBlockProxy;
import factorization.shared.ItemCraftingComponent;
import factorization.shared.ItemFactorizationBlock;
import factorization.shared.Sound;
import factorization.sockets.ItemSocketPart;
import factorization.weird.ItemDayBarrel;
import factorization.weird.ItemPocketTable;
import factorization.weird.TileEntityDayBarrel;
import factorization.wrath.BlockLightAir;
import factorization.wrath.ItemBagOfHolding;
import factorization.wrath.ItemMachineUpgrade;
import factorization.wrath.ItemWrathIgniter;
import factorization.wrath.TileEntityWrathFire;
import factorization.wrath.TileEntityWrathLamp;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Registry
implements ICraftingHandler,
ITickHandler {
    public ItemFactorizationBlock item_factorization;
    public ItemBlockResource item_resource;
    public BlockFactorization factory_block;
    public BlockFactorization factory_rendering_block = null;
    public BlockRenderHelper blockRender = null;
    public BlockRenderHelper serverTraceHelper = null;
    public BlockRenderHelper clientTraceHelper = null;
    public BlockLightAir lightair_block;
    public BlockResource resource_block;
    public Block dark_iron_ore;
    public Block fractured_bedrock_block;
    public ItemStack router_item;
    public ItemStack servorail_item;
    public ItemStack empty_socket_item;
    public ItemStack socket_lacerator;
    public ItemStack socket_robot_hand;
    public ItemStack socket_shifter;
    public ItemStack stamper_item;
    public ItemStack packager_item;
    public ItemStack barrel_item;
    public ItemStack daybarrel_item_hidden;
    public ItemStack lamp_item;
    public ItemStack air_item;
    public ItemStack slagfurnace_item;
    public ItemStack battery_item_hidden;
    public ItemStack leydenjar_item;
    public ItemStack leydenjar_item_full;
    public ItemStack heater_item;
    public ItemStack steamturbine_item;
    public ItemStack solarboiler_item;
    public ItemStack caliometric_burner_item;
    public ItemStack mirror_item_hidden;
    public ItemStack leadwire_item;
    public ItemStack grinder_item;
    public ItemStack mixer_item;
    public ItemStack crystallizer_item;
    public ItemStack greenware_item;
    public ItemStack rocket_engine_item_hidden;
    public ItemStack parasieve_item;
    public ItemStack compression_crafter_item;
    public ItemStack silver_ore_item;
    public ItemStack silver_block_item;
    public ItemStack lead_block_item;
    public ItemStack dark_iron_block_item;
    public ItemStack is_factory;
    public ItemStack is_lamp;
    public ItemStack is_lightair;
    public ItemBagOfHolding bag_of_holding;
    public ItemPocketTable pocket_table;
    public ItemCraftingComponent diamond_shard;
    public ItemStack diamond_shard_packet;
    public IRecipe boh_upgrade_recipe;
    public ItemWrathIgniter wrath_igniter;
    public ItemCraftingComponent silver_ingot;
    public ItemCraftingComponent lead_ingot;
    public ItemCraftingComponent dark_iron;
    public ItemMachineUpgrade router_item_filter;
    public ItemMachineUpgrade router_machine_filter;
    public ItemMachineUpgrade router_speed;
    public ItemMachineUpgrade router_thorough;
    public ItemMachineUpgrade router_throughput;
    public ItemMachineUpgrade router_eject;
    public ItemMachineUpgrade barrel_enlarge;
    public ItemAcidBottle acid;
    public ItemCraftingComponent insulated_coil;
    public ItemCraftingComponent motor;
    public ItemCraftingComponent fan;
    public ItemCraftingComponent diamond_cutting_head;
    public ItemStack sulfuric_acid;
    public ItemStack aqua_regia;
    public ItemChargeMeter charge_meter;
    public ItemBlockProxy mirror;
    public ItemBattery battery;
    public ItemOreProcessing ore_dirty_gravel;
    public ItemOreProcessing ore_clean_gravel;
    public ItemOreProcessing ore_reduced;
    public ItemOreProcessing ore_crystal;
    public ItemCraftingComponent sludge;
    public ItemSculptingTool sculpt_tool;
    public ItemGlazeBucket glaze_bucket;
    public ItemStack base_common;
    public ItemStack glaze_base_mimicry;
    public ItemCraftingComponent logicMatrix;
    public ItemCraftingComponent logicMatrixIdentifier;
    public ItemCraftingComponent logicMatrixController;
    public ItemMatrixProgrammer logicMatrixProgrammer;
    public Fluid steamFluid;
    public ItemCraftingComponent nether_powder;
    public ItemCraftingComponent rocket_fuel;
    public ItemBlockProxy rocket_engine;
    public ItemServoMotor servo_placer;
    public ItemServoRailWidget servo_widget_instruction;
    public ItemServoRailWidget servo_widget_decor;
    public ItemStack dark_iron_sprocket;
    public ItemStack servo_motor;
    public ItemDayBarrel daybarrel;
    public ItemSocketPart socket_part;
    public ItemCraftingComponent instruction_plate;
    public ItemCommenter servo_rail_comment_editor;
    public Material materialMachine = new Material(MapColor.field_76288_h);
    WorldgenManager worldgenManager;
    HashSet<Integer> added_ids = new HashSet();
    private EnumSet<TickType> serverTicks = EnumSet.of(TickType.SERVER);

    static void registerItem(Item item) {
        GameRegistry.registerItem((Item)item, (String)item.func_77658_a(), (String)"factorization");
    }

    static void registerItem(Block block) {
        Registry.registerItem(new ItemStack(block).func_77973_b());
    }

    public void makeBlocks() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.blockRender = new BlockRenderHelper();
            this.factory_rendering_block = new BlockFactorization(FzConfig.factory_block_id);
            Block.field_71973_m[this.factory_rendering_block.field_71990_ca] = null;
        }
        this.serverTraceHelper = new BlockRenderHelper();
        this.clientTraceHelper = new BlockRenderHelper();
        this.factory_block = new BlockFactorization(FzConfig.factory_block_id);
        this.lightair_block = new BlockLightAir(FzConfig.lightair_id);
        this.resource_block = new BlockResource(FzConfig.resource_id);
        this.is_factory = new ItemStack((Block)this.factory_block);
        this.is_lightair = new ItemStack((Block)this.lightair_block);
        this.dark_iron_ore = new BlockDarkIronOre(FzConfig.dark_iron_ore_id).func_71864_b("factorization:darkIronOre").func_111022_d("stone").func_71849_a(Core.tabFactorization).func_71848_c(3.0f).func_71894_b(5.0f);
        this.fractured_bedrock_block = new Block(FzConfig.fractured_bedrock_id, Material.field_76246_e).func_71875_q().func_71894_b(6000000.0f).func_71864_b("bedrock").func_111022_d("bedrock").func_71849_a(Core.tabFactorization);
        ItemBlock itemDarkIronOre = new ItemBlock(FzConfig.dark_iron_ore_id - 256);
        ItemBlock itemFracturedBedrock = new ItemBlock(FzConfig.fractured_bedrock_id - 256);
        GameRegistry.registerBlock((Block)this.factory_block, ItemFactorizationBlock.class, (String)"FZ factory");
        GameRegistry.registerBlock((Block)this.lightair_block, (String)"FZ Lightair");
        GameRegistry.registerBlock((Block)this.resource_block, ItemBlockResource.class, (String)"FZ resource");
        GameRegistry.registerCraftingHandler((ICraftingHandler)this);
        Registry.registerItem((Block)this.factory_block);
        Registry.registerItem(this.lightair_block);
        Registry.registerItem(this.resource_block);
        Registry.registerItem(this.dark_iron_ore);
        Registry.registerItem(this.fractured_bedrock_block);
        Core.tab((Block)this.factory_block, Core.TabType.BLOCKS);
        Core.tab(this.resource_block, Core.TabType.BLOCKS);
        this.worldgenManager = new WorldgenManager();
        Block vanillaDiamond = Block.field_72071_ax;
        int diamondId = vanillaDiamond.field_71990_ca;
        Block.field_71973_m[diamondId] = null;
        BlockOreStorageShatterable newDiamond = new BlockOreStorageShatterable(diamondId, vanillaDiamond);
        newDiamond.func_71848_c(5.0f).func_71894_b(10.0f).func_71884_a(Block.field_71977_i).func_71864_b("blockDiamond");
    }

    public int itemID(String name2, int default_id) {
        int id = FzConfig.config.getItem("item", name2, default_id).getInt();
        if (this.added_ids.contains(default_id)) {
            throw new RuntimeException("Default ID already used: " + default_id);
        }
        if (Item.field_77698_e[id] != null) {
            throw new RuntimeException("Item ID conflict: " + id + " is already taken by " + Item.field_77698_e[id] + "; tried to use it for Factorization " + name2);
        }
        this.added_ids.add(default_id);
        return id;
    }

    void postMakeItems() {
        for (int id : this.added_ids) {
            Item it = Item.field_77698_e[id + 256];
            if (it == null) continue;
            it.func_111206_d(it.func_77658_a());
            Registry.registerItem(it);
        }
    }

    public void makeItems() {
        this.ore_dirty_gravel = new ItemOreProcessing(this.itemID("oreDirtyGravel", 9034), 36, "gravel");
        this.ore_clean_gravel = new ItemOreProcessing(this.itemID("oreCleanGravel", 9035), 37, "clean");
        this.ore_reduced = new ItemOreProcessing(this.itemID("oreReduced", 9036), 38, "reduced");
        this.ore_crystal = new ItemOreProcessing(this.itemID("oreCrystal", 9037), 39, "crystal");
        this.sludge = new ItemCraftingComponent(this.itemID("sludge", 9039), "sludge");
        OreDictionary.registerOre((String)"sludge", (Item)this.sludge);
        this.item_factorization = (ItemFactorizationBlock)Item.field_77698_e[this.factory_block.field_71990_ca];
        this.item_resource = (ItemBlockResource)Item.field_77698_e[this.resource_block.field_71990_ca];
        this.router_item = FactoryType.ROUTER.itemStack();
        this.servorail_item = FactoryType.SERVORAIL.itemStack();
        this.empty_socket_item = FactoryType.SOCKET_EMPTY.itemStack();
        this.parasieve_item = FactoryType.PARASIEVE.itemStack();
        this.compression_crafter_item = FactoryType.COMPRESSIONCRAFTER.itemStack();
        this.barrel_item = FactoryType.BARREL.itemStack();
        this.daybarrel_item_hidden = FactoryType.DAYBARREL.itemStack();
        this.stamper_item = FactoryType.STAMPER.itemStack();
        this.lamp_item = FactoryType.LAMP.itemStack();
        this.packager_item = FactoryType.PACKAGER.itemStack();
        this.slagfurnace_item = FactoryType.SLAGFURNACE.itemStack();
        this.battery_item_hidden = FactoryType.BATTERY.itemStack();
        this.leydenjar_item = FactoryType.LEYDENJAR.itemStack();
        this.steamturbine_item = FactoryType.STEAMTURBINE.itemStack();
        this.solarboiler_item = FactoryType.SOLARBOILER.itemStack();
        this.caliometric_burner_item = FactoryType.CALIOMETRIC_BURNER.itemStack();
        this.heater_item = FactoryType.HEATER.itemStack();
        this.mirror_item_hidden = FactoryType.MIRROR.itemStack();
        this.leadwire_item = FactoryType.LEADWIRE.itemStack();
        this.grinder_item = FactoryType.GRINDER.itemStack();
        this.mixer_item = FactoryType.MIXER.itemStack();
        this.crystallizer_item = FactoryType.CRYSTALLIZER.itemStack();
        this.greenware_item = FactoryType.CERAMIC.itemStack();
        this.rocket_engine_item_hidden = FactoryType.ROCKETENGINE.itemStack();
        this.silver_ore_item = ResourceType.SILVERORE.itemStack("Silver Ore");
        this.silver_block_item = ResourceType.SILVERBLOCK.itemStack("Block of Silver");
        this.lead_block_item = ResourceType.LEADBLOCK.itemStack("Block of Lead");
        this.dark_iron_block_item = ResourceType.DARKIRONBLOCK.itemStack("Block of Dark Iron");
        this.diamond_shard = new ItemCraftingComponent(this.itemID("diamondShard", 9006), "diamond_shard");
        this.wrath_igniter = new ItemWrathIgniter(this.itemID("wrathIgniter", 9007));
        this.dark_iron = new ItemCraftingComponent(this.itemID("darkIron", 9008), "dark_iron_ingot");
        this.lead_ingot = new ItemCraftingComponent(this.itemID("leadIngot", 9014), "lead_ingot");
        this.silver_ingot = new ItemCraftingComponent(this.itemID("silverIngot", 9015), "silver_ingot");
        OreDictionary.registerOre((String)"oreSilver", (ItemStack)this.silver_ore_item);
        OreDictionary.registerOre((String)"ingotSilver", (ItemStack)new ItemStack((Item)this.silver_ingot));
        OreDictionary.registerOre((String)"ingotLead", (ItemStack)new ItemStack((Item)this.lead_ingot));
        OreDictionary.registerOre((String)"blockSilver", (ItemStack)this.silver_block_item);
        OreDictionary.registerOre((String)"blockLead", (ItemStack)this.lead_block_item);
        OreDictionary.registerOre((String)"oreFzDarkIron", (Block)this.dark_iron_ore);
        OreDictionary.registerOre((String)"ingotFzDarkIron", (Item)this.dark_iron);
        OreDictionary.registerOre((String)"blockFzDarkIron", (ItemStack)this.dark_iron_block_item);
        this.bag_of_holding = new ItemBagOfHolding(this.itemID("bagOfHolding", 9001));
        this.logicMatrixProgrammer = new ItemMatrixProgrammer(this.itemID("logicMatrixProgrammer", 9043));
        for (String chestName : new String[]{"strongholdLibrary", "dungeonChest"}) {
            ChestGenHooks dungeon = ChestGenHooks.getInfo((String)chestName);
            dungeon.addItem(new WeightedRandomChestContent(new ItemStack((Item)this.logicMatrixProgrammer), 1, 1, 35));
        }
        this.logicMatrix = new ItemCraftingComponent(this.itemID("logicMatrix", 9044), "logic_matrix");
        this.logicMatrixIdentifier = new ItemCraftingComponent(this.itemID("logicMatrixID", 9045), "logic_matrix_identifier");
        this.logicMatrixController = new ItemCraftingComponent(this.itemID("logicMatrixCtrl", 9063), "logic_matrix_controller");
        this.router_item_filter = new ItemMachineUpgrade(this.itemID("routerItemFilter", 9016), "router/item_filter", "Router Upgrade", FactoryType.ROUTER, 0);
        this.router_machine_filter = new ItemMachineUpgrade(this.itemID("routerMachineFilter", 9017), "router/machine_filter", "Router Upgrade", FactoryType.ROUTER, 1);
        this.router_speed = new ItemMachineUpgrade(this.itemID("routerSpeed", 9018), "router/speed", "Router Upgrade", FactoryType.ROUTER, 2);
        this.router_thorough = new ItemMachineUpgrade(this.itemID("routerThorough", 9019), "router/thorough", "Router Upgrade", FactoryType.ROUTER, 3);
        this.router_throughput = new ItemMachineUpgrade(this.itemID("routerThroughput", 9020), "router/bandwidth", "Router Upgrade", FactoryType.ROUTER, 4);
        this.router_eject = new ItemMachineUpgrade(this.itemID("routerEject", 9031), "router/eject", "Router Upgrade", FactoryType.ROUTER, 5);
        this.barrel_enlarge = new ItemMachineUpgrade(this.itemID("barrelEnlarge", 9032), "barrel_upgrade", "Barrel Upgrade", FactoryType.BARREL, 6);
        this.acid = new ItemAcidBottle(this.itemID("acid", 9024));
        this.sulfuric_acid = new ItemStack((Item)this.acid, 1);
        this.aqua_regia = new ItemStack((Item)this.acid, 1, 1);
        OreDictionary.registerOre((String)"sulfuricAcid", (ItemStack)this.sulfuric_acid);
        OreDictionary.registerOre((String)"bottleSulfuricAcid", (ItemStack)this.sulfuric_acid);
        OreDictionary.registerOre((String)"aquaRegia", (ItemStack)this.aqua_regia);
        this.insulated_coil = new ItemCraftingComponent(this.itemID("coil", 9026), "insulated_coil");
        this.motor = new ItemCraftingComponent(this.itemID("motor", 9027), "motor");
        this.fan = new ItemCraftingComponent(this.itemID("fan", 9028), "fan");
        this.diamond_cutting_head = new ItemCraftingComponent(this.itemID("diamondCuttingHead", 9038), "diamond_cutting_head");
        this.charge_meter = new ItemChargeMeter(this.itemID("chargemeter", 9029));
        this.mirror = new ItemBlockProxy(this.itemID("mirror", 9030), this.mirror_item_hidden, "mirror", Core.TabType.CHARGE);
        this.battery = new ItemBattery(this.itemID("battery", 9033));
        this.leydenjar_item_full = ItemStack.func_77944_b((ItemStack)this.leydenjar_item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("storage", 1280000);
        this.leydenjar_item_full.func_77982_d(tag);
        this.sculpt_tool = new ItemSculptingTool(this.itemID("sculptTool", 9041));
        this.glaze_bucket = new ItemGlazeBucket(this.itemID("glazeBucket", 9055));
        this.pocket_table = new ItemPocketTable(this.itemID("pocketCraftingTable", 9002));
        this.steamFluid = new Fluid("steam").setDensity(-500).setGaseous(true).setViscosity(100).setUnlocalizedName("factorization:fluid/steam").setTemperature(383);
        FluidRegistry.registerFluid((Fluid)this.steamFluid);
        this.nether_powder = new ItemCraftingComponent(this.itemID("netherPowder", 9050), "nether_powder");
        if (FzConfig.enable_dimension_slice) {
            this.rocket_fuel = new ItemCraftingComponent(this.itemID("heldRocketFuel", 9051), "rocket/rocket_fuel");
            this.rocket_engine = new ItemBlockProxy(this.itemID("rocketEngine", 9053), this.rocket_engine_item_hidden, "rocket/rocket_engine", Core.TabType.ROCKETRY);
            this.rocket_engine.func_77625_d(1);
        }
        this.servo_placer = new ItemServoMotor(this.itemID("servoMotorPlacer", 9056));
        this.servo_widget_decor = new ItemServoRailWidget(this.itemID("servoWidgetDecor", 9057), "servo/decorator");
        this.servo_widget_instruction = new ItemServoRailWidget(this.itemID("servoWidgetInstruction", 9061), "servo/component");
        this.servo_widget_decor.func_77625_d(16);
        this.servo_widget_instruction.func_77625_d(1);
        this.dark_iron_sprocket = new ItemStack((Item)new ItemCraftingComponent(this.itemID("darkIronSprocket", 9059), "servo/sprocket"));
        this.servo_motor = new ItemStack((Item)new ItemCraftingComponent(this.itemID("servoMotor", 9060), "servo/servo_motor"));
        this.socket_part = new ItemSocketPart(this.itemID("socketPart", 9064), "socket/", Core.TabType.SERVOS);
        this.instruction_plate = new ItemCraftingComponent(this.itemID("instructionPlate", 9065), "servo/instruction_plate", Core.TabType.SERVOS);
        this.instruction_plate.setSpriteNumber(0);
        this.servo_rail_comment_editor = new ItemCommenter(this.itemID("servoCommenter", 9066), "servo/commenter");
        this.socket_lacerator = FactoryType.SOCKET_LACERATOR.asSocketItem();
        this.socket_robot_hand = FactoryType.SOCKET_ROBOTHAND.asSocketItem();
        this.socket_shifter = FactoryType.SOCKET_SHIFTER.asSocketItem();
        this.daybarrel = new ItemDayBarrel(this.itemID("daybarrelItem", 9062), "daybarrel");
        this.postMakeItems();
    }

    public void recipe(ItemStack res, Object ... params) {
        GameRegistry.addRecipe((ItemStack)res, (Object[])params);
    }

    public void shapelessRecipe(ItemStack res, Object ... params) {
        if (res == null) {
            return;
        }
        GameRegistry.addShapelessRecipe((ItemStack)res, (Object[])params);
    }

    public void oreRecipe(ItemStack res, Object ... params) {
        if (res == null) {
            return;
        }
        this.convertOreItems(params);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(res, params));
    }

    void batteryRecipe(ItemStack res, Object ... params) {
        for (int damage : new int[]{1, 2}) {
            ArrayList<Object> items = new ArrayList<Object>(params.length);
            for (Object p : params) {
                if (p == this.battery) {
                    p = new ItemStack((Item)this.battery, 1, damage);
                }
                items.add(p);
            }
            this.oreRecipe(res, items.toArray());
        }
    }

    public void shapelessOreRecipe(ItemStack res, Object ... params) {
        if (res == null) {
            return;
        }
        this.convertOreItems(params);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(res, params));
    }

    private void convertOreItems(Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == Block.field_71978_w) {
                params[i] = "cobblestone";
                continue;
            }
            if (params[i] == Block.field_71981_t) {
                params[i] = "stone";
                continue;
            }
            if (params[i] != Item.field_77669_D) continue;
            params[i] = "stickWood";
        }
    }

    public void makeRecipes() {
        this.recipe(new ItemStack((Block)Block.field_72085_aj), "-", "-", Character.valueOf('-'), new ItemStack((Block)Block.field_72079_ak));
        this.recipe(new ItemStack((Block)Block.field_72085_aj, 4, 8), "##", "##", Character.valueOf('#'), new ItemStack((Block)Block.field_72085_aj));
        this.recipe(new ItemStack((Block)Block.field_72085_aj, 2, 9), "#", "#", Character.valueOf('#'), new ItemStack(Block.field_71957_Q, 1, 2));
        this.shapelessRecipe(new ItemStack((Item)this.dark_iron, 9), this.dark_iron_block_item);
        this.recipe(this.dark_iron_block_item, new Object[]{"III", "III", "III", Character.valueOf('I'), this.dark_iron});
        ItemStack BOH = new ItemStack((Item)this.bag_of_holding, 1);
        this.recipe(BOH, new Object[]{"LOL", "ILI", " I ", Character.valueOf('I'), this.dark_iron, Character.valueOf('O'), Item.field_77730_bn, Character.valueOf('L'), Item.field_77770_aF});
        this.shapelessRecipe(BOH, new Object[]{BOH, this.dark_iron, Item.field_77730_bn, Item.field_77770_aF});
        this.boh_upgrade_recipe = FzUtil.createShapelessRecipe(BOH, new Object[]{BOH, this.dark_iron, Item.field_77730_bn, Item.field_77770_aF});
        this.oreRecipe(new ItemStack((Item)this.pocket_table), " #", "| ", Character.valueOf('#'), Block.field_72060_ay, Character.valueOf('|'), Item.field_77669_D);
        this.recipe(new ItemStack((Item)this.logicMatrixIdentifier), new Object[]{"MiX", Character.valueOf('M'), this.logicMatrix, Character.valueOf('i'), Item.field_94583_ca, Character.valueOf('X'), this.logicMatrixProgrammer});
        this.oreRecipe(new ItemStack((Item)this.logicMatrixController), new Object[]{"MiX", Character.valueOf('M'), this.logicMatrix, Character.valueOf('i'), "ingotSilver", Character.valueOf('X'), this.logicMatrixProgrammer});
        this.recipe(new ItemStack((Item)this.logicMatrixProgrammer), new Object[]{"MiX", Character.valueOf('M'), this.logicMatrix, Character.valueOf('i'), this.dark_iron, Character.valueOf('X'), this.logicMatrixProgrammer});
        this.recipe(new ItemStack((Item)this.logicMatrixProgrammer), new Object[]{"DSI", " #>", "BSI", Character.valueOf('D'), Item.field_77819_bI, Character.valueOf('B'), Item.field_77781_bS, Character.valueOf('S'), this.diamond_shard, Character.valueOf('I'), this.dark_iron, Character.valueOf('#'), this.logicMatrix, Character.valueOf('>'), Item.field_94585_bY});
        int librarianVillager = 1;
        VillagerRegistry.instance().registerVillageTradeHandler(librarianVillager, new VillagerRegistry.IVillageTradeHandler(){

            public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
                int min = 2;
                int max = 3;
                ItemMatrixProgrammer item = Core.registry.logicMatrixProgrammer;
                float chance = 1.0f;
                if (min > 0 && max > 0) {
                    EntityVillager.field_70960_bC.put(item.field_77779_bT, new Tuple((Object)min, (Object)max));
                }
                EntityVillager.func_70949_b((MerchantRecipeList)recipeList, (int)item.field_77779_bT, (Random)random, (float)chance);
            }
        });
        TileEntityCrystallizer.addRecipe(new ItemStack(Block.field_94341_cq), new ItemStack((Item)this.logicMatrix), 1.0f, Core.registry.aqua_regia);
        this.recipe(new ItemStack((Item)this.wrath_igniter), new Object[]{"D ", " B", Character.valueOf('D'), this.diamond_shard, Character.valueOf('B'), Item.field_94584_bZ});
        this.recipe(new ItemStack((Item)this.lead_ingot, 9), "#", Character.valueOf('#'), this.lead_block_item);
        this.recipe(new ItemStack((Item)this.silver_ingot, 9), "#", Character.valueOf('#'), this.silver_block_item);
        this.oreRecipe(this.lead_block_item, "###", "###", "###", Character.valueOf('#'), "ingotLead");
        this.oreRecipe(this.silver_block_item, "###", "###", "###", Character.valueOf('#'), "ingotSilver");
        FurnaceRecipes.func_77602_a().addSmelting(this.resource_block.field_71990_ca, ResourceType.SILVERORE.md, new ItemStack((Item)this.silver_ingot), 0.3f);
        FurnaceRecipes.func_77602_a().addSmelting(this.dark_iron_ore.field_71990_ca, 0, new ItemStack((Item)this.dark_iron), 0.5f);
        this.oreRecipe(new ItemStack((Item)this.sculpt_tool), " c", "/ ", Character.valueOf('c'), Item.field_77757_aI, Character.valueOf('/'), Item.field_77669_D);
        ItemSculptingTool.addModeChangeRecipes();
        this.oreRecipe(new ItemStack((Item)this.glaze_bucket), "_ _", "# #", "#_#", Character.valueOf('_'), "slabWood", Character.valueOf('#'), "plankWood");
        this.base_common = this.glaze_bucket.makeCraftingGlaze("base_common");
        this.glaze_base_mimicry = this.glaze_bucket.makeCraftingGlaze("base_mimicry");
        this.glaze_bucket.addGlaze(this.glaze_base_mimicry);
        ItemStack charcoal = new ItemStack(Item.field_77705_m, 1, 1);
        ItemStack bonemeal = new ItemStack(Item.field_77756_aW, 1, 15);
        ItemStack lapis = new ItemStack(Item.field_77756_aW, 1, 4);
        ItemStack lead_chunks = new ItemStack((Item)this.ore_reduced, 1, ItemOreProcessing.OreType.LEAD.ID);
        ItemStack iron_chunks = new ItemStack((Item)this.ore_reduced, 1, ItemOreProcessing.OreType.IRON.ID);
        Item netherquartz = Item.field_94583_ca;
        Item netherbrick = Item.field_94584_bZ;
        Block sand = Block.field_71939_E;
        Item redstone = Item.field_77767_aC;
        Item slimeBall = Item.field_77761_aM;
        ItemStack blackWool = new ItemStack(Block.field_72101_ab, 1, 15);
        this.shapelessOreRecipe(this.base_common, new ItemStack((Item)this.glaze_bucket), Item.field_77786_ax, Block.field_71939_E, Item.field_77757_aI);
        this.shapelessOreRecipe(this.glaze_base_mimicry, this.base_common, Item.field_77767_aC, Item.field_77761_aM, lapis);
        BasicGlazes.ST_VECHS_BLACK.recipe(this.base_common, blackWool, charcoal);
        BasicGlazes.TEMPLE_WHITE.recipe(this.base_common, bonemeal, bonemeal);
        BasicGlazes.SALLYS_WHITE.recipe(this.base_common, netherquartz, netherquartz);
        BasicGlazes.CLEAR.recipe(this.base_common, sand, sand);
        BasicGlazes.REDSTONE_OXIDE.recipe(this.base_common, redstone);
        BasicGlazes.LAPIS_OXIDE.recipe(this.base_common, lapis);
        BasicGlazes.PURPLE_OXIDE.recipe(this.base_common, redstone, lapis);
        BasicGlazes.LEAD_OXIDE.recipe(this.base_common, lead_chunks);
        BasicGlazes.FIRE_ENGINE_RED.recipe(this.base_common, redstone, redstone);
        BasicGlazes.CELEDON.recipe(this.base_common, sand, slimeBall);
        BasicGlazes.IRON_BLUE.recipe(this.base_common, lapis, iron_chunks);
        BasicGlazes.STONEWARE_SLIP.recipe(new Object[]{this.base_common, this.sludge, this.sludge});
        BasicGlazes.TENMOKU.recipe(this.base_common, netherbrick, netherbrick);
        BasicGlazes.PEKING_BLUE.recipe(this.base_common, lapis, netherquartz);
        BasicGlazes.SHINO.recipe(this.base_common, redstone, netherquartz);
        ItemStack waterFeature = this.glaze_bucket.makeMimicingGlaze(Block.field_71942_A.field_71990_ca, 0, -1);
        ItemStack lavaFeature = this.glaze_bucket.makeMimicingGlaze(Block.field_71944_C.field_71990_ca, 0, -1);
        this.shapelessOreRecipe(waterFeature, this.base_common, Item.field_77786_ax);
        this.shapelessOreRecipe(lavaFeature, this.base_common, Item.field_77775_ay);
        Core.registry.glaze_bucket.doneMakingStandardGlazes();
        GameRegistry.addRecipe((IRecipe)new IRecipe(){

            ArrayList<ItemStack> merge(InventoryCrafting inv) {
                ArrayList<ItemStack> match = new ArrayList<ItemStack>(2);
                boolean part_count = false;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack is = inv.func_70301_a(i);
                    if (is == null) continue;
                    if (!is.func_77942_o()) {
                        return null;
                    }
                    Item item = is.func_77973_b();
                    if (FzUtil.similar(Core.registry.greenware_item, is)) {
                        match.add(is);
                        continue;
                    }
                    return null;
                }
                if (match.size() != 2) {
                    return null;
                }
                return match;
            }

            public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
                ArrayList<ItemStack> matching = this.merge(inventorycrafting);
                if (matching == null) {
                    return false;
                }
                int partCount = 0;
                TileEntityGreenware rep = (TileEntityGreenware)FactoryType.CERAMIC.getRepresentative();
                for (ItemStack is : matching) {
                    rep.loadParts(is.func_77978_p());
                    if (rep.getState() != TileEntityGreenware.ClayState.WET) {
                        return false;
                    }
                    if ((partCount += rep.parts.size()) < TileEntityGreenware.MAX_PARTS) continue;
                    return false;
                }
                return true;
            }

            public int func_77570_a() {
                return 2;
            }

            public ItemStack func_77571_b() {
                return Registry.this.greenware_item.func_77946_l();
            }

            public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
                ArrayList<ItemStack> matching = this.merge(inventorycrafting);
                TileEntityGreenware target = new TileEntityGreenware();
                for (ItemStack is : matching) {
                    TileEntityGreenware rep = (TileEntityGreenware)FactoryType.CERAMIC.getRepresentative();
                    rep.loadParts(is.func_77978_p());
                    target.parts.addAll(rep.parts);
                }
                return target.getItem();
            }
        });
        GameRegistry.addRecipe((IRecipe)new IRecipe(){
            final int[] side_map = new int[]{1, 2, 1, 4, 0, 5, 0, 3, 0};

            public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
                int mimic_items = 0;
                int other_items = 0;
                for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                    ItemStack is = inventorycrafting.func_70301_a(i);
                    if (is == null) continue;
                    if (FzUtil.couldMerge(Registry.this.glaze_base_mimicry, is)) {
                        ++mimic_items;
                        continue;
                    }
                    if (is.field_77993_c >= Block.field_71973_m.length) {
                        return false;
                    }
                    int d = is.func_77960_j();
                    if (d < 0 || d > 16) {
                        return false;
                    }
                    Block b = Block.field_71973_m[is.field_77993_c];
                    if (b == null || b.func_71917_a().equals("tile.ForgeFiller")) {
                        return false;
                    }
                    ++other_items;
                }
                return mimic_items == 1 && other_items == 1;
            }

            public int func_77570_a() {
                return 2;
            }

            public ItemStack func_77571_b() {
                return Registry.this.glaze_base_mimicry;
            }

            public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
                ItemStack is;
                int bucket_slot = -1;
                int block_slot = -1;
                for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                    Block b;
                    int d;
                    is = inventorycrafting.func_70301_a(i);
                    if (is == null) continue;
                    if (FzUtil.couldMerge(Registry.this.glaze_base_mimicry, is)) {
                        bucket_slot = i;
                        continue;
                    }
                    if (is.field_77993_c >= Block.field_71973_m.length || (d = is.func_77960_j()) < 0 || d > 16 || (b = Block.field_71973_m[is.field_77993_c]) == null || b.func_71917_a().equals("tile.ForgeFiller")) continue;
                    block_slot = i;
                }
                if (bucket_slot == -1 || block_slot == -1) {
                    return null;
                }
                int side = 0;
                try {
                    side = block_slot == 4 ? this.side_map[block_slot] : -1;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                is = inventorycrafting.func_70301_a(block_slot);
                return Registry.this.glaze_bucket.makeMimicingGlaze(is.field_77993_c, is.func_77960_j(), side);
            }
        });
        this.recipe(this.router_item, new Object[]{"MMM", "oIO", "MMM", Character.valueOf('M'), this.dark_iron, Character.valueOf('I'), Item.field_77764_aP, Character.valueOf('o'), Item.field_77730_bn, Character.valueOf('O'), Item.field_77748_bA});
        this.recipe(this.router_item, new Object[]{"MMM", "OIo", "MMM", Character.valueOf('M'), this.dark_iron, Character.valueOf('I'), Item.field_77764_aP, Character.valueOf('o'), Item.field_77730_bn, Character.valueOf('O'), Item.field_77748_bA});
        this.recipe(new ItemStack((Item)this.router_item_filter), new Object[]{"ITI", "GDG", "ICI", Character.valueOf('I'), this.dark_iron, Character.valueOf('T'), Block.field_72035_aQ, Character.valueOf('D'), this.logicMatrixIdentifier, Character.valueOf('G'), Item.field_77717_p, Character.valueOf('C'), Block.field_72077_au});
        this.oreRecipe(new ItemStack((Item)this.router_machine_filter), new Object[]{"ITI", "SDS", "IBI", Character.valueOf('I'), this.dark_iron, Character.valueOf('T'), Block.field_72035_aQ, Character.valueOf('D'), this.logicMatrixIdentifier, Character.valueOf('S'), "ingotSilver", Character.valueOf('B'), Item.field_77760_aL});
        this.recipe(new ItemStack((Item)this.router_speed), new Object[]{"ISI", "SCS", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), Item.field_77747_aY, Character.valueOf('C'), Item.field_77746_aZ});
        this.recipe(new ItemStack((Item)this.router_thorough), new Object[]{"ISI", "SSS", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), Block.field_72013_bc});
        this.recipe(new ItemStack((Item)this.router_throughput), new Object[]{"IBI", "B!B", "IBI", Character.valueOf('I'), this.dark_iron, Character.valueOf('B'), Item.field_77722_bw, Character.valueOf('!'), Item.field_77764_aP});
        this.oreRecipe(new ItemStack((Item)this.router_eject), new Object[]{"IWI", "C_C", "IPI", Character.valueOf('I'), this.dark_iron, Character.valueOf('W'), "plankWood", Character.valueOf('C'), Block.field_71978_w, Character.valueOf('_'), Block.field_72046_aM, Character.valueOf('P'), Block.field_71963_Z});
        for (int i = 0; i < 4; ++i) {
            ItemStack log = new ItemStack(Block.field_71951_J, 1, i);
            ItemStack slab = new ItemStack((Block)Block.field_72092_bO, 1, i);
            TileEntityDayBarrel.makeRecipe(log, slab);
        }
        this.oreRecipe(this.stamper_item, "#p#", "#S#", "#C#", Character.valueOf('#'), Block.field_71978_w, Character.valueOf('p'), Block.field_71963_Z, Character.valueOf('S'), Item.field_77669_D, Character.valueOf('C'), Block.field_72060_ay);
        this.oreRecipe(this.packager_item, "#p#", "I I", "#C#", Character.valueOf('#'), Block.field_71978_w, Character.valueOf('p'), Block.field_71963_Z, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('C'), Block.field_72060_ay);
        this.oreRecipe(this.compression_crafter_item, new Object[]{"D", "C", "P", Character.valueOf('D'), this.dark_iron, Character.valueOf('C'), Block.field_72060_ay, Character.valueOf('P'), Block.field_71963_Z});
        this.oreRecipe(this.lamp_item, new Object[]{"ISI", "GWG", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), "ingotSilver", Character.valueOf('G'), Block.field_72003_bq, Character.valueOf('W'), new ItemStack((Item)this.wrath_igniter, 1, Short.MAX_VALUE)});
        this.recipe(this.slagfurnace_item, "CFC", "C C", "CFC", Character.valueOf('C'), Block.field_71978_w, Character.valueOf('F'), Block.field_72051_aB);
        TileEntitySlagFurnace.SlagRecipes.register(Block.field_72047_aN, 5.8f, Item.field_77767_aC, 0.2f, Block.field_71981_t);
        this.oreRecipe(this.greenware_item, "c", "-", Character.valueOf('c'), Item.field_77757_aI, Character.valueOf('-'), "slabWood");
        this.shapelessRecipe(this.sulfuric_acid, Item.field_77677_M, Item.field_77677_M, Item.field_77705_m, Item.field_77726_bs);
        this.shapelessOreRecipe(this.sulfuric_acid, "dustSulfur", Item.field_77705_m, Item.field_77726_bs);
        this.shapelessRecipe(this.aqua_regia, new Object[]{this.sulfuric_acid, this.nether_powder, Item.field_77811_bE});
        this.shapelessRecipe(this.aqua_regia, this.sulfuric_acid, Item.field_77722_bw, Item.field_77811_bE);
        this.recipe(new ItemStack((Item)this.fan), "I I", " I ", "I I", Character.valueOf('I'), Item.field_77703_o);
        if (FzConfig.enable_solar_steam) {
            this.recipe(this.solarboiler_item, "I#I", "I I", "III", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('#'), Block.field_72002_bp);
        }
        this.oreRecipe(this.steamturbine_item, new Object[]{"I#I", "GXG", "LML", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('#'), Block.field_72002_bp, Character.valueOf('G'), Block.field_72003_bq, Character.valueOf('X'), this.fan, Character.valueOf('L'), "ingotLead", Character.valueOf('M'), this.motor});
        this.oreRecipe(this.caliometric_burner_item, "BPB", "BAB", "BLB", Character.valueOf('B'), Item.field_77755_aX, Character.valueOf('P'), Block.field_71956_V, Character.valueOf('A'), this.sulfuric_acid, Character.valueOf('L'), Item.field_77770_aF);
        this.oreRecipe(new ItemStack((Item)this.charge_meter), "WSW", "W|W", "LIL", Character.valueOf('W'), "plankWood", Character.valueOf('S'), Item.field_77792_au, Character.valueOf('|'), Item.field_77669_D, Character.valueOf('L'), "ingotLead", Character.valueOf('I'), Item.field_77703_o);
        this.oreRecipe(new ItemStack((Item)this.battery, 1, 2), new Object[]{"ILI", "LAL", "ILI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('L'), "ingotLead", Character.valueOf('A'), this.acid});
        this.oreRecipe(this.leydenjar_item, "#G#", "#L#", "L#L", Character.valueOf('#'), Block.field_72003_bq, Character.valueOf('G'), Block.field_71946_M, Character.valueOf('L'), "ingotLead");
        this.oreRecipe(this.heater_item, new Object[]{"CCC", "L L", "CCC", Character.valueOf('C'), this.insulated_coil, Character.valueOf('L'), "ingotLead"});
        this.oreRecipe(new ItemStack((Item)this.insulated_coil, 4), "LLL", "LCL", "LLL", Character.valueOf('L'), "ingotLead", Character.valueOf('C'), Block.field_72041_aW);
        this.batteryRecipe(new ItemStack((Item)this.motor), new Object[]{"CIC", "CIC", "LBL", Character.valueOf('C'), this.insulated_coil, Character.valueOf('B'), this.battery, Character.valueOf('L'), "ingotLead", Character.valueOf('I'), Item.field_77703_o});
        if (FzConfig.enable_solar_steam) {
            this.oreRecipe(new ItemStack((Item)this.mirror), "SSS", "S#S", "SSS", Character.valueOf('S'), "ingotSilver", Character.valueOf('#'), Block.field_72003_bq);
        }
        ItemStack with_8 = this.leadwire_item.func_77946_l();
        with_8.field_77994_a = 8;
        this.oreRecipe(with_8, "LLL", Character.valueOf('L'), "ingotLead");
        this.recipe(new ItemStack((Item)this.diamond_cutting_head), new Object[]{"SSS", "S-S", "SSS", Character.valueOf('S'), this.diamond_shard, Character.valueOf('-'), Block.field_94345_cm});
        this.shapelessRecipe(this.socket_lacerator, this.grinder_item);
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_71950_I), new ItemStack(Item.field_77705_m), 1.5f);
        TileEntityGrinder.addRecipe("oreRedstone", new ItemStack(Item.field_77767_aC), 5.0f);
        TileEntityGrinder.addRecipe("oreDiamond", new ItemStack(Item.field_77702_n), 1.25f);
        TileEntityGrinder.addRecipe("oreEmerald", new ItemStack(Item.field_77817_bH), 1.25f);
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_94342_cr), new ItemStack(Item.field_94583_ca), 2.5f);
        TileEntityGrinder.addRecipe("oreLapis", new ItemStack(Item.field_77756_aW, 1, 4), 8.5f);
        TileEntityGrinder.addRecipe(Block.field_71981_t, new ItemStack(Block.field_71978_w), 1.0f);
        TileEntityGrinder.addRecipe(Block.field_71978_w, new ItemStack(Block.field_71940_F), 1.0f);
        TileEntityGrinder.addRecipe("treeSapling", new ItemStack(Item.field_77669_D), 1.25f);
        TileEntityGrinder.addRecipe(Block.field_71940_F, new ItemStack(Block.field_71939_E), 1.0f);
        TileEntityGrinder.addRecipe("treeLeaves", new ItemStack(Item.field_77669_D), 0.5f);
        TileEntityGrinder.addRecipe(Block.field_71946_M, new ItemStack(Block.field_71939_E), 0.1f);
        TileEntityGrinder.addRecipe(Block.field_71955_W, new ItemStack(Item.field_77683_K), 0.25f);
        TileEntityGrinder.addRecipe(Block.field_72081_al, new ItemStack(Item.field_77772_aH), 3.5f);
        TileEntityGrinder.addRecipe(Block.field_72087_ao, new ItemStack(Block.field_71940_F), 1.0f);
        TileEntityGrinder.addRecipe(Block.field_72065_as, new ItemStack(Block.field_72002_bp), 2.5f);
        TileEntityGrinder.addRecipe(Block.field_72051_aB, new ItemStack(Block.field_71978_w), 7.0f);
        TileEntityGrinder.addRecipe(Block.field_72052_aC, new ItemStack(Block.field_71981_t), 7.0f);
        TileEntityGrinder.addRecipe(Block.field_72055_aF, new ItemStack(Item.field_77669_D), 1.5f);
        TileEntityGrinder.addRecipe(Block.field_72037_aS, new ItemStack(Item.field_77768_aD), 0.25f);
        TileEntityGrinder.addRecipe(Block.field_72039_aU, new ItemStack(Item.field_77768_aD), 4.0f);
        TileEntityGrinder.addRecipe(Block.field_72041_aW, new ItemStack(Item.field_77757_aI), 4.0f);
        TileEntityGrinder.addRecipe(Block.field_72031_aZ, new ItemStack(Item.field_77669_D), 2.5f);
        TileEntityGrinder.addRecipe(Block.field_72014_bd, new ItemStack(Item.field_77751_aT), 4.0f);
        TileEntityGrinder.addRecipe(Block.field_72005_bk, new ItemStack(Item.field_77669_D), 3.5f);
        TileEntityGrinder.addRecipe(Block.field_72007_bm, new ItemStack(Block.field_71978_w), 0.75f);
        TileEntityGrinder.addRecipe(Block.field_72003_bq, new ItemStack(Block.field_71939_E), 0.00625f);
        TileEntityGrinder.addRecipe(Block.field_71997_br, new ItemStack(Item.field_77738_bf), 7.75f);
        TileEntityGrinder.addRecipe(Block.field_71993_bv, new ItemStack(Item.field_77669_D), 2.5f);
        TileEntityGrinder.addRecipe(Block.field_72033_bA, new ItemStack(Item.field_94584_bZ), 3.5f);
        TileEntityGrinder.addRecipe(Block.field_72098_bB, new ItemStack(Item.field_94584_bZ), 2.5f);
        TileEntityGrinder.addRecipe(Block.field_72080_bM, new ItemStack(Item.field_77751_aT), 4.0f);
        TileEntityGrinder.addRecipe(Block.field_72078_bL, new ItemStack(Item.field_77751_aT), 4.0f);
        TileEntityGrinder.addRecipe(Block.field_94339_ct, new ItemStack(Item.field_94583_ca), 3.5f);
        TileEntityGrinder.addRecipe(Block.field_111038_cB, new ItemStack(Item.field_77685_T), 8.25f);
        TileEntityGrinder.addRecipe(Item.field_77760_aL, new ItemStack(Item.field_77770_aF), 0.75f);
        TileEntityGrinder.addRecipe(Item.field_92105_bW, new ItemStack(Item.field_77770_aF), 0.9f);
        TileEntityGrinder.addRecipe(new ItemStack(Item.field_82799_bQ, 1, 0), new ItemStack(Item.field_77756_aW, 1, 15), 6.5f);
        TileEntityGrinder.addRecipe(new ItemStack(Item.field_82799_bQ, 1, 2), new ItemStack(Item.field_77737_bm), 2.5f);
        TileEntityGrinder.addRecipe(new ItemStack(Item.field_82799_bQ, 1, 3), new ItemStack(Item.field_77737_bm), 3.5f);
        TileEntityGrinder.addRecipe(new ItemStack(Item.field_82799_bQ, 1, 4), new ItemStack(Item.field_77677_M), 1.5f);
        this.oreRecipe(this.mixer_item, new Object[]{" X ", " M ", "LUL", Character.valueOf('X'), this.fan, Character.valueOf('M'), this.motor, Character.valueOf('L'), "ingotLead", Character.valueOf('U'), Item.field_77721_bz});
        FurnaceRecipes.func_77602_a().addSmelting(this.sludge.field_77779_bT, 0, new ItemStack(Item.field_77757_aI), 0.1f);
        this.oreRecipe(this.crystallizer_item, "-", "S", "U", Character.valueOf('-'), Item.field_77669_D, Character.valueOf('S'), Item.field_77683_K, Character.valueOf('U'), Item.field_77721_bz);
        ItemStack lime = new ItemStack(Item.field_77756_aW, 1, 10);
        TileEntityCrystallizer.addRecipe(lime, new ItemStack(Item.field_77761_aM), 1.0f, new ItemStack(Item.field_77771_aG));
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_72012_bb), new ItemStack((Item)this.nether_powder, 1), 1.0f);
        if (FzConfig.enable_dimension_slice) {
            this.shapelessRecipe(new ItemStack((Item)this.rocket_fuel, 9), new Object[]{this.nether_powder, this.nether_powder, this.nether_powder, this.nether_powder, Item.field_77811_bE, this.nether_powder, this.nether_powder, this.nether_powder, this.nether_powder});
            this.recipe(new ItemStack((Item)this.rocket_engine), new Object[]{"#F#", "#I#", "I I", Character.valueOf('#'), Block.field_72083_ai, Character.valueOf('F'), this.rocket_fuel, Character.valueOf('I'), Item.field_77703_o});
        }
        this.makeServoRecipes();
        this.oreRecipe(this.empty_socket_item, "#", "-", "#", Character.valueOf('#'), Block.field_72002_bp, Character.valueOf('-'), "slabWood");
        this.oreRecipe(FactoryType.SOCKET_LACERATOR.asSocketItem(), new Object[]{"*", "M", Character.valueOf('*'), this.diamond_cutting_head, Character.valueOf('M'), this.motor});
        this.oreRecipe(FactoryType.SOCKET_SHIFTER.asSocketItem(), new Object[]{"V", "@", "D", Character.valueOf('V'), Block.field_94340_cs, Character.valueOf('@'), this.logicMatrixController, Character.valueOf('D'), Block.field_96469_cy});
        this.oreRecipe(this.socket_robot_hand, new Object[]{"+*P", "+@+", "P*+", Character.valueOf('+'), this.servorail_item, Character.valueOf('*'), this.dark_iron_sprocket, Character.valueOf('@'), this.logicMatrixController, Character.valueOf('P'), Block.field_71963_Z});
        this.oreRecipe(new ItemStack((Item)this.instruction_plate, 5), new Object[]{"I ", "I>", "I ", Character.valueOf('I'), this.dark_iron, Character.valueOf('>'), this.logicMatrixProgrammer});
        this.oreRecipe(new ItemStack((Item)this.servo_rail_comment_editor), new Object[]{"#", "T", Character.valueOf('#'), this.instruction_plate, Character.valueOf('T'), Item.field_77792_au});
    }

    private void makeServoRecipes() {
        ItemStack rails = this.servorail_item.func_77946_l();
        rails.field_77994_a = 8;
        this.oreRecipe(rails, new Object[]{"LDL", Character.valueOf('D'), this.dark_iron, Character.valueOf('L'), "ingotLead"});
        ItemStack two_sprockets = this.dark_iron_sprocket.func_77946_l();
        two_sprockets.field_77994_a = 2;
        this.oreRecipe(two_sprockets, new Object[]{" D ", "DSD", " D ", Character.valueOf('D'), this.dark_iron, Character.valueOf('S'), "ingotSilver"});
        this.batteryRecipe(this.servo_motor, new Object[]{"qCL", "SIB", "rCL", Character.valueOf('q'), Item.field_94583_ca, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('S'), this.dark_iron_sprocket, Character.valueOf('C'), this.insulated_coil, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('B'), this.battery, Character.valueOf('L'), "ingotLead"});
        this.oreRecipe(new ItemStack((Item)this.servo_placer), new Object[]{"M#P", " SC", "M#P", Character.valueOf('M'), this.servo_motor, Character.valueOf('#'), this.logicMatrix, Character.valueOf('P'), this.logicMatrixProgrammer, Character.valueOf('S'), this.empty_socket_item, Character.valueOf('C'), Block.field_72077_au});
        ServoComponent.setupRecipes();
        this.oreRecipe(this.parasieve_item, new Object[]{"C#C", "ImI", "CvC", Character.valueOf('C'), Block.field_71978_w, Character.valueOf('#'), Block.field_72002_bp, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('m'), this.logicMatrixIdentifier, Character.valueOf('v'), Block.field_96469_cy});
    }

    public void setToolEffectiveness() {
        for (String tool : new String[]{"pickaxe", "axe", "shovel"}) {
            MinecraftForge.removeBlockEffectiveness((Block)this.factory_block, (String)tool);
            MinecraftForge.removeBlockEffectiveness((Block)this.resource_block, (String)tool);
        }
        BlockClass.DarkIron.harvest("pickaxe", 2);
        BlockClass.Barrel.harvest("axe", 1);
        BlockClass.Machine.harvest("pickaxe", 1);
        BlockClass.MachineLightable.harvest("pickaxe", 1);
        BlockClass.MachineDynamicLightable.harvest("pickaxe", 1);
        BlockClass.Socket.harvest("axe", 1);
        BlockClass.Socket.harvest("pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel((Block)this.resource_block, (String)"pickaxe", (int)2);
        MinecraftForge.setBlockHarvestLevel((Block)this.dark_iron_ore, (String)"pickaxe", (int)2);
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        TileEntityWrathLamp.handleAirUpdates();
        TileEntityWrathFire.updateCount = 0;
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        this.worldgenManager.tickRetrogenQueue();
    }

    public EnumSet<TickType> ticks() {
        return this.serverTicks;
    }

    public String getLabel() {
        return "FZ_registry";
    }

    @ForgeSubscribe
    public boolean onItemPickup(EntityItemPickupEvent event) {
        EntityPlayer player = event.entityPlayer;
        EntityItem item = event.item;
        if (item == null) {
            return true;
        }
        ItemStack is = item.func_92059_d();
        if (is == null || is.field_77994_a == 0) {
            return true;
        }
        if (player.field_70128_L) {
            return true;
        }
        InventoryPlayer inv = player.field_71071_by;
        int remaining_size = is.field_77994_a;
        int free_slots = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            int free;
            ItemStack here = inv.func_70301_a(i);
            if (here == null) {
                ++free_slots;
                continue;
            }
            if (FzUtil.couldMerge(is, here) && (remaining_size -= (free = here.func_77976_d() - here.field_77994_a)) <= 0) break;
        }
        if (remaining_size > 0) {
            ArrayList<ItemStack> bags = new ArrayList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack here = inv.func_70301_a(i);
                if (here == null || here.func_77973_b() != this.bag_of_holding) continue;
                bags.add(here);
            }
            boolean success = false;
            for (ItemStack bag : bags) {
                if (is.field_77994_a < 0) break;
                success = this.bag_of_holding.insertItem(bag, is);
            }
            if (success) {
                Sound.bagSlurp.playAt((Entity)player);
            }
        }
        Core.proxy.pokePocketCrafting();
        return true;
    }

    public void onCrafting(EntityPlayer player, ItemStack stack, IInventory craftMatrix) {
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            Item item;
            ItemStack here = craftMatrix.func_70301_a(i);
            if (here == null || !((item = here.func_77973_b()) instanceof IActOnCraft)) continue;
            ((IActOnCraft)item).onCraft(here, craftMatrix, i, stack, player);
        }
    }

    public void onSmelting(EntityPlayer player, ItemStack item) {
    }

    public void sendIMC() {
        for (String string : new String[]{"factorization crystallizer recipes@fz.crystallizing", "factorization grinder recipes@fz.grinding", "factorization mixer recipes@fz.mixing", "factorization slag furnace recipes@fz.slagging"}) {
            FMLInterModComms.sendRuntimeMessage((Object)Core.instance, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("Factorization@" + string));
        }
        for (ItemOreProcessing.OreType oreType : ItemOreProcessing.OreType.values()) {
            if (!oreType.enabled) continue;
            FMLInterModComms.sendMessage((String)"Thaumcraft", (String)"smeltBonusExclude", (ItemStack)new ItemStack((Item)this.ore_crystal, 1, oreType.ID));
        }
    }

    public void addOtherRecipes() {
        ArrayList<ItemStack> theLogs = new ArrayList<ItemStack>();
        for (ItemStack log : OreDictionary.getOres((String)"logWood")) {
            if (log.field_77993_c == Block.field_71951_J.field_71990_ca) continue;
            if (log.func_77960_j() == Short.MAX_VALUE && log.field_77993_c < Block.field_71973_m.length) {
                Block b = Block.field_71973_m[log.field_77993_c];
                if (b == null) continue;
                for (int md = 0; md < 16; ++md) {
                    ItemStack is = log.func_77946_l();
                    is.func_77964_b(md);
                    is.field_77994_a = 1;
                    theLogs.add(is);
                }
            }
            theLogs.add(log);
        }
        for (ItemStack log : theLogs) {
            String odType;
            ItemStack slab;
            List<ItemStack> planks = FzUtil.craft1x1(null, true, (log = log.func_77946_l()).func_77946_l());
            if (planks == null || planks.size() != 1) continue;
            ItemStack plank = planks.get(0).func_77946_l();
            plank.field_77994_a = 1;
            List<ItemStack> slabs = FzUtil.craft3x3(null, true, true, plank.func_77946_l(), plank.func_77946_l(), plank.func_77946_l(), null, null, null, null, null, null);
            if (slabs.size() != 1 || !FzUtil.craft_succeeded) {
                slab = plank;
                odType = "plankWood";
            } else {
                slab = slabs.get(0);
                odType = "slabWood";
            }
            if (slab.field_77993_c == Block.field_72092_bO.field_71990_ca && plank.field_77993_c != Block.field_71988_x.field_71990_ca) {
                slab = plank;
            }
            TileEntityDayBarrel.makeRecipe(log, slab);
        }
    }
}

