/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.registry.EntityRegistry;
import factorization.shared.Core;
import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class FzConfig {
    public static Configuration config;
    public static int factory_block_id;
    public static int lightair_id;
    public static int resource_id;
    public static int fractured_bedrock_id;
    public static int dark_iron_ore_id;
    public static Pattern routerBan;
    public static boolean render_barrel_item;
    public static boolean render_barrel_text;
    public static boolean render_barrel_use_displaylists;
    public static boolean render_barrel_close;
    public static int entity_relight_task_id;
    public static boolean gen_silver_ore;
    public static boolean gen_dark_iron_ore;
    public static boolean gen_broken_bedrock;
    public static int silver_ore_node_new_size;
    public static boolean enable_dimension_slice;
    public static int dimension_slice_dimid;
    public static int force_max_entity_radius;
    public static boolean spread_wrathfire;
    public static boolean pocket_craft_anywhere;
    public static boolean bag_swap_anywhere;
    public static String pocketActions;
    public static boolean renderTEs;
    public static boolean renderAO;
    public static boolean add_branding;
    public static boolean debug_light_air;
    public static boolean dimension_slice_allow_smooth;
    public static boolean serverside_translate;
    public static boolean boilers_suck_water;
    public static double steam_output_adjust;
    public static boolean enable_cheat_commands;
    public static boolean enable_sketchy_client_commands;
    public static int tps_reporting_interval;
    public static boolean use_tps_reports;
    public static float lowest_dilation;
    public static boolean lagssie_watcher;
    public static double lagssie_interval;
    public static int max_rocket_base_size;
    public static int max_rocket_height;
    public static boolean stretchy_clay;
    public static boolean equal_opportunities_for_mobs;
    public static boolean fix_nether_fog;
    public static boolean fix_middle_click;
    public static boolean embarken_wood;
    public static boolean invasiveCharge;
    public static boolean enable_solar_steam;
    public static boolean large_servo_instructions;
    public static boolean enable_retrogen;
    public static String retrogen_key;
    public static boolean retrogen_silver;
    public static boolean retrogen_dark_iron;

    private int getBlockConfig(String name2, int defaultId, String comment) {
        Property prop = null;
        if (Core.dev_environ) {
            return defaultId;
        }
        prop = config.getBlock(name2, defaultId);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getInt(defaultId);
    }

    private int getIntConfig(String name2, String category, int defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getInt(defaultValue);
    }

    private boolean getBoolConfig(String name2, String category, boolean defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getBoolean(defaultValue);
    }

    private double getDoubleConfig(String name2, String category, double defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getDouble(defaultValue);
    }

    private String getStringConfig(String name2, String category, String defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getString();
    }

    public void loadConfig(File configFile) {
        Object p;
        config = new Configuration(configFile);
        try {
            config.load();
        }
        catch (Exception e) {
            Core.logWarning("Error loading config: %s", e.toString());
            e.printStackTrace();
        }
        factory_block_id = this.getBlockConfig("factoryBlockId", factory_block_id, "Factorization TileEntities");
        lightair_id = this.getBlockConfig("lightAirBlockId", lightair_id, "WrathFire and invisible lamp-air made by WrathLamps");
        resource_id = this.getBlockConfig("resourceBlockId", resource_id, "Ores and metal blocks mostly");
        dark_iron_ore_id = this.getBlockConfig("darkIronOre", dark_iron_ore_id, null);
        fractured_bedrock_id = this.getBlockConfig("fracturedBedrockBlockId", fractured_bedrock_id, null);
        debug_light_air = this.getBoolConfig("debugLightAir", "client", debug_light_air, "Show invisible lamp-air");
        pocket_craft_anywhere = this.getBoolConfig("anywherePocketCraft", "client", pocket_craft_anywhere, "Lets you open the pocket crafting table from GUIs");
        bag_swap_anywhere = this.getBoolConfig("anywhereBagSwap", "client", bag_swap_anywhere, "Lets you use the bag from GUIs");
        render_barrel_item = this.getBoolConfig("renderBarrelItem", "client", render_barrel_item, null);
        render_barrel_item = this.getBoolConfig("renderBarrelText", "client", render_barrel_text, null);
        render_barrel_close = this.getBoolConfig("renderBarrelClose", "client", render_barrel_close, "If true, render barrel info only when nearby");
        renderTEs = this.getBoolConfig("renderOtherTileEntities", "client", renderTEs, "If false, most TEs won't draw, making everything look broken but possibly improving FPS");
        renderAO = this.getBoolConfig("renderAmbientOcclusion", "client", renderAO, "If false, never use smooth lighting for drawing sculptures");
        String attempt = this.getStringConfig("pocketCraftingActionKeys", "client", pocketActions, "3 keys for: removing (x), cycling (c), balancing (b)");
        if (attempt.length() == pocketActions.length()) {
            pocketActions = attempt;
        } else {
            p = config.get("pocketCraftingActionKeys", "client", pocketActions);
            p.set(pocketActions);
            ((Property)p).comment = pocketActions.length() + " keys for: removing (x), cycling (c), balancing (b), filling (f)";
        }
        enable_sketchy_client_commands = this.getBoolConfig("allowUnpureCommands", "client", enable_sketchy_client_commands, null);
        use_tps_reports = this.getBoolConfig("useTimeDilation", "client", use_tps_reports, "If this is enabled, the client will run as slowly as the server does. This avoids visual artifacts on laggy servers.");
        lowest_dilation = (float)this.getDoubleConfig("lowestTimeDilation", "client", lowest_dilation, "Sets a lower bound on time dilation. Between 0 and 1.");
        lowest_dilation = Math.max(1.0f, Math.min(0.0f, lowest_dilation));
        lagssie_watcher = this.getBoolConfig("enableLagWatchDog", "client", lagssie_watcher, "If true, enables a thread that dumps a stack trace of Minecraft if it is paused for longer than lagWatchDogInterval");
        lagssie_interval = this.getDoubleConfig("lagWatchDogInterval", "client", lagssie_interval, "If the game is stuck for longer than this amount of time (in seconds), dump a stacktrace of what it is doing.");
        fix_nether_fog = this.getBoolConfig("fixNetherFog", "client", fix_nether_fog, "Remove nether fog at short render distances");
        fix_middle_click = this.getBoolConfig("fixPickBlock", "client", fix_middle_click, "Make middle clicking more useful");
        large_servo_instructions = this.getBoolConfig("largeServoInstructions", "client", large_servo_instructions, "Render servo instructions extra-large. This can also be toggled on and off using '/f servoInstructionSize'.");
        add_branding = this.getBoolConfig("addBranding", "general", add_branding, null);
        gen_silver_ore = this.getBoolConfig("generateSilverOre", "general", gen_silver_ore, "Set to false to disable silver ore generation");
        int config_silver_size = this.getIntConfig("silverOreNodeNewSize", "general", silver_ore_node_new_size, "The size of silver ore nodes. Between 5 & 35. Default is " + silver_ore_node_new_size);
        silver_ore_node_new_size = Math.max(5, Math.min(config_silver_size, 35));
        gen_dark_iron_ore = this.getBoolConfig("generateDarkIronOre", "general", gen_dark_iron_ore, "Set to false to disable dark iron ore generation");
        gen_broken_bedrock = this.getBoolConfig("generateBrokenBedrock", "general", gen_broken_bedrock, "Set to false to disable broken bedrock spawning around dark iron ore");
        if (fractured_bedrock_id <= 0) {
            gen_broken_bedrock = false;
        }
        enable_retrogen = this.getBoolConfig("enableRetrogen", "retrogen", enable_retrogen, null);
        retrogen_key = this.getStringConfig("retrogenKey", "retrogen", retrogen_key, null);
        retrogen_silver = this.getBoolConfig("retrogenSilver", "retrogen", retrogen_silver, null);
        retrogen_dark_iron = this.getBoolConfig("retrogenDarkIron", "retrogen", retrogen_dark_iron, null);
        enable_dimension_slice = this.getBoolConfig("enableDimensionSlices", "dimensionSlices", enable_dimension_slice, "work in progress; may be unstable");
        spread_wrathfire = this.getBoolConfig("spreadWrathFire", "server", spread_wrathfire, null);
        p = this.getStringConfig("bannedRouterInventoriesRegex", "server", "", "This is a Java Regex to blacklist router access");
        if (p != null && ((String)p).length() != 0) {
            try {
                routerBan = Pattern.compile((String)p);
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace();
                Core.logWarning("Factorization: config has invalid Java Regex for banned_router_inventories: " + (String)p, new Object[0]);
            }
        }
        if ((entity_relight_task_id = config.get("general", "entityRelightTask", -1).getInt()) == -1) {
            entity_relight_task_id = EntityRegistry.findGlobalUniqueEntityId();
            Property prop = config.get("general", "entityRelightTask", entity_relight_task_id);
            prop.set(entity_relight_task_id);
        }
        serverside_translate = this.getBoolConfig("serversideTranslate", "server", serverside_translate, "If false, notifications will be translated by the client");
        boilers_suck_water = this.getBoolConfig("boilersSuckWater", "server", boilers_suck_water, "If false, water must be piped in");
        steam_output_adjust = this.getDoubleConfig("steamOutputAdjustment", "server", steam_output_adjust, "Scale how much steam is produced by the solar boiler");
        stretchy_clay = this.getBoolConfig("stretchyClay", "server", stretchy_clay, "If true, maximum clay lump volume is 1 m\u00b3 instead of (1 m\u00b3)/4");
        tps_reporting_interval = this.getIntConfig("tpsReportInterval", "server", tps_reporting_interval, "How many ticks the server will wait before sending out TPS reports. 20 ticks = 1 second, unless it's lagging.");
        equal_opportunities_for_mobs = this.getBoolConfig("equalOpportunitiesForMobs", "server", equal_opportunities_for_mobs, "Causes some mobs to rarely spawn wearing your armor");
        embarken_wood = this.getBoolConfig("barkRecipes", "server", embarken_wood, "Adds recipes for bark variants of logs");
        enable_solar_steam = this.getBoolConfig("enableSolarSteam", "server", enable_solar_steam, "Set to false to disable the crafting recipe for solar2steam machines");
        config.save();
    }

    static {
        factory_block_id = 1000;
        lightair_id = 1001;
        resource_id = 1002;
        fractured_bedrock_id = 1003;
        dark_iron_ore_id = 1004;
        render_barrel_item = true;
        render_barrel_text = true;
        render_barrel_use_displaylists = true;
        render_barrel_close = false;
        entity_relight_task_id = -1;
        gen_silver_ore = true;
        gen_dark_iron_ore = true;
        gen_broken_bedrock = true;
        silver_ore_node_new_size = 18;
        enable_dimension_slice = Core.dev_environ;
        dimension_slice_dimid = -7;
        force_max_entity_radius = -1;
        spread_wrathfire = true;
        pocket_craft_anywhere = true;
        bag_swap_anywhere = true;
        pocketActions = "xcbf";
        renderTEs = true;
        renderAO = true;
        add_branding = false;
        debug_light_air = false;
        dimension_slice_allow_smooth = true;
        serverside_translate = true;
        boilers_suck_water = true;
        steam_output_adjust = 1.0;
        enable_cheat_commands = Core.dev_environ;
        enable_sketchy_client_commands = true;
        tps_reporting_interval = 20;
        use_tps_reports = true;
        lowest_dilation = 0.6f;
        lagssie_watcher = false;
        lagssie_interval = 0.25;
        max_rocket_base_size = 400;
        max_rocket_height = 64;
        stretchy_clay = true;
        equal_opportunities_for_mobs = true;
        fix_nether_fog = true;
        fix_middle_click = true;
        embarken_wood = true;
        invasiveCharge = false;
        enable_solar_steam = true;
        large_servo_instructions = false;
        enable_retrogen = false;
        retrogen_key = "DEFAULT";
        retrogen_silver = false;
        retrogen_dark_iron = false;
    }
}

