/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.api.Coord;
import factorization.api.IMeterInfo;
import factorization.api.IReflectionTarget;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.shared.BlockClass;
import factorization.shared.FzUtil;
import factorization.shared.TileEntityCommon;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySolarBoiler
extends TileEntityCommon
implements IReflectionTarget,
IFluidHandler,
IMeterInfo {
    public static Fluid steam;
    public static FluidStack water_stack;
    public static FluidStack steam_stack;
    FluidTank waterTank = new FluidTank(water_stack.copy(), 8000);
    FluidTank steamTank = new FluidTank(steam_stack.copy(), 8000);
    int reflector_count = 0;

    public static void setupSteam() {
        if (water_stack == null) {
            water_stack = new FluidStack(FluidRegistry.WATER, 0);
            steam_stack = FluidRegistry.getFluidStack((String)"steam", (int)0);
            steam = steam_stack.getFluid();
        }
    }

    public TileEntitySolarBoiler() {
        this.waterTank.getFluid().amount = 0;
        this.steamTank.getFluid().amount = 0;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOLARBOILER;
    }

    @Override
    public Icon getIcon(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return BlockIcons.boiler_top;
            }
        }
        return BlockIcons.boiler_side;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        FzUtil.writeTank(tag, this.waterTank, "water");
        FzUtil.writeTank(tag, this.steamTank, "steam");
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        FzUtil.readTank(tag, this.waterTank, "water");
        FzUtil.readTank(tag, this.steamTank, "steam");
        this.sanitize();
    }

    private FluidTank getTank(ForgeDirection from) {
        if (from == ForgeDirection.UP) {
            return this.steamTank;
        }
        return this.waterTank;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.isFluidEqual(water_stack)) {
            return this.waterTank.fill(resource, doFill);
        }
        if (resource.isFluidEqual(steam_stack)) {
            return this.steamTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getTank(from).drain(maxDrain, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.UP) {
            return false;
        }
        return fluid == null || fluid.getID() == TileEntitySolarBoiler.water_stack.fluidID;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidTank tank = this.getTank(from);
        if (resource == null || from == ForgeDirection.UP || tank.getFluid().fluidID != resource.fluidID) {
            return null;
        }
        return tank.drain(tank.getCapacity(), doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getTank(from).getInfo()};
    }

    @Override
    public void addReflector(int strength) {
        this.reflector_count = Math.max(0, this.reflector_count + strength);
    }

    int getWater() {
        return this.waterTank.getFluid().amount;
    }

    int getSteam() {
        return this.steamTank.getFluid().amount;
    }

    int getHeat() {
        return Math.max(this.reflector_count - 3, 0);
    }

    void sanitize() {
        if (this.waterTank.getFluid() == null) {
            this.waterTank.setFluid(water_stack.copy());
        }
        if (this.steamTank.getFluid() == null) {
            this.steamTank.setFluid(steam_stack.copy());
        }
    }

    public void func_70316_g() {
        boolean random;
        Coord above;
        IFluidHandler tc;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.sanitize();
        FluidStack water = this.waterTank.getFluid();
        FluidStack steam = this.steamTank.getFluid();
        Coord here = this.getCoord();
        long seed = (long)here.seed() + this.field_70331_k.func_82737_E();
        if ((steam.amount * 2 > this.steamTank.getCapacity() || seed % 20L == 0L) && (tc = (above = here.add(0, 1, 0)).getTE(IFluidHandler.class)) != null) {
            FluidStack sending_steam = steam.copy();
            sending_steam.amount = Math.min(sending_steam.amount, 1000);
            steam.amount -= tc.fill(ForgeDirection.DOWN, steam.copy(), true);
            steam.amount = Math.max(0, steam.amount);
        }
        boolean bl = random = seed % 40L == 0L;
        if (water.amount <= 1000 || random && water.amount < this.waterTank.getCapacity() - 1000) {
            Coord below = here.add(0, -1, 0);
            IFluidHandler tc2 = below.getTE(IFluidHandler.class);
            boolean water_below = below.is((Block)Block.field_71942_A) || below.is(Block.field_71943_B);
            if ((water_below &= !here.isPowered()) && FzConfig.boilers_suck_water) {
                if (below.getMd() == 0) {
                    below.setId(0);
                    water.amount += 1000;
                    water.amount = Math.min(water.amount, this.waterTank.getCapacity());
                }
            } else if (tc2 != null) {
                ForgeDirection dir = ForgeDirection.UP;
                if (below.getTE(TileEntitySolarBoiler.class) != null) {
                    dir = ForgeDirection.DOWN;
                }
                int free = Math.max(0, this.waterTank.getCapacity() - water.amount);
                FluidStack avail = tc2.drain(dir, free = Math.min(100, free), false);
                if (avail != null && avail.isFluidEqual(water_stack)) {
                    water.amount += tc2.drain((ForgeDirection)dir, (int)free, (boolean)true).amount;
                }
            }
            return;
        }
        int time_scale = 1;
        if (this.getHeat() <= 0) {
            return;
        }
        this.applyHeat(this.getHeat() * time_scale);
    }

    public void applyHeat(int heat) {
        int water_to_steam;
        this.sanitize();
        FluidStack water = this.waterTank.getFluid();
        FluidStack steam = this.steamTank.getFluid();
        if (steam.amount >= this.steamTank.getCapacity()) {
            return;
        }
        int toBoil = Math.min(heat, water.amount);
        toBoil = Math.min(this.steamTank.getCapacity() - steam.amount, toBoil);
        int water_to_remove = Math.max(toBoil / (water_to_steam = 160), 1);
        if (water_to_remove > water.amount) {
            return;
        }
        water.amount -= water_to_remove;
        steam.amount += (int)((double)toBoil * FzConfig.steam_output_adjust);
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        Coord here = this.getCoord();
        FzUtil.spill(here, this.waterTank.getFluid());
        FzUtil.spill(here, this.steamTank.getFluid());
    }

    @Override
    public String getInfo() {
        this.sanitize();
        float w = (float)(this.waterTank.getFluid().amount * 16) / (float)this.waterTank.getCapacity();
        float s = (float)(this.steamTank.getFluid().amount * 16) / (float)this.steamTank.getCapacity();
        return "Power: " + this.reflector_count + "\nSteam: " + String.format("%.1f", Float.valueOf(s)) + "\nWater: " + String.format("%.1f", Float.valueOf(w));
    }

    static {
        water_stack = null;
        steam_stack = null;
    }
}

