/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataOutNBT;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.charge.TileEntitySolarBoiler;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.notify.Notify;
import factorization.shared.BlockClass;
import factorization.shared.FzUtil;
import factorization.shared.Sound;
import factorization.shared.TileEntityFactorization;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityCaliometricBurner
extends TileEntityFactorization
implements IDataSerializable {
    ItemStack stomache;
    int foodQuality = 0;
    int ticksUntilNextDigestion = 0;
    private static final int[] nomslots = new int[]{0};
    private static final int[] emptySlots = new int[0];

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.CALIOMETRIC_BURNER;
    }

    public String func_70303_b() {
        return "Caliometric Burner";
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.stomache = data.as(Share.PRIVATE, prefix + "stomache").putItemStack(this.stomache);
        this.foodQuality = data.as(Share.PRIVATE, prefix + "food").putInt(this.foodQuality);
        this.ticksUntilNextDigestion = data.as(Share.PRIVATE, prefix + "digest").putInt(this.ticksUntilNextDigestion);
        return this;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        try {
            new DataOutNBT(tag).as(Share.PRIVATE, "").put(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        try {
            new DataInNBT(tag).as(Share.PRIVATE, "").put(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        if (i == 0) {
            return this.stomache;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            this.stomache = itemstack;
        }
    }

    @Override
    public int func_70297_j_() {
        return 4;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return this.getFoodValue(itemstack) > 0;
    }

    public int[] func_94128_d(int side) {
        if (ForgeDirection.getOrientation((int)side).offsetY != 0) {
            return emptySlots;
        }
        return nomslots;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        if (dir.offsetY != 0) {
            return BlockIcons.caliometric_top;
        }
        return BlockIcons.caliometric_side;
    }

    @Override
    protected void doLogic() {
        this.needLogic();
        Coord here = this.getCoord();
        if (this.ticksUntilNextDigestion > 0 && this.foodQuality > 0) {
            for (Coord c : here.getRandomNeighborsAdjacent()) {
                TileEntitySolarBoiler boiler = c.getTE(TileEntitySolarBoiler.class);
                if (boiler == null) continue;
                boiler.applyHeat(this.foodQuality);
                break;
            }
        }
        --this.ticksUntilNextDigestion;
        if (this.ticksUntilNextDigestion <= 0 && !here.isPowered()) {
            this.foodQuality = this.consumeFood();
        }
    }

    @Override
    protected int getLogicSpeed() {
        return 1;
    }

    int consumeFood() {
        this.stomache = FzUtil.normalize(this.stomache);
        if (this.stomache == null) {
            return 0;
        }
        int noms = this.getFoodValue(this.stomache);
        this.stomache = FzUtil.normalDecr(this.stomache);
        this.func_70296_d();
        Sound.caliometricDigest.playAt(this);
        this.ticksUntilNextDigestion = 200 * noms;
        return 8;
    }

    int getFoodValue(ItemStack is) {
        if (is == null) {
            return 0;
        }
        Item it = is.func_77973_b();
        int heal = 0;
        double sat = 0.0;
        if (it instanceof ItemFood) {
            ItemFood nom = (ItemFood)it;
            heal = nom.func_77847_f();
            sat = nom.func_77846_g();
        } else if (it == Item.field_77746_aZ) {
            heal = 12;
            sat = 0.1f;
        }
        heal = (int)((double)heal + Math.min(0.0, (double)(heal * 2) * sat));
        int r = (int)((float)heal * ((float)heal / 4.0f));
        return Math.max(heal, r);
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        if (this.field_70331_k.field_72995_K) {
            return true;
        }
        ItemStack is = entityplayer.func_70694_bm();
        if (is == null) {
            this.info(entityplayer);
            return false;
        }
        is = FzUtil.openInventory((IInventory)this, ForgeDirection.NORTH).push(is);
        entityplayer.func_70062_b(0, is);
        this.info(entityplayer);
        this.func_70296_d();
        return true;
    }

    void info(EntityPlayer entityplayer) {
        String append = "";
        if (this.ticksUntilNextDigestion > 0) {
            int n = this.ticksUntilNextDigestion / 20;
            int min = n / 60;
            int s = n % 60;
            append = "\n" + min + ":";
            if (s < 10) {
                append = append + "0";
            }
            append = append + s;
        }
        if (this.stomache == null || this.stomache.field_77994_a == 0) {
            Notify.send(entityplayer, (Object)this, "Empty" + append, new String[0]);
            return;
        }
        Notify.withItem(this.stomache);
        Notify.send(entityplayer, (Object)this, this.stomache.field_77994_a + " {ITEM_NAME}" + append, new String[0]);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return false;
    }
}

