/*
 * Decompiled with CFR 0.152.
 */
package factorization.charge;

import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.charge.TileEntityMirror;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.ResourceType;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FactorizationBlockRender;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class BlockRenderMirrorStand
extends FactorizationBlockRender {
    private static final int[] frontFace = new int[]{1};
    private static final int[] backFace = new int[]{0};
    private static final int[] sideFace = new int[]{2, 3, 4, 5};
    private static Quaternion mirrorTilt = Quaternion.getRotationQuaternionRadians(Math.toRadians(-45.0), 1.0, 0.0, 0.0);

    @Override
    public void render(RenderBlocks rb) {
        TileEntityMirror tem;
        if (!this.world_mode) {
            return;
        }
        Core.profileStart("mirror");
        float height = 0.453125f;
        float radius = 0.0625f;
        float c = 0.5f;
        Icon silver = Core.registry.resource_block.func_71858_a(0, ResourceType.SILVERBLOCK.md);
        BlockRenderHelper block = Core.registry.blockRender;
        block.useTexture(silver);
        block.setTexture(0, null);
        block.func_71905_a(c - radius, 0.0f, c - radius, c + radius, height, c + radius);
        block.render(rb, this.x, this.y, this.z);
        float trim = 0.1875f;
        float trim_height = 0.125f;
        this.renderPart(rb, silver, trim, 0.0f, trim, 1.0f - trim, trim_height, 1.0f - trim);
        block.setBlockBoundsOffset(0.125f, 0.46875f, 0.125f);
        Icon side = BlockIcons.mirror_side;
        Icon face = BlockIcons.mirror_front;
        block.useTextures(face, face, side, side, side, side);
        block.begin();
        Coord here = this.getCoord();
        if (this.world_mode && (tem = here.getTE(TileEntityMirror.class)) != null && tem.target_rotation >= 0) {
            block.translate(-0.5f, 0.0f, 0.0f);
            Quaternion trans = Quaternion.getRotationQuaternionRadians(Math.toRadians(tem.target_rotation - 90), ForgeDirection.UP);
            trans.incrMultiply(mirrorTilt);
            block.rotate(trans);
            block.translate(0.5f, -0.2f, 0.5f);
        }
        if (!this.world_mode) {
            Tessellator.field_78398_a.func_78382_b();
        }
        block.renderRotated(Tessellator.field_78398_a, here);
        if (!this.world_mode) {
            Tessellator.field_78398_a.func_78381_a();
        }
        Core.profileEnd();
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MIRROR;
    }
}

