/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import cpw.mods.fml.relauncher.Side;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class DataOutPacket
extends DataHelper {
    private final DataOutput dos;
    private final Side side;

    public DataOutPacket(DataOutput dos, Side side) {
        this.dos = dos;
        this.side = side;
    }

    @Override
    protected boolean shouldStore(Share share) {
        return share.is_public;
    }

    @Override
    public boolean isReader() {
        return false;
    }

    @Override
    protected <E> Object putImplementation(E value) throws IOException {
        if (value instanceof Boolean) {
            this.dos.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.dos.writeByte(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.dos.writeShort(((Short)value).shortValue());
        } else if (value instanceof Integer) {
            this.dos.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.dos.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.dos.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.dos.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.dos.writeUTF((String)value);
        } else if (value instanceof NBTTagCompound) {
            NBTBase.func_74731_a((NBTBase)((NBTBase)value), (DataOutput)this.dos);
        }
        return value;
    }
}

