/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import cpw.mods.fml.relauncher.Side;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class DataInPacket
extends DataHelper {
    private final DataInput dis;
    private final Side side;

    public DataInPacket(DataInput dis, Side side) {
        this.dis = dis;
        this.side = side;
    }

    @Override
    protected boolean shouldStore(Share share) {
        return share.is_public;
    }

    @Override
    public boolean isReader() {
        return true;
    }

    @Override
    protected <E> Object putImplementation(E o) throws IOException {
        if (o instanceof Boolean) {
            return this.dis.readBoolean();
        }
        if (o instanceof Byte) {
            return this.dis.readByte();
        }
        if (o instanceof Short) {
            return this.dis.readShort();
        }
        if (o instanceof Integer) {
            return this.dis.readInt();
        }
        if (o instanceof Long) {
            return this.dis.readLong();
        }
        if (o instanceof Float) {
            return Float.valueOf(this.dis.readFloat());
        }
        if (o instanceof Double) {
            return this.dis.readDouble();
        }
        if (o instanceof String) {
            return this.dis.readUTF();
        }
        if (o instanceof NBTTagCompound) {
            return (NBTTagCompound)NBTBase.func_74739_b((DataInput)this.dis);
        }
        return o;
    }
}

