/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import factorization.api.FzOrientation;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class DataHelper {
    protected String name;
    protected boolean valid;
    private static final Class[] validTypes = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, NBTTagCompound.class, String.class};

    public DataHelper as(Share share, String set_name) {
        this.name = set_name;
        this.valid = this.shouldStore(share);
        return this;
    }

    public DataHelper asSameShare(String set_name) {
        this.name = set_name;
        return this;
    }

    protected abstract boolean shouldStore(Share var1);

    public abstract boolean isReader();

    public boolean isWriter() {
        return !this.isReader();
    }

    public NBTTagCompound getTag() {
        return null;
    }

    public boolean isNBT() {
        return false;
    }

    public <E> E put(E o) throws IOException {
        if (!this.valid) {
            return o;
        }
        if (o instanceof IDataSerializable) {
            return (E)((IDataSerializable)o).serialize(this.name, this);
        }
        if (o instanceof Enum) {
            Enum value = (Enum)o;
            int i = value.ordinal();
            i = this.put(i);
            if (this.isWriter()) {
                return (E)value;
            }
            return (E)((Enum[])value.getClass().getEnumConstants())[i];
        }
        if (o instanceof ItemStack) {
            ItemStack value = (ItemStack)o;
            NBTTagCompound writtenTag = value.func_77955_b(new NBTTagCompound());
            if (this.isReader()) {
                return (E)ItemStack.func_77949_a((NBTTagCompound)this.put(writtenTag));
            }
            this.put(writtenTag);
            return o;
        }
        return (E)this.putImplementation(o);
    }

    protected abstract <E> Object putImplementation(E var1) throws IOException;

    public final boolean putBoolean(boolean value) throws IOException {
        return this.put(value);
    }

    public final byte putByte(byte value) throws IOException {
        return this.put(value);
    }

    public final short putShort(short value) throws IOException {
        return this.put(value);
    }

    public final int putInt(int value) throws IOException {
        return this.put(value);
    }

    public final long putLong(long value) throws IOException {
        return this.put(value);
    }

    public final float putFloat(float value) throws IOException {
        return this.put(Float.valueOf(value)).floatValue();
    }

    public final double putDouble(double value) throws IOException {
        return this.put(value);
    }

    public final String putString(String value) throws IOException {
        return this.put(value);
    }

    public final FzOrientation putFzOrientation(FzOrientation value) throws IOException {
        return this.put(value);
    }

    public final ItemStack putItemStack(ItemStack value) throws IOException {
        if (this.isReader() && value == null) {
            value = new ItemStack(0, 0, 0);
        }
        return this.put(value);
    }

    public final ArrayList<ItemStack> putItemArray(ArrayList<ItemStack> value) throws IOException {
        String prefix = this.name;
        int len = this.asSameShare(prefix + "_len").putInt(value.size());
        if (this.isReader()) {
            value.clear();
            value.ensureCapacity(len);
            for (int i = 0; i < len; ++i) {
                value.add(this.asSameShare(prefix + "_" + i).putItemStack(null));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                this.asSameShare(prefix + "_" + i).putItemStack(value.get(i));
            }
        }
        return value;
    }

    public final NBTTagCompound putTag(NBTTagCompound value) throws IOException {
        return this.put(value);
    }

    public final <E extends Enum> E putEnum(E value) throws IOException {
        return this.put(value);
    }

    public final Object putUntypedOject(Object value) throws IOException {
        if (!this.valid) {
            return value;
        }
        String orig_name = this.name;
        if (this.isReader()) {
            byte typeIndex = this.asSameShare(orig_name + ".type").putByte((byte)-1);
            this.asSameShare(orig_name);
            if (typeIndex < 0 || typeIndex > validTypes.length) {
                return value;
            }
            Class type = validTypes[typeIndex];
            if (value != null && value.getClass() == type) {
                return this.put(value);
            }
            if (type == Boolean.class) {
                value = false;
            } else if (type == Short.class) {
                value = (short)0;
            } else if (type == Integer.class) {
                value = 0;
            } else if (type == Long.class) {
                value = 0L;
            } else if (type == Float.class) {
                value = Float.valueOf(0.0f);
            } else if (type == Double.class) {
                value = 0.0;
            } else if (type == NBTTagCompound.class) {
                value = new NBTTagCompound();
            } else if (type == String.class) {
                value = "";
            } else {
                return null;
            }
            return this.put(value);
        }
        Class<?> value_type = value.getClass();
        for (byte i = 0; i < validTypes.length; i = (byte)((byte)(i + 1))) {
            Class type = validTypes[i];
            if (value_type != type) continue;
            this.asSameShare(orig_name + ".type").putByte(i);
            this.asSameShare(orig_name);
            this.put(value);
            return value;
        }
        throw new IllegalArgumentException("Don't know how to handle: " + value_type);
    }

    public void log(String message) {
    }

    public boolean hasLegacy(String name2) {
        return false;
    }
}

