/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.core.IC2;
import ic2.core.init.DefaultIds;
import ic2.core.init.InternalName;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public abstract class ItemElectricTool
extends ItemTool
implements IElectricItem,
IBoxable,
IItemHudInfo {
    public int operationEnergyCost;
    public int maxCharge;
    public int transferLimit;
    public int tier;
    public Set<Block> mineableBlocks = new HashSet<Block>();

    public ItemElectricTool(Configuration config, InternalName internalName, EnumToolMaterial toolmaterial, int aOperationEnergyCost) {
        super(IC2.getItemIdFor(config, internalName, DefaultIds.get(internalName)), 0.0f, toolmaterial, new Block[0]);
        this.operationEnergyCost = aOperationEnergyCost;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.func_77655_b(internalName.name());
        this.func_77637_a(IC2.tabIC2);
        GameRegistry.registerItem((Item)this, (String)internalName.name());
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        ElectricItem.manager.use(stack, 0, (EntityLivingBase)player);
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ElectricItem.manager.use(stack, 0, (EntityLivingBase)player);
        return super.func_77659_a(stack, world, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("ic2:" + this.func_77658_a().substring(4));
    }

    public String func_77658_a() {
        return "ic2." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public String func_77628_j(ItemStack itemStack) {
        return StatCollector.func_74838_a((String)this.func_77667_c(itemStack));
    }

    public float getStrVsBlock(ItemStack tool, Block block, int meta) {
        if (!ElectricItem.manager.canUse(tool, this.operationEnergyCost)) {
            return 1.0f;
        }
        if (this.canHarvestBlock(block, tool)) {
            return this.field_77864_a;
        }
        return super.getStrVsBlock(tool, block, meta);
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.mineableBlocks.contains(block);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    @Override
    public int getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean func_77660_a(ItemStack par1ItemStack, World par2World, int par3, int par4, int par5, int par6, EntityLivingBase par7EntityLiving) {
        if (Block.field_71973_m[par3] == null) {
            IC2.log.severe("ItemElectricTool.onBlockDestroyed(): received invalid block id " + par3);
            return false;
        }
        if ((double)Block.field_71973_m[par3].func_71934_m(par2World, par4, par5, par6) != 0.0) {
            if (par7EntityLiving != null) {
                ElectricItem.manager.use(par1ItemStack, this.operationEnergyCost, par7EntityLiving);
            } else {
                ElectricItem.manager.discharge(par1ItemStack, this.operationEnergyCost, this.tier, true, false);
            }
        }
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int i, CreativeTabs tabs, List itemList) {
        itemList.add(this.getItemStack(Integer.MAX_VALUE));
        itemList.add(this.getItemStack(0));
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        info.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.tier);
    }

    @Override
    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(itemStack));
        info.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.tier);
        return info;
    }

    protected ItemStack getItemStack(int charge) {
        ItemStack ret = new ItemStack((Item)this);
        ElectricItem.manager.charge(ret, charge, Integer.MAX_VALUE, true, false);
        return ret;
    }

    protected Item getRefPick() {
        switch (this.field_77862_b) {
            case EMERALD: {
                return Item.field_77674_B;
            }
            case GOLD: {
                return Item.field_77681_I;
            }
            case IRON: {
                return Item.field_77696_g;
            }
            case STONE: {
                return Item.field_77720_x;
            }
            case WOOD: {
                return Item.field_77713_t;
            }
        }
        throw new RuntimeException("unknown material: " + this.field_77862_b);
    }

    protected Item getRefShovel() {
        switch (this.field_77862_b) {
            case EMERALD: {
                return Item.field_77673_A;
            }
            case GOLD: {
                return Item.field_77680_H;
            }
            case IRON: {
                return Item.field_77695_f;
            }
            case STONE: {
                return Item.field_77710_w;
            }
            case WOOD: {
                return Item.field_77714_s;
            }
        }
        throw new RuntimeException("unknown material: " + this.field_77862_b);
    }

    protected Item getRefAxe() {
        switch (this.field_77862_b) {
            case EMERALD: {
                return Item.field_77675_C;
            }
            case GOLD: {
                return Item.field_77682_J;
            }
            case IRON: {
                return Item.field_77708_h;
            }
            case STONE: {
                return Item.field_77719_y;
            }
            case WOOD: {
                return Item.field_77712_u;
            }
        }
        throw new RuntimeException("unknown material: " + this.field_77862_b);
    }

    protected Item getRefSword() {
        switch (this.field_77862_b) {
            case EMERALD: {
                return Item.field_77718_z;
            }
            case GOLD: {
                return Item.field_77672_G;
            }
            case IRON: {
                return Item.field_77716_q;
            }
            case STONE: {
                return Item.field_77711_v;
            }
            case WOOD: {
                return Item.field_77715_r;
            }
        }
        throw new RuntimeException("unknown material: " + this.field_77862_b);
    }
}

