/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.generator.container.ContainerWaterGenerator;
import ic2.core.block.generator.gui.GuiWaterGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityWaterGenerator
extends TileEntityBaseGenerator {
    public static Random randomizer = new Random();
    public int ticker;
    public int water = 0;
    public int microStorage = 0;
    public int maxWater = 2000;
    public final InvSlotConsumableLiquid fuelSlot;

    public TileEntityWaterGenerator() {
        super(2, 4);
        this.production = 2;
        this.ticker = randomizer.nextInt(this.tickRate());
        this.fuelSlot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "fuel", 1, InvSlot.Access.NONE, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain, FluidRegistry.WATER);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateWaterCount();
    }

    @Override
    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return this.fuel * i / this.maxWater;
    }

    @Override
    public boolean gainFuel() {
        if (this.fuel + 500 > this.maxWater) {
            return false;
        }
        if (!this.fuelSlot.isEmpty()) {
            ItemStack liquid = this.fuelSlot.consume(1);
            if (liquid == null) {
                return false;
            }
            this.fuel += 500;
            this.production = liquid.func_77973_b().func_77634_r() ? 1 : 2;
            return true;
        }
        if (this.fuel <= 0) {
            this.flowPower();
            this.production = this.microStorage / 100;
            this.microStorage -= this.production * 100;
            if (this.production > 0) {
                ++this.fuel;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean gainFuelSub(ItemStack stack) {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxWater;
    }

    public void flowPower() {
        if (this.ticker++ % this.tickRate() == 0) {
            this.updateWaterCount();
        }
        this.water = this.water * IC2.energyGeneratorWater / 100;
        if (this.water > 0) {
            this.microStorage += this.water;
        }
    }

    public void updateWaterCount() {
        int count = 0;
        for (int x = this.field_70329_l - 1; x < this.field_70329_l + 2; ++x) {
            for (int y = this.field_70330_m - 1; y < this.field_70330_m + 2; ++y) {
                for (int z = this.field_70327_n - 1; z < this.field_70327_n + 2; ++z) {
                    if (this.field_70331_k.func_72798_a(x, y, z) != Block.field_71942_A.field_71990_ca && this.field_70331_k.func_72798_a(x, y, z) != Block.field_71943_B.field_71990_ca) continue;
                    ++count;
                }
            }
        }
        this.water = count;
    }

    @Override
    public String func_70303_b() {
        return "Water Mill";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiWaterGenerator(new ContainerWaterGenerator(entityPlayer, this));
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/WatermillLoop.ogg";
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerWaterGenerator(entityPlayer, this);
    }
}

