/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.tile.IWrenchable;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.BlockBase;
import ic2.core.block.BlockTextureStitched;
import ic2.core.block.TileEntityBlock;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeDirection;

public abstract class BlockMultiID
extends BlockBase {
    public int renderMask = 63;
    private static final int tesBeforeBreakLimit = 8;
    private static ArrayDeque<TileEntity> tesBeforeBreak = new ArrayDeque(8);

    public BlockMultiID(Configuration config, InternalName internalName1, Material material) {
        super(config, internalName1, material);
    }

    public BlockMultiID(Configuration config, InternalName internalName1, Material material, Class<? extends ItemBlockIC2> itemClass) {
        super(config, internalName1, material, itemClass);
    }

    @Override
    public int getFacing(IBlockAccess iBlockAccess, int x, int y, int z) {
        TileEntity te = iBlockAccess.func_72796_p(x, y, z);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getFacing();
        }
        int meta = iBlockAccess.func_72805_g(x, y, z);
        return this.getFacing(meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        int metaCount = this.getMetaCount();
        this.textures = new Icon[metaCount][12];
        for (int index = 0; index < metaCount; ++index) {
            String textureFolder = this.getTextureFolder(index);
            textureFolder = textureFolder == null ? "" : textureFolder + "/";
            String name = "ic2:" + textureFolder + this.getTextureName(index);
            for (int active = 0; active < 2; ++active) {
                for (int side = 0; side < 6; ++side) {
                    int subIndex = active * 6 + side;
                    String subName = name + ":" + subIndex;
                    BlockTextureStitched texture = new BlockTextureStitched(subName, subIndex);
                    this.textures[index][subIndex] = texture;
                    ((TextureMap)iconRegister).setTextureEntry(subName, (TextureAtlasSprite)texture);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        int facing = this.getFacing(iBlockAccess, x, y, z);
        boolean active = BlockMultiID.isActive(iBlockAccess, x, y, z);
        int meta = iBlockAccess.func_72805_g(x, y, z);
        int index = this.getTextureIndex(meta);
        if (index >= this.textures.length) {
            return null;
        }
        int subIndex = BlockMultiID.getTextureSubIndex(facing, side);
        if (active) {
            subIndex += 6;
        }
        try {
            return this.textures[index][subIndex];
        }
        catch (Exception e) {
            IC2.platform.displayError(e, "Coordinates: " + x + "/" + y + "/" + z + "\n" + "Side: " + side + "\n" + "Block: " + (Object)((Object)this) + "\n" + "Meta: " + meta + "\n" + "Facing: " + facing + "\n" + "Active: " + active + "\n" + "Index: " + index + "\n" + "SubIndex: " + subIndex);
            return null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        int facing = this.getFacing(meta);
        int index = this.getTextureIndex(meta);
        int subIndex = BlockMultiID.getTextureSubIndex(facing, side);
        if (index >= this.textures.length) {
            return null;
        }
        try {
            return this.textures[index][subIndex];
        }
        catch (Exception e) {
            IC2.platform.displayError(e, "Side: " + side + "\n" + "Block: " + (Object)((Object)this) + "\n" + "Meta: " + meta + "\n" + "Facing: " + facing + "\n" + "Index: " + index + "\n" + "SubIndex: " + subIndex);
            return null;
        }
    }

    public int func_71857_b() {
        return IC2.platform.getRenderId("default");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if ((this.renderMask & 1 << side) != 0) {
            return super.func_71877_c(blockAccess, x, y, z, side);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void onRender(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity te = blockAccess.func_72796_p(x, y, z);
        if (te instanceof TileEntityBlock) {
            ((TileEntityBlock)te).onRender();
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float a, float b, float c) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof IHasGui) {
            if (IC2.platform.isSimulating()) {
                return IC2.platform.launchGui(entityPlayer, (IHasGui)te);
            }
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList ret = super.getBlockDropped(world, x, y, z, metadata, fortune);
        TileEntity te = world.func_72796_p(x, y, z);
        if (te == null) {
            Iterator<TileEntity> it = tesBeforeBreak.descendingIterator();
            while (it.hasNext()) {
                TileEntity te2 = it.next();
                if (te2.field_70331_k != world || te2.field_70329_l != x || te2.field_70330_m != y || te2.field_70327_n != z) continue;
                te = te2;
                it.remove();
                break;
            }
        }
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack itemStack = inv.func_70301_a(i);
                if (itemStack == null) continue;
                ret.add(itemStack);
            }
        }
        return ret;
    }

    public void func_71852_a(World world, int x, int y, int z, int id, int meta) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityBlock) {
            ((TileEntityBlock)te).onBlockBreak(id, meta);
        }
        if (te != null) {
            if (te instanceof IHasGui) {
                for (Object obj : world.field_73010_i) {
                    EntityPlayer player = (EntityPlayer)obj;
                    if (!(player.field_71070_bA instanceof ContainerBase)) continue;
                    ContainerBase container = (ContainerBase)player.field_71070_bA;
                    if (container.base != te) continue;
                    player.func_71053_j();
                }
            }
            if (tesBeforeBreak.size() >= 8) {
                tesBeforeBreak.pop();
            }
            tesBeforeBreak.push(te);
        }
        if (Ic2Items.copperOre != null && this.func_71917_a().equals(Ic2Items.copperOre.func_77977_a())) {
            this.func_71923_g(world, x, y, z, 1);
        }
        if (Ic2Items.tinOre != null && this.func_71917_a().equals(Ic2Items.tinOre.func_77977_a())) {
            this.func_71923_g(world, x, y, z, 1);
        }
        if (Ic2Items.uraniumOre != null && this.func_71917_a().equals(Ic2Items.uraniumOre.func_77977_a())) {
            this.func_71923_g(world, x, y, z, 2);
        }
        if (Ic2Items.leadOre != null && this.func_71917_a().equals(Ic2Items.leadOre.func_77977_a())) {
            this.func_71923_g(world, x, y, z, 1);
        }
        super.func_71852_a(world, x, y, z, id, meta);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemStack) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof IWrenchable) {
            IWrenchable te = (IWrenchable)tileEntity;
            if (entityliving == null) {
                te.setFacing((short)2);
            } else {
                int l = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                switch (l) {
                    case 0: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)4);
                    }
                }
            }
        }
    }

    public void func_71927_h(World world, int x, int y, int z, int meta) {
        super.func_71927_h(world, x, y, z, meta);
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityBlock) {
            TileEntityBlock teb = (TileEntityBlock)te;
            if (teb.loaded) {
                teb.onUnloaded();
            }
        }
    }

    public final boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    public abstract TileEntity createTileEntity(World var1, int var2);

    public static boolean isActive(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity te = iblockaccess.func_72796_p(i, j, k);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getActive();
        }
        return false;
    }

    public void func_71879_a(int j, CreativeTabs tabs, List itemList) {
        Item item = Item.field_77698_e[this.field_71990_ca];
        if (!item.func_77614_k()) {
            itemList.add(new ItemStack((Block)this));
        } else {
            ItemStack is;
            for (int i = 0; i < 16 && Item.field_77698_e[this.field_71990_ca].func_77667_c(is = new ItemStack((Block)this, 1, i)) != null; ++i) {
                itemList.add(is);
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int newFacing;
        IWrenchable te;
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        TileEntity tileEntity = worldObj.func_72796_p(x, y, z);
        if (tileEntity instanceof IWrenchable && (te = (IWrenchable)tileEntity).wrenchCanSetFacing(null, newFacing = ForgeDirection.getOrientation((int)te.getFacing()).getRotation(axis).ordinal())) {
            te.setFacing((short)newFacing);
        }
        return false;
    }
}

