/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.world;

import codechicken.lib.world.WorldExtension;
import codechicken.lib.world.WorldExtensionInstantiator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WorldExtensionManager {
    private static boolean initialised;
    private static ArrayList<WorldExtensionInstantiator> extensionIntialisers;
    private static HashMap<abw, WorldExtension[]> worldMap;

    public static void registerWorldExtension(WorldExtensionInstantiator init) {
        if (!initialised) {
            WorldExtensionManager.init();
        }
        init.instantiatorID = extensionIntialisers.size();
        extensionIntialisers.add(init);
    }

    private static void init() {
        initialised = true;
        MinecraftForge.EVENT_BUS.register((Object)new WorldExtensionEventHandler());
        TickRegistry.registerTickHandler((ITickHandler)new WorldExtensionServerTickHandler(), (Side)Side.SERVER);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            TickRegistry.registerTickHandler((ITickHandler)new WorldExtensionClientTickHandler(), (Side)Side.CLIENT);
        }
    }

    private static void onWorldLoad(abw world) {
        WorldExtension[] extensions = new WorldExtension[extensionIntialisers.size()];
        for (int i = 0; i < extensions.length; ++i) {
            extensions[i] = extensionIntialisers.get(i).createWorldExtension(world);
        }
        worldMap.put(world, extensions);
        for (WorldExtension extension : extensions) {
            extension.load();
        }
    }

    private static void createChunkExtension(abw world, adr chunk) {
        WorldExtension[] extensions = worldMap.get(world);
        for (int i = 0; i < extensionIntialisers.size(); ++i) {
            if (extensions[i].containsChunk(chunk)) continue;
            extensions[i].addChunk(extensionIntialisers.get(i).createChunkExtension(chunk, extensions[i]));
        }
    }

    private static void removeChunk(abw world, adr chunk) {
        for (WorldExtension extension : worldMap.get(world)) {
            extension.remChunk(chunk);
        }
    }

    private static void preTick(abw world) {
        for (WorldExtension extension : worldMap.get(world)) {
            extension.preTick();
        }
    }

    private static void postTick(abw world) {
        for (WorldExtension extension : worldMap.get(world)) {
            extension.postTick();
        }
    }

    public static WorldExtension getWorldExtension(abw world, int instantiatorID) {
        return worldMap.get(world)[instantiatorID];
    }

    static {
        extensionIntialisers = new ArrayList();
        worldMap = new HashMap();
    }

    public static class WorldExtensionServerTickHandler
    implements ITickHandler {
        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
            if (type.contains(TickType.WORLD)) {
                WorldExtensionManager.preTick((abw)tickData[0]);
            }
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            if (type.contains(TickType.WORLD)) {
                WorldExtensionManager.postTick((abw)tickData[0]);
            }
        }

        public EnumSet<TickType> ticks() {
            return EnumSet.of(TickType.WORLD, TickType.CLIENT);
        }

        public String getLabel() {
            return "WorldExtenstions";
        }
    }

    public static class WorldExtensionClientTickHandler
    implements ITickHandler {
        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
            if (type.contains(TickType.CLIENT)) {
                bdd world = atv.w().f;
                if (worldMap.containsKey(world)) {
                    WorldExtensionManager.preTick((abw)world);
                }
            }
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            if (type.contains(TickType.CLIENT)) {
                bdd world = atv.w().f;
                if (worldMap.containsKey(world)) {
                    WorldExtensionManager.postTick((abw)world);
                }
            }
        }

        public EnumSet<TickType> ticks() {
            return EnumSet.of(TickType.CLIENT);
        }

        public String getLabel() {
            return "WorldExtenstions";
        }
    }

    public static class WorldExtensionEventHandler {
        @ForgeSubscribe
        public void onChunkDataLoad(ChunkDataEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            WorldExtensionManager.createChunkExtension(event.world, event.getChunk());
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.world)) {
                extension.loadChunkData(event.getChunk(), event.getData());
            }
        }

        @ForgeSubscribe
        public void onChunkDataSave(ChunkDataEvent.Save event) {
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.world)) {
                extension.saveChunkData(event.getChunk(), event.getData());
            }
            if (!event.getChunk().d) {
                WorldExtensionManager.removeChunk(event.world, event.getChunk());
            }
        }

        @ForgeSubscribe
        public void onChunkLoad(ChunkEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            WorldExtensionManager.createChunkExtension(event.world, event.getChunk());
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.world)) {
                extension.loadChunk(event.getChunk());
            }
        }

        @ForgeSubscribe
        public void onChunkUnLoad(ChunkEvent.Unload event) {
            if (event.getChunk() instanceof adq) {
                return;
            }
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.world)) {
                extension.unloadChunk(event.getChunk());
            }
            if (event.world.I) {
                WorldExtensionManager.removeChunk(event.world, event.getChunk());
            }
        }

        @ForgeSubscribe
        public void onWorldSave(WorldEvent.Save event) {
            if (worldMap.containsKey(event.world)) {
                for (WorldExtension extension : (WorldExtension[])worldMap.get(event.world)) {
                    extension.save();
                }
            }
        }

        @ForgeSubscribe
        public void onWorldLoad(WorldEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
        }

        @ForgeSubscribe
        public void onWorldUnLoad(WorldEvent.Unload event) {
            if (worldMap.containsKey(event.world)) {
                for (WorldExtension extension : (WorldExtension[])worldMap.remove(event.world)) {
                    extension.unload();
                }
            }
        }

        @ForgeSubscribe
        public void onChunkWatch(ChunkWatchEvent.Watch event) {
            adr chunk = event.player.q.e(event.chunk.a, event.chunk.b);
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.player.q)) {
                extension.watchChunk(chunk, event.player);
            }
        }

        @ForgeSubscribe
        public void onChunkUnWatch(ChunkWatchEvent.UnWatch event) {
            adr chunk = event.player.q.e(event.chunk.a, event.chunk.b);
            for (WorldExtension extension : (WorldExtension[])worldMap.get(event.player.q)) {
                extension.unwatchChunk(chunk, event.player);
            }
        }
    }
}

