/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.world;

import codechicken.lib.world.ChunkExtension;
import java.util.HashMap;

public abstract class WorldExtension {
    public final abw world;
    public HashMap<adr, ChunkExtension> chunkMap = new HashMap();

    public WorldExtension(abw world) {
        this.world = world;
    }

    public void load() {
    }

    public void unload() {
    }

    public void save() {
    }

    public void preTick() {
    }

    public void postTick() {
    }

    protected final void addChunk(ChunkExtension extension) {
        this.chunkMap.put(extension.chunk, extension);
    }

    protected final void loadChunk(adr chunk) {
        this.chunkMap.get(chunk).load();
    }

    protected final void unloadChunk(adr chunk) {
        this.chunkMap.get(chunk).unload();
    }

    protected final void loadChunkData(adr chunk, by tag) {
        this.chunkMap.get(chunk).loadData(tag);
    }

    protected final void saveChunkData(adr chunk, by tag) {
        this.chunkMap.get(chunk).saveData(tag);
    }

    protected final void remChunk(adr chunk) {
        this.chunkMap.remove(chunk);
    }

    protected final void watchChunk(adr chunk, jv player) {
        this.chunkMap.get(chunk).watchPlayer(player);
    }

    protected final void unwatchChunk(adr chunk, jv player) {
        ChunkExtension extension = this.chunkMap.get(chunk);
        if (extension != null) {
            extension.unwatchPlayer(player);
        }
    }

    protected final void sendChunkUpdates(adr chunk) {
        this.chunkMap.get(chunk).sendUpdatePackets();
    }

    public boolean containsChunk(adr chunk) {
        return this.chunkMap.containsKey(chunk);
    }

    public ChunkExtension getChunkExtension(int chunkXPos, int chunkZPos) {
        if (!this.world.f(chunkXPos << 4, 128, chunkZPos << 4)) {
            return null;
        }
        return this.chunkMap.get(this.world.e(chunkXPos, chunkZPos));
    }
}

