/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;
import mrtjp.projectred.core.utils.HashPair2;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.core.utils.Pair2;
import mrtjp.projectred.transportation.IWorldBroadcaster;
import mrtjp.projectred.transportation.IWorldCrafter;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.IWorldRouter;
import mrtjp.projectred.transportation.LogisticPathFinder;
import mrtjp.projectred.transportation.RequestBranch;
import mrtjp.projectred.transportation.Router;
import mrtjp.projectred.transportation.StartEndPath;

public class RequestBranchNode {
    private final ItemKeyStack requestedPackage;
    private final IWorldRequester requester;
    private final RequestBranchNode parent;
    protected final RequestBranch root;
    private List<RequestBranchNode> subRequests = new ArrayList<RequestBranchNode>();
    private List<DeliveryPromise> promises = new ArrayList<DeliveryPromise>();
    private List<ExcessPromise> excessPromises = new ArrayList<ExcessPromise>();
    private SortedSet<CraftingPromise> usedCrafters = new TreeSet<CraftingPromise>();
    private CraftingPromise parityBranch = null;
    private int promisedCount = 0;

    public RequestBranchNode(CraftingPromise craftingPromise, ItemKeyStack itemKeyStack, IWorldRequester iWorldRequester, RequestBranchNode requestBranchNode, EnumSet<RequestBranch.RequestFlags> enumSet) {
        this.requestedPackage = itemKeyStack;
        this.requester = iWorldRequester;
        this.parent = requestBranchNode;
        if (requestBranchNode != null) {
            requestBranchNode.subRequests.add(this);
            this.root = requestBranchNode.root;
        } else {
            this.root = (RequestBranch)this;
        }
        if (craftingPromise != null && !this.recurse_IsCrafterUsed(craftingPromise)) {
            this.usedCrafters.add(craftingPromise);
        }
        if (enumSet.contains((Object)RequestBranch.RequestFlags.PULL) && this.getPromisesFromBroadcasters()) {
            return;
        }
        if (enumSet.contains((Object)RequestBranch.RequestFlags.CRAFT) && this.getPromisesFromExcess()) {
            return;
        }
        if (enumSet.contains((Object)RequestBranch.RequestFlags.CRAFT) && this.getPromisesFromCrafters()) {
            return;
        }
    }

    public int getPromisedCount() {
        return this.promisedCount;
    }

    public int getMissingCount() {
        return this.requestedPackage.stackSize() - this.promisedCount;
    }

    public ItemKey getRequestedPackage() {
        return this.requestedPackage.key();
    }

    public boolean isDone() {
        return this.getMissingCount() <= 0;
    }

    public void addPromise(DeliveryPromise deliveryPromise) {
        if (!deliveryPromise.thePackage.equals((Object)this.getRequestedPackage())) {
            return;
        }
        if (deliveryPromise.size > this.getMissingCount()) {
            int n = deliveryPromise.size - this.getMissingCount();
            deliveryPromise.size = this.getMissingCount();
            ExcessPromise excessPromise = new ExcessPromise();
            excessPromise.setPackage(deliveryPromise.thePackage).setSize(n).setSender(deliveryPromise.sender);
            this.excessPromises.add(excessPromise);
        }
        if (deliveryPromise.size <= 0) {
            return;
        }
        this.promises.add(deliveryPromise);
        this.promisedCount += deliveryPromise.size;
        this.root.promiseAdded(deliveryPromise);
    }

    private boolean getPromisesFromCrafters() {
        Object object;
        Object object2;
        List<StartEndPath> list = this.requester.getRouter().JGetRoutesByCost();
        Collections.sort(list, new PathSorter(0.0));
        ArrayList<CraftingPromise> arrayList = new ArrayList<CraftingPromise>(list.size());
        for (StartEndPath object32 : list) {
            CraftingPromise n;
            IWorldCrafter bl;
            object2 = object32.end();
            if (!(((Router)object2).getParent() instanceof IWorldCrafter) || (object = this.recurse_GetCrafterItem(bl = (IWorldCrafter)((Router)object2).getParent())) != null && !object.equals((Object)this.getRequestedPackage()) || (n = bl.requestCraftPromise(this.getRequestedPackage())) == null) continue;
            arrayList.add(n);
        }
        Iterator<StartEndPath> iterator = arrayList.iterator();
        PriorityQueue<CraftingTreeInteraction> priorityQueue = new PriorityQueue<CraftingTreeInteraction>(5);
        object2 = new ArrayList();
        boolean bl = false;
        object = null;
        int n = 0;
        while (!bl) {
            Iterator iterator2;
            if (iterator.hasNext()) {
                if (object == null) {
                    object = (CraftingPromise)((Object)iterator.next());
                }
            } else if (object == null) {
                bl = true;
            }
            int n2 = this.getMissingCount();
            if (object != null && (priorityQueue.isEmpty() || n == ((CraftingPromise)object).getPriority())) {
                n = ((CraftingPromise)object).getPriority();
                iterator2 = object;
                object = null;
                if (this.recurse_IsCrafterUsed((CraftingPromise)((Object)iterator2))) continue;
                CraftingTreeInteraction n4 = new CraftingTreeInteraction((CraftingPromise)((Object)iterator2), n2, this);
                priorityQueue.add(n4);
                continue;
            }
            if (((ArrayList)object2).isEmpty() && priorityQueue.isEmpty()) continue;
            if (priorityQueue.size() == 1) {
                ((ArrayList)object2).add(priorityQueue.poll());
                ((CraftingTreeInteraction)((ArrayList)object2).get(0)).addAdditionalItems(n2);
            } else {
                if (!priorityQueue.isEmpty()) {
                    ((ArrayList)object2).add(priorityQueue.poll());
                }
                while (!((ArrayList)object2).isEmpty() && n2 > 0) {
                    while (!priorityQueue.isEmpty() && ((CraftingTreeInteraction)priorityQueue.peek()).toDo() <= ((CraftingTreeInteraction)((ArrayList)object2).get(0)).toDo()) {
                        ((ArrayList)object2).add(priorityQueue.poll());
                    }
                    int n3 = !priorityQueue.isEmpty() ? ((CraftingTreeInteraction)priorityQueue.peek()).toDo() : Integer.MAX_VALUE;
                    int craftingTreeInteraction = ((CraftingTreeInteraction)((ArrayList)object2).get(0)).toDo();
                    n3 = Math.min(n3, craftingTreeInteraction + (n2 + ((ArrayList)object2).size() - 1) / ((ArrayList)object2).size());
                    Iterator iterator3 = ((ArrayList)object2).iterator();
                    while (iterator3.hasNext()) {
                        CraftingTreeInteraction craftingTreeInteraction2 = (CraftingTreeInteraction)iterator3.next();
                        int n4 = Math.min(n2, n3 - craftingTreeInteraction);
                        if (n4 <= 0) continue;
                        int n5 = craftingTreeInteraction2.addAdditionalItems(n4);
                        n2 -= n5;
                    }
                }
            }
            iterator2 = ((ArrayList)object2).iterator();
            while (iterator2.hasNext()) {
                CraftingTreeInteraction craftingTreeInteraction = (CraftingTreeInteraction)iterator2.next();
                if (craftingTreeInteraction.setsRequested <= 0 || craftingTreeInteraction.finalizeInteraction()) continue;
                iterator2.remove();
            }
            n2 = this.getMissingCount();
            if (n2 <= 0) break;
            if (((ArrayList)object2).isEmpty()) continue;
            bl = false;
        }
        return this.isDone();
    }

    private boolean getPromisesFromExcess() {
        LinkedList<ExcessPromise> linkedList = this.root.getAllExcessFor(this.getRequestedPackage());
        for (ExcessPromise excessPromise : linkedList) {
            if (this.isDone()) break;
            if (excessPromise.size <= 0) continue;
            excessPromise.size = Math.min(excessPromise.size, this.getMissingCount());
            this.addPromise(excessPromise);
        }
        return this.isDone();
    }

    private boolean getPromisesFromBroadcasters() {
        List<StartEndPath> list = this.requester.getRouter().JGetRoutesByCost();
        Collections.sort(list, new PathSorter(1.0));
        for (StartEndPath startEndPath : list) {
            if (this.isDone()) break;
            Router router = startEndPath.end();
            IWorldRouter iWorldRouter = router.getParent();
            if (!(iWorldRouter instanceof IWorldBroadcaster) || LogisticPathFinder.sharesInventory(this.requester.getContainer(), iWorldRouter.getContainer())) continue;
            IWorldBroadcaster iWorldBroadcaster = (IWorldBroadcaster)iWorldRouter;
            iWorldBroadcaster.requestPromises(this, this.root.getExistingPromisesFor((HashPair2<IWorldBroadcaster, ItemKey>)new HashPair2((Object)iWorldBroadcaster, (Object)this.getRequestedPackage())));
        }
        return this.isDone();
    }

    private int getPotentialSubPromises(int n, CraftingPromise craftingPromise) {
        boolean bl = false;
        int n2 = n;
        List<Pair2<ItemKeyStack, IWorldRequester>> list = craftingPromise.getScaledIngredients(n);
        ArrayList<RequestBranchNode> arrayList = new ArrayList<RequestBranchNode>(list.size());
        for (Pair2<ItemKeyStack, IWorldRequester> object : list) {
            RequestBranchNode requestBranchNode = new RequestBranchNode(craftingPromise, (ItemKeyStack)object.getValue1(), (IWorldRequester)object.getValue2(), this, RequestBranch.RequestFlags.def);
            arrayList.add(requestBranchNode);
            if (requestBranchNode.isDone()) continue;
            bl = true;
        }
        if (bl) {
            for (RequestBranchNode requestBranchNode : arrayList) {
                requestBranchNode.destroy();
            }
            this.parityBranch = craftingPromise;
            for (int i = 0; i < list.size(); ++i) {
                n2 = Math.min(n2, ((RequestBranchNode)arrayList.get(i)).getPromisedCount() / (((ItemKeyStack)list.get(i).getValue1()).stackSize() / n));
            }
            return this.getAbsoluteSubPromises(n2, craftingPromise);
        }
        return n2;
    }

    private int getAbsoluteSubPromises(int n, CraftingPromise craftingPromise) {
        ArrayList<RequestBranchNode> arrayList = new ArrayList<RequestBranchNode>();
        if (n > 0) {
            List<Pair2<ItemKeyStack, IWorldRequester>> list = craftingPromise.getScaledIngredients(n);
            boolean bl = false;
            for (Pair2<ItemKeyStack, IWorldRequester> object : list) {
                RequestBranchNode requestBranchNode = new RequestBranchNode(craftingPromise, (ItemKeyStack)object.getValue1(), (IWorldRequester)object.getValue2(), this, RequestBranch.RequestFlags.def);
                arrayList.add(requestBranchNode);
                if (requestBranchNode.isDone()) continue;
                bl = true;
            }
            if (bl) {
                for (RequestBranchNode requestBranchNode : arrayList) {
                    requestBranchNode.destroy();
                }
                return 0;
            }
        }
        return n;
    }

    private void destroy() {
        this.parent.remove(this);
    }

    protected void remove(RequestBranchNode requestBranchNode) {
        this.subRequests.remove(requestBranchNode);
        requestBranchNode.recurse_RemoveSubPromisses();
    }

    protected void recurse_RemoveSubPromisses() {
        for (DeliveryPromise object : this.promises) {
            this.root.promiseRemoved(object);
        }
        for (RequestBranchNode requestBranchNode : this.subRequests) {
            requestBranchNode.recurse_RemoveSubPromisses();
        }
    }

    protected boolean recurse_IsCrafterUsed(CraftingPromise craftingPromise) {
        if (!this.usedCrafters.isEmpty() && this.usedCrafters.contains(craftingPromise)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.recurse_IsCrafterUsed(craftingPromise);
    }

    protected ItemKey recurse_GetCrafterItem(IWorldCrafter iWorldCrafter) {
        for (CraftingPromise craftingPromise : this.usedCrafters) {
            if (!craftingPromise.getCrafter().equals(iWorldCrafter)) continue;
            return craftingPromise.getResultItem();
        }
        if (this.parent != null) {
            return this.parent.recurse_GetCrafterItem(iWorldCrafter);
        }
        return null;
    }

    protected void recurse_RequestDelivery() {
        for (RequestBranchNode object : this.subRequests) {
            object.recurse_RequestDelivery();
        }
        for (DeliveryPromise deliveryPromise : this.promises) {
            deliveryPromise.sender.deliverPromises(deliveryPromise, this.requester);
        }
        for (ExcessPromise excessPromise : this.excessPromises) {
            if (!(excessPromise.sender instanceof IWorldCrafter)) continue;
            ((IWorldCrafter)excessPromise.sender).registerExcess(excessPromise);
        }
    }

    protected void recurse_GatherExcess(ItemKey itemKey, HashMap<IWorldBroadcaster, List<ExcessPromise>> hashMap) {
        for (ExcessPromise object : this.excessPromises) {
            if (object.thePackage != itemKey) continue;
            List<ExcessPromise> list = hashMap.get(object.sender);
            if (list == null) {
                list = new LinkedList<ExcessPromise>();
                hashMap.put(object.sender, list);
            }
            list.add(object.copy());
        }
        for (RequestBranchNode requestBranchNode : this.subRequests) {
            requestBranchNode.recurse_GatherExcess(itemKey, hashMap);
        }
    }

    protected void recurse_RemoveUnusableExcess(ItemKey itemKey, HashMap<IWorldBroadcaster, List<ExcessPromise>> hashMap) {
        block0: for (DeliveryPromise object : this.promises) {
            if (object.thePackage != itemKey || !(object instanceof ExcessPromise)) continue;
            ExcessPromise excessPromise = (ExcessPromise)object;
            if (excessPromise.used) continue;
            int n = excessPromise.size;
            List<ExcessPromise> list = hashMap.get(excessPromise.sender);
            if (list == null) continue;
            Iterator<ExcessPromise> iterator = list.iterator();
            while (iterator.hasNext()) {
                ExcessPromise excessPromise2 = iterator.next();
                if (excessPromise2.size >= n) {
                    excessPromise2.size -= n;
                    continue block0;
                }
                n -= excessPromise2.size;
                iterator.remove();
            }
        }
        for (RequestBranchNode requestBranchNode : this.subRequests) {
            requestBranchNode.recurse_RemoveUnusableExcess(itemKey, hashMap);
        }
    }

    protected void recurse_RebuildParityTree() {
        if (this.isDone()) {
            return;
        }
        if (this.parityBranch == null) {
            return;
        }
        int n = (this.getMissingCount() + this.parityBranch.getSizeForSet() - 1) / this.parityBranch.getSizeForSet();
        List<Pair2<ItemKeyStack, IWorldRequester>> list = this.parityBranch.getScaledIngredients(n);
        for (Pair2<ItemKeyStack, IWorldRequester> object : list) {
            new RequestBranchNode(this.parityBranch, (ItemKeyStack)object.getValue1(), (IWorldRequester)object.getValue2(), this, RequestBranch.RequestFlags.def);
        }
        this.addPromise(this.parityBranch.getScaledPromise(n));
        for (RequestBranchNode requestBranchNode : this.subRequests) {
            requestBranchNode.recurse_RebuildParityTree();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void recurse_GatherStatisticsMissing(Map<ItemKey, Integer> map) {
        int n = this.getMissingCount();
        if (n > 0) {
            void var4_6;
            ItemKey itemKey = this.getRequestedPackage();
            Integer object = map.get(itemKey);
            if (object == null) {
                Integer n2 = 0;
            }
            Integer n3 = var4_6.intValue() + n;
            map.put(itemKey, n3);
        }
        for (RequestBranchNode requestBranchNode : this.subRequests) {
            requestBranchNode.recurse_GatherStatisticsMissing(map);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void recurse_GatherStatisticsUsed(Map<ItemKey, Integer> map) {
        int n = 0;
        for (DeliveryPromise object : this.promises) {
            if (object.sender instanceof IWorldCrafter) continue;
            n += object.size;
        }
        if (n > 0) {
            void var4_7;
            ItemKey itemKey = this.getRequestedPackage();
            Integer n2 = map.get(itemKey);
            if (n2 == null) {
                Integer n3 = 0;
            }
            Integer n4 = var4_7.intValue() + n;
            map.put(itemKey, n4);
        }
        for (RequestBranchNode requestBranchNode : this.subRequests) {
            requestBranchNode.recurse_GatherStatisticsUsed(map);
        }
    }

    private static class PathSorter
    implements Comparator<StartEndPath> {
        private final double distanceWeight;

        public PathSorter(double d) {
            this.distanceWeight = d;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(StartEndPath startEndPath, StartEndPath startEndPath2) {
            int n;
            double d = 0.0;
            IWorldRouter iWorldRouter = startEndPath.end().getParent();
            IWorldRouter iWorldRouter2 = startEndPath2.end().getParent();
            int n2 = iWorldRouter instanceof IWorldBroadcaster ? ((IWorldBroadcaster)iWorldRouter).getPriority() : Integer.MIN_VALUE;
            int n3 = n = iWorldRouter2 instanceof IWorldBroadcaster ? ((IWorldBroadcaster)iWorldRouter2).getPriority() : Integer.MIN_VALUE;
            if (n2 > Integer.MIN_VALUE) {
                if (n <= Integer.MIN_VALUE) return -1;
                d = n - n2;
            } else if (n > Integer.MIN_VALUE) {
                return 1;
            }
            if (d != 0.0) {
                return (int)d;
            }
            int n4 = 1;
            if (startEndPath.end().getIPAddress() - startEndPath2.end().getIPAddress() > 0) {
                n4 = -1;
                StartEndPath startEndPath3 = startEndPath;
                startEndPath = startEndPath2;
                startEndPath2 = startEndPath3;
            }
            double d2 = iWorldRouter instanceof IWorldBroadcaster ? ((IWorldBroadcaster)iWorldRouter).getWorkLoad() : 0.0;
            double d3 = iWorldRouter2 instanceof IWorldBroadcaster ? ((IWorldBroadcaster)iWorldRouter2).getWorkLoad() : 0.0;
            d = d2 - d3;
            if ((d += (double)(startEndPath.distance() - startEndPath2.distance()) * this.distanceWeight) == 0.0) {
                return -n4;
            }
            if (!(d > 0.0)) return (int)(d - 0.5) * n4;
            return (int)(d + 0.5) * n4;
        }
    }

    private class CraftingTreeInteraction
    implements Comparable<CraftingTreeInteraction> {
        private int setsRequested;
        private final int setSize;
        private final int maxSetsAvailable;
        private final RequestBranchNode treeNode;
        public final CraftingPromise crafter;
        public final int originalToDo;

        private CraftingTreeInteraction(CraftingPromise craftingPromise, int n, RequestBranchNode requestBranchNode2) {
            this.crafter = craftingPromise;
            this.treeNode = requestBranchNode2;
            this.originalToDo = craftingPromise.getCrafter().itemsToProcess();
            this.setsRequested = 0;
            this.setSize = craftingPromise.getSizeForSet();
            this.maxSetsAvailable = (this.treeNode.getMissingCount() + this.setSize - 1) / this.setSize;
        }

        public int toDo() {
            return this.originalToDo + this.setsRequested * this.setSize;
        }

        private int calculateMaxPotentialSets(int n) {
            int n2 = n > 0 ? n : (this.treeNode.getMissingCount() + this.setSize - 1) / this.setSize;
            if (n2 <= 0) {
                return 0;
            }
            return RequestBranchNode.this.getPotentialSubPromises(n2, this.crafter);
        }

        public int addAdditionalItems(int n) {
            int n2 = (n + this.setSize - 1) / this.setSize;
            this.setsRequested += n2;
            return n2 * this.setSize;
        }

        public boolean finalizeInteraction() {
            int n = Math.min(this.setsRequested, this.maxSetsAvailable);
            int n2 = this.calculateMaxPotentialSets(n);
            if (n2 > 0) {
                DeliveryPromise deliveryPromise = this.crafter.getScaledPromise(n2);
                if (deliveryPromise.size != n2 * this.setSize) {
                    return false;
                }
                this.treeNode.addPromise(deliveryPromise);
            }
            boolean bl = n == n2;
            this.setsRequested = 0;
            return bl;
        }

        @Override
        public int compareTo(CraftingTreeInteraction craftingTreeInteraction) {
            return this.toDo() - craftingTreeInteraction.toDo();
        }
    }

    public static class CraftingPromise
    implements Comparable<CraftingPromise> {
        private IWorldCrafter crafter;
        private ItemKeyStack result;
        private ArrayList<Pair2<ItemKeyStack, IWorldRequester>> ingredients = new ArrayList(9);
        private final int priority;

        public CraftingPromise(ItemKeyStack itemKeyStack, IWorldCrafter iWorldCrafter, int n) {
            this.result = itemKeyStack;
            this.crafter = iWorldCrafter;
            this.priority = n;
        }

        public IWorldCrafter getCrafter() {
            return this.crafter;
        }

        public int getPriority() {
            return this.priority;
        }

        public CraftingPromise addIngredient(ItemKeyStack itemKeyStack, IWorldRequester iWorldRequester) {
            for (Pair2<ItemKeyStack, IWorldRequester> pair2 : this.ingredients) {
                if (!((ItemKeyStack)pair2.getValue1()).key().equals((Object)itemKeyStack.key()) || pair2.getValue2() != iWorldRequester) continue;
                ((ItemKeyStack)pair2.getValue1()).setSize(((ItemKeyStack)pair2.getValue1()).stackSize() + itemKeyStack.stackSize());
                return this;
            }
            this.ingredients.add((Pair2<ItemKeyStack, IWorldRequester>)new Pair2((Object)itemKeyStack, (Object)iWorldRequester));
            return this;
        }

        public DeliveryPromise getScaledPromise(int n) {
            DeliveryPromise deliveryPromise = new DeliveryPromise();
            deliveryPromise.setPackage(this.result.key().copy()).setSize(this.result.stackSize() * n).setSender(this.crafter);
            return deliveryPromise;
        }

        public List<Pair2<ItemKeyStack, IWorldRequester>> getScaledIngredients(int n) {
            ArrayList<Pair2<ItemKeyStack, IWorldRequester>> arrayList = new ArrayList<Pair2<ItemKeyStack, IWorldRequester>>(this.ingredients.size());
            for (Pair2<ItemKeyStack, IWorldRequester> pair2 : this.ingredients) {
                Pair2 pair22 = new Pair2((Object)((ItemKeyStack)pair2.getValue1()).copy(), pair2.getValue2());
                ((ItemKeyStack)pair22.getValue1()).setSize(((ItemKeyStack)pair22.getValue1()).stackSize() * n);
                arrayList.add((Pair2<ItemKeyStack, IWorldRequester>)pair22);
            }
            return arrayList;
        }

        @Override
        public int compareTo(CraftingPromise craftingPromise) {
            int n = this.priority - craftingPromise.priority;
            if (n == 0) {
                n = this.result.compareTo((Object)craftingPromise.result);
            }
            if (n == 0) {
                n = this.crafter.getRouter().compareTo(craftingPromise.crafter.getRouter());
            }
            return n;
        }

        public int getSizeForSet() {
            return this.result.stackSize();
        }

        public ItemKey getResultItem() {
            return this.result.key();
        }
    }

    public static class ExcessPromise
    extends DeliveryPromise {
        public boolean used;

        public ExcessPromise setUsed(boolean bl) {
            this.used = bl;
            return this;
        }

        @Override
        public ExcessPromise copy() {
            ExcessPromise excessPromise = new ExcessPromise();
            excessPromise.setPackage(this.thePackage).setSize(this.size).setSender(this.sender);
            excessPromise.setUsed(this.used);
            return excessPromise;
        }
    }

    public static class DeliveryPromise {
        public ItemKey thePackage;
        public int size;
        public IWorldBroadcaster sender;

        public DeliveryPromise setPackage(ItemKey itemKey) {
            this.thePackage = itemKey;
            return this;
        }

        public DeliveryPromise setSize(int n) {
            this.size = n;
            return this;
        }

        public DeliveryPromise setSender(IWorldBroadcaster iWorldBroadcaster) {
            this.sender = iWorldBroadcaster;
            return this;
        }

        public DeliveryPromise copy() {
            DeliveryPromise deliveryPromise = new DeliveryPromise();
            deliveryPromise.setPackage(this.thePackage).setSize(this.size).setSender(this.sender);
            return deliveryPromise;
        }
    }
}

