/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.utils.HashPair2;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.transportation.IWorldBroadcaster;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.RequestBranchNode;

public class RequestBranch
extends RequestBranchNode {
    private HashMap<HashPair2<IWorldBroadcaster, ItemKey>, Integer> totalPromises;

    public RequestBranch(ItemKeyStack itemKeyStack, IWorldRequester iWorldRequester, EnumSet<RequestFlags> enumSet) {
        super(null, itemKeyStack, iWorldRequester, null, enumSet);
    }

    protected void promiseAdded(RequestBranchNode.DeliveryPromise deliveryPromise) {
        HashPair2 hashPair2 = new HashPair2((Object)deliveryPromise.sender, (Object)deliveryPromise.thePackage);
        this.totalPromises.put((HashPair2<IWorldBroadcaster, ItemKey>)hashPair2, this.getExistingPromisesFor((HashPair2<IWorldBroadcaster, ItemKey>)hashPair2) + deliveryPromise.size);
    }

    protected void promiseRemoved(RequestBranchNode.DeliveryPromise deliveryPromise) {
        HashPair2 hashPair2 = new HashPair2((Object)deliveryPromise.sender, (Object)deliveryPromise.thePackage);
        int n = this.getExistingPromisesFor((HashPair2<IWorldBroadcaster, ItemKey>)hashPair2) - deliveryPromise.size;
        if (n <= 0) {
            this.totalPromises.remove(hashPair2);
        } else {
            this.totalPromises.put((HashPair2<IWorldBroadcaster, ItemKey>)hashPair2, n);
        }
    }

    protected LinkedList<RequestBranchNode.ExcessPromise> getAllExcessFor(ItemKey itemKey) {
        HashMap<IWorldBroadcaster, List<RequestBranchNode.ExcessPromise>> hashMap = new HashMap<IWorldBroadcaster, List<RequestBranchNode.ExcessPromise>>();
        this.recurse_GatherExcess(itemKey, hashMap);
        this.recurse_RemoveUnusableExcess(itemKey, hashMap);
        LinkedList<RequestBranchNode.ExcessPromise> linkedList = new LinkedList<RequestBranchNode.ExcessPromise>();
        for (List<RequestBranchNode.ExcessPromise> list : hashMap.values()) {
            linkedList.addAll(list);
        }
        return linkedList;
    }

    public int getExistingPromisesFor(HashPair2<IWorldBroadcaster, ItemKey> hashPair2) {
        Integer n;
        if (this.totalPromises == null) {
            this.totalPromises = new HashMap();
        }
        if ((n = this.totalPromises.get(hashPair2)) == null) {
            return 0;
        }
        return n;
    }

    static enum RequestFlags {
        PULL,
        CRAFT,
        PARTIALS,
        SIMULATE;

        public static final EnumSet<RequestFlags> all;
        public static final EnumSet<RequestFlags> def;

        static {
            all = EnumSet.allOf(RequestFlags.class);
            def = EnumSet.of(PULL, CRAFT);
        }
    }
}

