/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.LinkedList;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.core.utils.Pair2;
import mrtjp.projectred.transportation.IWorldRequester;

public class DeliveryManager {
    private LinkedList<Pair2<ItemKeyStack, IWorldRequester>> orders = new LinkedList();

    public void addOrder(ItemKeyStack itemKeyStack, IWorldRequester iWorldRequester) {
        for (Pair2 pair2 : this.orders) {
            if (pair2.getValue1() != itemKeyStack || pair2.getValue2() != iWorldRequester) continue;
            itemKeyStack.setSize(itemKeyStack.stackSize() + ((ItemKeyStack)pair2.getValue1()).stackSize());
            this.orders.remove(pair2);
            break;
        }
        this.orders.addLast((Pair2<ItemKeyStack, IWorldRequester>)new Pair2((Object)itemKeyStack, (Object)iWorldRequester));
        this.onOrdersChanged();
    }

    public void dispatchSuccessful(int n, boolean bl) {
        Pair2<ItemKeyStack, IWorldRequester> pair2 = this.orders.getFirst();
        ((ItemKeyStack)pair2.getValue1()).setSize(((ItemKeyStack)pair2.getValue1()).stackSize() - n);
        if (((ItemKeyStack)pair2.getValue1()).stackSize() <= 0) {
            this.orders.removeFirst();
        } else if (bl) {
            this.restock();
        }
    }

    public void dispatchFailed() {
        Pair2<ItemKeyStack, IWorldRequester> pair2 = this.orders.getFirst();
        ((IWorldRequester)pair2.getValue2()).trackedItemLost((ItemKeyStack)pair2.getValue1());
        if (!this.orders.isEmpty()) {
            this.orders.removeFirst();
        }
        this.onOrdersChanged();
    }

    public void restock() {
        Pair2<ItemKeyStack, IWorldRequester> pair2 = this.orders.removeFirst();
        this.orders.addLast(pair2);
    }

    public Pair2<ItemKeyStack, IWorldRequester> peek() {
        if (this.orders.isEmpty()) {
            return null;
        }
        return this.orders.getFirst();
    }

    public boolean hasOrders() {
        return !this.orders.isEmpty();
    }

    public int getDeliveryCount(ItemKey itemKey) {
        int n = 0;
        for (Pair2 pair2 : this.orders) {
            if (!((ItemKeyStack)pair2.getValue1()).key().equals((Object)itemKey)) continue;
            n += ((ItemKeyStack)pair2.getValue1()).stackSize();
        }
        return n;
    }

    public int getTotalDeliveryCount() {
        int n = 0;
        for (Pair2 pair2 : this.orders) {
            n += ((ItemKeyStack)pair2.getValue1()).stackSize();
        }
        return n;
    }

    public void onOrdersChanged() {
    }
}

