/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IHollowConnect;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import codechicken.multipart.TileMultipart;
import java.util.Arrays;
import java.util.LinkedList;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.transportation.IPipeConnectable;
import mrtjp.projectred.transportation.PipeDef;

public abstract class CorePipePart
extends TMultiPart
implements IPipeConnectable,
TSlottedPart,
JNormalOcclusion,
IHollowConnect {
    public static Cuboid6[] boundingBoxes = new Cuboid6[7];
    private static int expandBounds = -1;
    public int connMap;
    public byte meta;

    public void preparePlacement(int n) {
        this.meta = (byte)n;
    }

    public int getHollowSize() {
        return 8;
    }

    public float getStrength(ata ata2, uf uf2) {
        return 2.0f;
    }

    public boolean occlusionTest(TMultiPart tMultiPart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)tMultiPart);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        if (expandBounds >= 0) {
            return Arrays.asList(boundingBoxes[expandBounds]);
        }
        return Arrays.asList(boundingBoxes[6]);
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        Iterable<Cuboid6> iterable = this.getCollisionBoxes();
        LinkedList<IndexedCuboid6> linkedList = new LinkedList<IndexedCuboid6>();
        for (Cuboid6 cuboid6 : iterable) {
            linkedList.add(new IndexedCuboid6((Object)0, cuboid6));
        }
        return linkedList;
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        LinkedList<Cuboid6> linkedList = new LinkedList<Cuboid6>();
        linkedList.add(boundingBoxes[6]);
        for (int i = 0; i < 6; ++i) {
            if (!this.maskConnects(i)) continue;
            linkedList.add(boundingBoxes[i]);
        }
        return linkedList;
    }

    public int getSlotMask() {
        return 64;
    }

    public void save(by by2) {
        super.save(by2);
        by2.a("connMap", this.connMap);
        by2.a("meta", this.meta);
    }

    public void load(by by2) {
        super.load(by2);
        this.connMap = by2.e("connMap");
        this.meta = by2.c("meta");
    }

    public void writeDesc(MCDataOutput mCDataOutput) {
        mCDataOutput.writeByte(this.clientConnMap());
        mCDataOutput.writeByte((int)this.meta);
    }

    public void readDesc(MCDataInput mCDataInput) {
        this.connMap = mCDataInput.readUByte();
        this.meta = mCDataInput.readByte();
    }

    public void read(MCDataInput mCDataInput) {
        this.read(mCDataInput, mCDataInput.readUByte());
    }

    public void read(MCDataInput mCDataInput, int n) {
        if (n == 0) {
            this.connMap = mCDataInput.readUByte();
            this.tile().markRender();
        }
    }

    public void onNeighborChanged() {
        if (!this.world().I && this.updateExternalConnections()) {
            this.sendConnUpdate();
        }
    }

    public void onPartChanged(TMultiPart tMultiPart) {
        if (!this.world().I) {
            boolean bl = false;
            if (this.updateOpenConnections()) {
                bl = this.updateExternalConnections();
            }
            if (bl) {
                this.sendConnUpdate();
            }
        }
    }

    public void onAdded() {
        if (!this.world().I) {
            this.updateOpenConnections();
            if (this.updateExternalConnections()) {
                this.sendConnUpdate();
            }
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().I) {
            for (int i = 0; i < 6; ++i) {
                if ((this.connMap & 1 << i) == 0) continue;
                this.notifyStraightChange(i);
            }
        }
    }

    public Iterable<ye> getDrops() {
        return Arrays.asList(this.getItem());
    }

    public ye pickItem(ata ata2) {
        return this.getItem();
    }

    public ye getItem() {
        return PipeDef.VALID_PIPE()[this.meta].getItemStack();
    }

    public void notifyStraightChange(int n) {
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n);
        this.world().g(blockCoord.x, blockCoord.y, blockCoord.z, this.tile().q().cF);
    }

    public void onChunkLoad() {
    }

    public void onWorldJoin() {
        this.onNeighborChanged();
    }

    public int clientConnMap() {
        return this.connMap & 0x3F | this.connMap >> 6 & 0x3F;
    }

    public void sendConnUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(0).writeByte(this.clientConnMap());
    }

    protected boolean updateExternalConnections() {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.maskOpen(i) || !this.connect(i)) continue;
            n |= 1 << i;
        }
        if (n != (this.connMap & 0x3F)) {
            this.connMap = this.connMap & 0xFFFFFFC0 | n;
            return true;
        }
        return false;
    }

    protected boolean updateOpenConnections() {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.connectionOpen(i)) continue;
            n |= 1 << i + 12;
        }
        if (n != (this.connMap & 0x3F000)) {
            this.connMap = this.connMap & 0xFFFC0FFF | n;
            return true;
        }
        return false;
    }

    public boolean connectionOpen(int n) {
        TMultiPart tMultiPart = this.tile().partMap(n);
        if (tMultiPart == null) {
            return true;
        }
        if (tMultiPart instanceof IPipeConnectable && this.canConnectTo((IPipeConnectable)tMultiPart)) {
            return false;
        }
        expandBounds = n;
        boolean bl = this.tile().canReplacePart((TMultiPart)this, (TMultiPart)this);
        expandBounds = -1;
        return bl;
    }

    public boolean connect(int n) {
        TileMultipart tileMultipart;
        TMultiPart tMultiPart;
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n);
        asp asp2 = (asp)BasicUtils.getTileEntity((acf)this.world(), (BlockCoord)blockCoord, asp.class);
        if (asp2 instanceof TileMultipart && (tMultiPart = (tileMultipart = (TileMultipart)asp2).partMap(6)) instanceof IPipeConnectable) {
            return ((IPipeConnectable)tMultiPart).connect(this, n ^ 1);
        }
        return false;
    }

    @Override
    public boolean connect(IPipeConnectable iPipeConnectable, int n) {
        if (this.canConnectTo(iPipeConnectable) && this.maskOpen(n)) {
            int n2 = this.connMap;
            this.connMap |= 1 << n;
            if (n2 != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canConnectTo(IPipeConnectable iPipeConnectable) {
        return true;
    }

    public abstract String getType();

    public boolean maskConnects(int n) {
        return (this.connMap & 65 << n) != 0;
    }

    public boolean maskOpen(int n) {
        return (this.connMap & 4096 << n) != 0;
    }

    static {
        double d = 0.25;
        CorePipePart.boundingBoxes[6] = new Cuboid6(0.5 - d, 0.5 - d, 0.5 - d, 0.5 + d, 0.5 + d, 0.5 + d);
        for (int i = 0; i < 6; ++i) {
            CorePipePart.boundingBoxes[i] = new Cuboid6(0.5 - d, 0.0, 0.5 - d, 0.5 + d, 0.5 - d, 0.5 + d).apply(Rotation.sideRotations[i].at(Vector3.center));
        }
    }
}

