/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.event.FMLInterModComms;
import magicbees.bees.AlleleEffectCrumbling;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class IMCManager {
    public static void handle(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            try {
                if (message.key.equals("addCrumblePair")) {
                    IMCManager.handleCrumbleBlock(message);
                    continue;
                }
                FMLLog.warning((String)"Magic Bees recieved an IMC Message from a mod %s but does not support messages keyed with %s.", (Object[])new Object[]{message.getSender(), message.key});
            }
            catch (Exception e) {
                FMLLog.warning((String)"Magic Bees recieved an invalid IMC Message from a mod %s! Please inform the author of %s that they may not be correctly implementing message for key '%s'. Error details follow.", (Object[])new Object[]{message.getSender(), message.key});
                FMLLog.info((String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    private static void handleCrumbleBlock(FMLInterModComms.IMCMessage message) throws Exception {
        ItemStack sourceItem;
        NBTTagCompound root = message.getNBTValue();
        NBTBase source = root.func_74781_a("source");
        NBTBase target = root.func_74781_a("target");
        if (source != null && source instanceof NBTTagCompound) {
            sourceItem = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)source));
            if (!(target instanceof NBTTagCompound)) {
                throw new Exception("Required tag 'target' was either empty, or not a valid ItemStack.");
            }
        } else {
            throw new Exception("Required tag 'source' was either empty, or not a valid ItemStack.");
        }
        ItemStack targetItem = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)target));
        AlleleEffectCrumbling.addPairToMap(sourceItem, targetItem);
    }
}

