/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils;

import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.BlockInterface;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.RecipeManagers;
import magicbees.item.ItemCapsule;
import magicbees.item.types.CombType;
import magicbees.item.types.DropType;
import magicbees.item.types.FluidType;
import magicbees.item.types.NuggetType;
import magicbees.item.types.PollenType;
import magicbees.item.types.PropolisType;
import magicbees.item.types.ResourceType;
import magicbees.item.types.WaxType;
import magicbees.main.Config;
import magicbees.main.utils.compat.ArsMagicaHelper;
import magicbees.main.utils.compat.ForestryHelper;
import magicbees.main.utils.compat.ThaumcraftHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CraftingManager {
    public static void registerLiquidContainers() {
        CraftingManager.registerLiquidContainer(Config.magicCapsule);
        CraftingManager.registerLiquidContainer(Config.voidCapsule);
    }

    public static void setupCrafting() {
        CraftingManager.setupVanillaCrafting();
        CraftingManager.setupCentrifugeRecipes();
        CraftingManager.setupCarpenterRecipes();
    }

    private static void setupVanillaCrafting() {
        ItemStack output = new ItemStack((Item)Config.magicCapsule);
        output.field_77994_a = 4;
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{"WWW", Character.valueOf('W'), "waxMagical"}));
        ItemStack input = Config.miscResources.getStackForType(ResourceType.EXTENDED_FERTILIZER);
        output = ItemInterface.getItem((String)"fertilizerCompound");
        output.field_77994_a = 6;
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{" S ", " F ", " S ", Character.valueOf('F'), input, Character.valueOf('S'), Block.field_71939_E});
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{"   ", "SFS", "   ", Character.valueOf('F'), input, Character.valueOf('S'), Block.field_71939_E});
        output = output.func_77946_l();
        output.field_77994_a = 12;
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{"aaa", "aFa", "aaa", Character.valueOf('F'), input, Character.valueOf('a'), ItemInterface.getItem((String)"ash")});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Item.field_77809_bD), (Object[])new Object[]{"DDD", "DBD", "DDD", Character.valueOf('D'), Config.drops.getStackForType(DropType.INTELLECT), Character.valueOf('B'), Item.field_77729_bt});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Block.field_72013_bc, 4), (Object[])new Object[]{"SwS", "wDw", "SwS", Character.valueOf('S'), Block.field_71939_E, Character.valueOf('D'), Block.field_71979_v, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Block.field_72013_bc, 4), (Object[])new Object[]{"wSw", "SDS", "wSw", Character.valueOf('S'), Block.field_71939_E, Character.valueOf('D'), Block.field_71979_v, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL)});
        output = new ItemStack((Item)Config.hiveFrameMagic);
        input = ItemInterface.getItem((String)"frameUntreated");
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{"www", "wfw", "www", Character.valueOf('w'), Config.wax.getStackForType(WaxType.MAGIC), Character.valueOf('f'), input});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameTemporal), (Object[])new Object[]{"sPs", "PfP", "sPs", Character.valueOf('s'), Block.field_71939_E, Character.valueOf('P'), Config.pollen.getStackForType(PollenType.PHASED), Character.valueOf('f'), Config.hiveFrameMagic});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Config.effectJar), new Object[]{"GSG", "QPQ", "GGG", Character.valueOf('G'), Block.field_71946_M, Character.valueOf('S'), "slabWood", Character.valueOf('P'), Config.pollen.getStackForType(PollenType.UNUSUAL), Character.valueOf('Q'), Item.field_94583_ca}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Config.moonDial), new Object[]{"DqD", "qrq", "DqD", Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('q'), Item.field_94583_ca, Character.valueOf('D'), "dyeGreen"}));
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.SKULL_FRAGMENT), (Object[])new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), Config.miscResources.getStackForType(ResourceType.SKULL_CHIP)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Item.field_82799_bQ, 1, 1), (Object[])new Object[]{"xxx", "xxx", Character.valueOf('x'), Config.miscResources.getStackForType(ResourceType.SKULL_FRAGMENT)});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.DRAGON_CHUNK), (Object[])new Object[]{"xxx", "xxx", Character.valueOf('x'), Config.miscResources.getStackForType(ResourceType.DRAGON_DUST)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Block.field_72084_bK, 1), (Object[])new Object[]{"ccc", "cec", "ccc", Character.valueOf('c'), Config.miscResources.getStackForType(ResourceType.DRAGON_CHUNK), Character.valueOf('e'), Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Config.miscResources.getStackForType(ResourceType.ESSENCE_EVERLASTING_DURABILITY), new Object[]{"gwg", "wiw", "gwg", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('w'), "waxMagical", Character.valueOf('i'), Block.field_72083_ai}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Config.miscResources.getStackForType(ResourceType.ESSENCE_EVERLASTING_DURABILITY), new Object[]{"wgw", "gig", "wgw", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('w'), "waxMagical", Character.valueOf('i'), Block.field_72083_ai}));
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE), (Object[])new Object[]{"gwg", "wfw", "gwg", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('f'), Block.field_72107_ae});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE), (Object[])new Object[]{"wgw", "gfg", "wgw", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('f'), Block.field_72107_ae});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE), (Object[])new Object[]{"gwg", "wfw", "gwg", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('f'), Item.field_77737_bm});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE), (Object[])new Object[]{"wgw", "gfg", "wgw", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('f'), Item.field_77737_bm});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME), (Object[])new Object[]{"wgw", "gcg", "wgw", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('c'), Item.field_77752_aS});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME), (Object[])new Object[]{"gwg", "wcw", "gwg", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('c'), Item.field_77752_aS});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_FICKLE_PERMANENCE), (Object[])new Object[]{"wew", "gcg", "wew", Character.valueOf('w'), Config.wax.getStackForType(WaxType.SOUL), Character.valueOf('c'), Item.field_77725_bx, Character.valueOf('e'), Item.field_77764_aP, Character.valueOf('g'), Block.field_72014_bd});
        GameRegistry.addRecipe((ItemStack)Config.miscResources.getStackForType(ResourceType.ESSENCE_SCORNFUL_OBLIVION), (Object[])new Object[]{"gst", "sEs", "tsg", Character.valueOf('g'), Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE), Character.valueOf('t'), Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME), Character.valueOf('s'), new ItemStack(Item.field_82799_bQ, 1, 1), Character.valueOf('E'), Block.field_72084_bK});
        input = new ItemStack((Item)Config.hiveFrameMagic);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameResilient), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_EVERLASTING_DURABILITY), input});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameGentle), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_FALSE_LIFE), input});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameNecrotic), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_SHALLOW_GRAVE), input});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameMetabolic), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_FICKLE_PERMANENCE), input});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameTemporal), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_LOST_TIME), input});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Config.hiveFrameOblivion), (Object[])new Object[]{Config.miscResources.getStackForType(ResourceType.ESSENCE_SCORNFUL_OBLIVION), ItemInterface.getItem((String)"frameProven")});
        if (OreDictionary.getOres((String)"ingotCopper").size() <= 0) {
            NuggetType.COPPER.setInactive();
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetCopper"}));
        }
        if (OreDictionary.getOres((String)"ingotTin").size() <= 0) {
            NuggetType.TIN.setInactive();
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetTin"}));
        }
        if (OreDictionary.getOres((String)"ingotSilver").size() <= 0) {
            NuggetType.SILVER.setInactive();
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"ingotSilver").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetSilver"}));
        }
        if (OreDictionary.getOres((String)"ingotLead").size() <= 0) {
            NuggetType.LEAD.setInactive();
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"ingotLead").get(0), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetLead"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Item.field_77703_o), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nuggetIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Item.field_77702_n), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "shardDiamond"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Item.field_77817_bH), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "shardEmerald"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ItemInterface.getItem((String)"apatite"), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), Config.nuggets.getStackForType(NuggetType.APATITE)}));
        output = Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY);
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{" G ", "QEQ", " W ", Character.valueOf('E'), Item.field_77748_bA, Character.valueOf('Q'), Block.field_94339_ct, Character.valueOf('W'), Block.field_72082_bJ, Character.valueOf('G'), Block.field_72105_ah});
        output = Config.voidCapsule.getCapsuleForLiquid(FluidType.EMPTY);
        output.field_77994_a = 4;
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{"T T", "GFG", "T T", Character.valueOf('G'), Block.field_72003_bq, Character.valueOf('F'), Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY), Character.valueOf('T'), Item.field_77733_bq});
        output = new ItemStack((Item)Config.magnet);
        GameRegistry.addRecipe((ItemStack)output, (Object[])new Object[]{" i ", "cSc", " d ", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('c'), Item.field_77750_aQ, Character.valueOf('d'), Item.field_77702_n, Character.valueOf('S'), Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY)});
        for (int level = 1; level <= 8; ++level) {
            output = new ItemStack((Item)Config.magnet, 1, level * 2);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{" d ", "mSm", " B ", Character.valueOf('d'), Item.field_77702_n, Character.valueOf('m'), "mb.magnet.level" + (level - 1), Character.valueOf('B'), Block.field_94341_cq, Character.valueOf('S'), Config.miscResources.getStackForType(ResourceType.DIMENSIONAL_SINGULARITY)}));
        }
        if (ThaumcraftHelper.isActive()) {
            input = Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT);
            output = new ItemStack(Config.tcMiscResource, 1, ThaumcraftHelper.MiscResource.KNOWLEDGE_FRAGMENT.ordinal());
            GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{input, input, input, input});
            GameRegistry.addRecipe((ItemStack)new ItemStack(Config.thaumaturgeBackpackT1), (Object[])new Object[]{"SWS", "NCN", "SWS", Character.valueOf('S'), Item.field_77683_K, Character.valueOf('W'), Block.field_72101_ab, Character.valueOf('N'), new ItemStack(Config.tcMiscResource.field_77779_bT, 1, ThaumcraftHelper.MiscResource.AMBER.ordinal()), Character.valueOf('C'), Block.field_72077_au});
        }
        if (ArsMagicaHelper.isActive()) {
            input = ItemInterface.getItem((String)"apatite");
            output = Config.miscResources.getStackForType(ResourceType.EXTENDED_FERTILIZER, 4);
            GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{new ItemStack(Config.amEssence, 1, ArsMagicaHelper.EssenceType.EARTH.ordinal()), input, input});
            GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{new ItemStack(Config.amEssence, 1, ArsMagicaHelper.EssenceType.PLANT.ordinal()), input, input});
        }
    }

    private static void setupCentrifugeRecipes() {
        ItemStack beeswax = ItemInterface.getItem((String)"beeswax");
        ItemStack propolis = ItemInterface.getItem((String)"propolis");
        propolis.func_77964_b(ForestryHelper.Propolis.PULSATING.ordinal());
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.MUNDANE), new ItemStack[]{beeswax, ItemInterface.getItem((String)"honeyDrop"), Config.wax.getStackForType(WaxType.MAGIC)}, new int[]{90, 60, 10});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.MOLTEN), new ItemStack[]{ItemInterface.getItem((String)"refractoryWax"), ItemInterface.getItem((String)"honeyDrop")}, new int[]{86, 8});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.FORGOTTEN), new ItemStack[]{Config.wax.getStackForType(WaxType.AMNESIC), propolis, ItemInterface.getItem((String)"honeyDrop")}, new int[]{50, 50, 22});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.OCCULT), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), ItemInterface.getItem((String)"honeyDrop")}, new int[]{100, 60});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.OTHERWORLDLY), new ItemStack[]{beeswax, Config.wax.getStackForType(WaxType.MAGIC), ItemInterface.getItem((String)"honeyDrop")}, new int[]{50, 20, 100});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.PAPERY), new ItemStack[]{ItemInterface.getItem((String)"beeswax"), Config.wax.getStackForType(WaxType.MAGIC), new ItemStack(Item.field_77759_aK)}, new int[]{80, 20, 5});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.INTELLECT), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), ItemInterface.getItem((String)"honeydew"), Config.drops.getStackForType(DropType.INTELLECT)}, new int[]{90, 40, 10});
        propolis.func_77964_b(ForestryHelper.Propolis.NORMAL.ordinal());
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.FURTIVE), new ItemStack[]{ItemInterface.getItem((String)"beeswax"), propolis, ItemInterface.getItem((String)"honeydew")}, new int[]{90, 20, 35});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.SOUL), new ItemStack[]{Config.wax.getStackForType(WaxType.SOUL), ItemInterface.getItem((String)"honeydew")}, new int[]{95, 26});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TEMPORAL), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), Config.pollen.getStackForType(PollenType.PHASED), new ItemStack(Config.fHoneydew, 1)}, new int[]{100, 5, 60});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TRANSMUTED), new ItemStack[]{ItemInterface.getItem((String)"beeswax"), Config.wax.getStackForType(WaxType.MAGIC), Config.propolis.getStackForType(PropolisType.UNSTABLE)}, new int[]{80, 80, 15});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.AIRY), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), new ItemStack(Item.field_77676_L)}, new int[]{100, 60});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.FIREY), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), new ItemStack(Item.field_77722_bw)}, new int[]{100, 60});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.WATERY), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), new ItemStack(Item.field_77756_aW)}, new int[]{100, 60});
        RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.EARTHY), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), new ItemStack(Item.field_77757_aI)}, new int[]{100, 60});
        if (ThaumcraftHelper.isActive()) {
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_AIR), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), new ItemStack(Item.field_77676_L), Config.propolis.getStackForType(PropolisType.AIR)}, new int[]{100, 60, 80});
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_FIRE), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), new ItemStack(Item.field_77722_bw), Config.propolis.getStackForType(PropolisType.FIRE)}, new int[]{100, 60, 80});
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_WATER), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), new ItemStack(Item.field_77756_aW), Config.propolis.getStackForType(PropolisType.WATER)}, new int[]{100, 60, 80});
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_EARTH), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), new ItemStack(Item.field_77757_aI), Config.propolis.getStackForType(PropolisType.EARTH)}, new int[]{100, 60, 80});
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_ORDER), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), Config.propolis.getStackForType(PropolisType.ORDER)}, new int[]{100, 80});
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.TC_CHAOS), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), Config.propolis.getStackForType(PropolisType.CHAOS)}, new int[]{100, 80});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.AIR), new ItemStack[]{propolis, Config.miscResources.getStackForType(ResourceType.TC_DUST_AIR)}, new int[]{100, 65});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.FIRE), new ItemStack[]{propolis, Config.miscResources.getStackForType(ResourceType.TC_DUST_FIRE)}, new int[]{100, 65});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.WATER), new ItemStack[]{propolis, Config.miscResources.getStackForType(ResourceType.TC_DUST_WATER)}, new int[]{100, 65});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.EARTH), new ItemStack[]{propolis, Config.miscResources.getStackForType(ResourceType.TC_DUST_EARTH)}, new int[]{100, 65});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.ORDER), new ItemStack[]{propolis, Config.miscResources.getStackForType(ResourceType.TC_DUST_ORDER)}, new int[]{100, 65});
            RecipeManagers.centrifugeManager.addRecipe(8, Config.propolis.getStackForType(PropolisType.CHAOS), new ItemStack[]{propolis, Config.miscResources.getStackForType(ResourceType.TC_DUST_CHAOS)}, new int[]{100, 65});
        }
        if (ArsMagicaHelper.isActive()) {
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.AM_ESSENCE), new ItemStack[]{Config.wax.getStackForType(WaxType.MAGIC), new ItemStack(Config.amItemResource), new ItemStack(Config.amItemResource)}, new int[]{85, 10, 2});
            RecipeManagers.centrifugeManager.addRecipe(20, Config.combs.getStackForType(CombType.AM_POTENT), new ItemStack[]{ItemInterface.getItem((String)"beeswax"), ItemInterface.getItem((String)"refractoryWax"), ItemInterface.getItem((String)"honeydew")}, new int[]{50, 50, 65});
        }
    }

    private static void setupCarpenterRecipes() {
        ItemStack output = BlockInterface.getBlock((String)"candle");
        output.field_77994_a = 24;
        RecipeManagers.carpenterManager.addRecipe(30, new FluidStack(FluidRegistry.WATER, 600), null, output, new Object[]{" S ", "WWW", "WWW", Character.valueOf('W'), Config.wax, Character.valueOf('S'), Item.field_77683_K});
        output = BlockInterface.getBlock((String)"candle");
        output.field_77994_a = 6;
        ItemStack input = ItemInterface.getItem((String)"craftingMaterial");
        input.func_77964_b(ForestryHelper.CraftingMaterial.SILK_WISP.ordinal());
        RecipeManagers.carpenterManager.addRecipe(30, new FluidStack(FluidRegistry.WATER, 600), null, output, new Object[]{"WSW", Character.valueOf('W'), Config.wax, Character.valueOf('S'), input});
        output = Config.miscResources.getStackForType(ResourceType.AROMATIC_LUMP, 2);
        RecipeManagers.carpenterManager.addRecipe(30, FluidRegistry.getFluidStack((String)"honey", (int)1000), null, output, new Object[]{" P ", "JDJ", " P ", Character.valueOf('P'), ItemInterface.getItem((String)"pollen"), Character.valueOf('J'), ItemInterface.getItem((String)"royalJelly"), Character.valueOf('D'), Config.drops.getStackForType(DropType.ENCHANTED)});
        RecipeManagers.carpenterManager.addRecipe(30, FluidRegistry.getFluidStack((String)"honey", (int)1000), null, output, new Object[]{" J ", "PDP", " J ", Character.valueOf('P'), ItemInterface.getItem((String)"pollen"), Character.valueOf('J'), ItemInterface.getItem((String)"royalJelly"), Character.valueOf('D'), Config.drops.getStackForType(DropType.ENCHANTED)});
        if (ThaumcraftHelper.isActive()) {
            input = ItemInterface.getItem((String)"craftingMaterial");
            input.func_77964_b(3);
            output = new ItemStack(Config.thaumaturgeBackpackT2);
            RecipeManagers.carpenterManager.addRecipe(200, new FluidStack(FluidRegistry.WATER, 1000), null, output, new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), input, Character.valueOf('T'), new ItemStack(Config.thaumaturgeBackpackT1)});
        }
    }

    private static void registerLiquidContainer(ItemCapsule baseCapsule) {
        ItemStack empty = new ItemStack((Item)baseCapsule, 1, 0);
        FluidStack liquid = null;
        for (FluidType fluidType : FluidType.values()) {
            switch (fluidType) {
                case EMPTY: {
                    liquid = null;
                    break;
                }
                case WATER: {
                    liquid = new FluidStack(FluidRegistry.WATER, baseCapsule.getType().capacity);
                    break;
                }
                case LAVA: {
                    liquid = new FluidStack(FluidRegistry.LAVA, baseCapsule.getType().capacity);
                    break;
                }
                default: {
                    liquid = FluidRegistry.getFluidStack((String)fluidType.liquidID, (int)baseCapsule.getType().capacity);
                }
            }
            if (liquid == null) continue;
            ItemStack filled = new ItemStack((Item)baseCapsule, 1, fluidType.ordinal());
            FluidContainerRegistry.registerFluidContainer((FluidStack)liquid, (ItemStack)filled, (ItemStack)empty);
            RecipeManagers.bottlerManager.addRecipe(5, liquid, empty, filled);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{filled}, liquid, Config.wax.getStackForType(WaxType.MAGIC), 20);
            fluidType.available = true;
        }
        FluidType.EMPTY.available = true;
    }
}

