/*
 * Decompiled with CFR 0.152.
 */
package magicbees.block.types;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IHiveDrop;
import java.util.ArrayList;
import java.util.Random;
import magicbees.bees.BeeGenomeManager;
import magicbees.bees.BeeSpecies;
import magicbees.bees.HiveDrop;
import magicbees.item.types.CombType;
import magicbees.main.Config;
import magicbees.main.utils.compat.ForestryHelper;
import magicbees.world.feature.FeatureHive;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public enum HiveType {
    CURIOUS("curious", 12, true),
    UNUSUAL("unusual", 12, true),
    RESONANT("resonant", 12, true),
    DEEP("deep", 4, false),
    INFERNAL("infernal", 15, false),
    OBLIVION("oblivion", 7, false);

    private static String[] nameList;
    private String name;
    public boolean show;
    private int lightLevel;
    private ArrayList<IHiveDrop> drops;
    private ArrayList<BiomeDictionary.Type> validBiomes;
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public static HiveType getHiveFromMeta(int meta) {
        HiveType type = CURIOUS;
        if (meta > 0 && meta < HiveType.values().length) {
            type = HiveType.values()[meta];
        }
        return type;
    }

    public static void initHiveData() {
        ItemStack[] combs = new ItemStack[]{Config.combs.getStackForType(CombType.MUNDANE)};
        HiveDrop valiantDrop = new HiveDrop(BeeGenomeManager.addRainResist(ForestryHelper.getTemplateForestryForSpecies("Valiant")), combs, 5);
        HiveType.CURIOUS.validBiomes.add(BiomeDictionary.Type.FOREST);
        HiveType.CURIOUS.validBiomes.add(BiomeDictionary.Type.JUNGLE);
        HiveType.CURIOUS.validBiomes.add(BiomeDictionary.Type.HILLS);
        HiveType.CURIOUS.drops.add(new HiveDrop(BeeSpecies.MYSTICAL.getGenome(), combs, 80).setIgnoblePercentage(0.7f));
        HiveType.CURIOUS.drops.add(new HiveDrop(BeeGenomeManager.addRainResist(BeeSpecies.MYSTICAL.getGenome()), combs, 15));
        HiveType.CURIOUS.drops.add(valiantDrop);
        HiveType.UNUSUAL.validBiomes.add(BiomeDictionary.Type.PLAINS);
        HiveType.UNUSUAL.validBiomes.add(BiomeDictionary.Type.MOUNTAIN);
        HiveType.UNUSUAL.validBiomes.add(BiomeDictionary.Type.HILLS);
        HiveType.UNUSUAL.drops.add(new HiveDrop(BeeSpecies.UNUSUAL.getGenome(), combs, 80).setIgnoblePercentage(0.7f));
        HiveType.UNUSUAL.drops.add(new HiveDrop(BeeGenomeManager.addRainResist(BeeSpecies.UNUSUAL.getGenome()), combs, 15));
        HiveType.UNUSUAL.drops.add(valiantDrop);
        HiveType.RESONANT.validBiomes.add(BiomeDictionary.Type.DESERT);
        HiveType.RESONANT.validBiomes.add(BiomeDictionary.Type.MAGICAL);
        HiveType.RESONANT.drops.add(new HiveDrop(BeeSpecies.SORCEROUS.getGenome(), combs, 80).setIgnoblePercentage(0.7f));
        HiveType.RESONANT.drops.add(new HiveDrop(BeeGenomeManager.addRainResist(BeeSpecies.SORCEROUS.getGenome()), combs, 20));
        HiveType.RESONANT.drops.add(valiantDrop);
        HiveType.DEEP.validBiomes.add(BiomeDictionary.Type.HILLS);
        HiveType.DEEP.validBiomes.add(BiomeDictionary.Type.MOUNTAIN);
        HiveType.DEEP.validBiomes.add(BiomeDictionary.Type.MAGICAL);
        HiveType.DEEP.drops.add(new HiveDrop(BeeSpecies.ATTUNED.getGenome(), combs, 80).setIgnoblePercentage(0.65f));
        HiveType.DEEP.drops.add(new HiveDrop(BeeGenomeManager.addRainResist(BeeSpecies.ATTUNED.getGenome()), combs, 20));
        HiveType.DEEP.drops.add(valiantDrop);
        combs = new ItemStack[]{Config.combs.getStackForType(CombType.MOLTEN), new ItemStack(Item.field_77751_aT, 6)};
        HiveType.INFERNAL.validBiomes.add(BiomeDictionary.Type.NETHER);
        HiveType.INFERNAL.validBiomes.add(BiomeDictionary.Type.MAGICAL);
        HiveType.INFERNAL.drops.add(new HiveDrop(BeeSpecies.INFERNAL.getGenome(), combs, 80).setIgnoblePercentage(0.5f));
        HiveType.INFERNAL.drops.add(new HiveDrop(ForestryHelper.getTemplateForestryForSpecies("Steadfast"), combs, 3));
        combs = new ItemStack[]{Config.combs.getStackForType(CombType.FORGOTTEN), new ItemStack(Item.field_77730_bn, 1)};
        HiveType.OBLIVION.validBiomes.add(BiomeDictionary.Type.END);
        HiveType.OBLIVION.validBiomes.add(BiomeDictionary.Type.MAGICAL);
        HiveType.OBLIVION.drops.add(new HiveDrop(BeeSpecies.OBLIVION.getGenome(), combs, 80));
        HiveType.OBLIVION.drops.add(new HiveDrop(ForestryHelper.getTemplateForestryForSpecies("Steadfast"), combs, 9));
    }

    private HiveType(String hiveName, int light, boolean visible) {
        this.name = hiveName;
        this.lightLevel = light;
        this.show = visible;
        this.drops = new ArrayList();
        this.validBiomes = new ArrayList();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IconRegister register) {
        for (HiveType type : HiveType.values()) {
            type.icons = new Icon[2];
            type.icons[0] = register.func_94245_a("magicbees:beehive." + type.ordinal() + ".top");
            type.icons[1] = register.func_94245_a("magicbees:beehive." + type.ordinal() + ".side");
        }
    }

    private HiveType() {
        this.drops = new ArrayList();
    }

    public void addDrop(IHiveDrop drop) {
        this.drops.add(drop);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIconForSide(int side) {
        Icon i = this.icons[0];
        if (side != 0 && side != 1) {
            i = this.icons[1];
        }
        return i;
    }

    public int getLightValue() {
        return this.lightLevel;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int fortune) {
        int dart;
        ArrayList<ItemStack> hiveDrops = new ArrayList<ItemStack>();
        int throttle = 0;
        block0: while (hiveDrops.size() <= 0 && throttle < 10) {
            ++throttle;
            dart = world.field_73012_v.nextInt(100);
            for (IHiveDrop drop : this.drops) {
                if (dart > drop.getChance(world, x, y, z)) continue;
                hiveDrops.add(drop.getPrincess(world, x, y, z, fortune));
                continue block0;
            }
        }
        dart = world.field_73012_v.nextInt(100);
        for (IHiveDrop drop : this.drops) {
            if (dart > drop.getChance(world, x, y, z)) continue;
            hiveDrops.addAll(drop.getDrones(world, x, y, z, fortune));
            break;
        }
        dart = world.field_73012_v.nextInt(100);
        for (IHiveDrop drop : this.drops) {
            if (dart > drop.getChance(world, x, y, z)) continue;
            hiveDrops.addAll(drop.getAdditional(world, x, y, z, fortune));
        }
        return hiveDrops;
    }

    public static String[] getAllNames() {
        String[] stringArray;
        if (nameList == null) {
            nameList = HiveType.generateNames();
            stringArray = nameList;
        } else {
            stringArray = nameList;
        }
        return stringArray;
    }

    private static String[] generateNames() {
        String[] names = new String[HiveType.values().length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = HiveType.values()[i].name;
        }
        return names;
    }

    public void generateHive(World world, Random random, int chunkX, int chunkZ, boolean initialGen) {
        if (this.spawnsInBiome(world.getBiomeGenForCoordsBody(chunkX * 16, chunkZ * 16))) {
            switch (this) {
                case CURIOUS: {
                    int coordZ;
                    int coordX;
                    for (int i = 0; i < 3 && !FeatureHive.generateHiveCurious(world, random, coordX = chunkX * 16 + random.nextInt(16), coordZ = chunkZ * 16 + random.nextInt(16), initialGen); ++i) {
                    }
                    break;
                }
                case UNUSUAL: {
                    int coordZ;
                    int coordX;
                    for (int i = 0; i < 3 && !FeatureHive.generateHiveUnusual(world, random, coordX = chunkX * 16 + random.nextInt(16), coordZ = chunkZ * 16 + random.nextInt(16), initialGen); ++i) {
                    }
                    break;
                }
                case RESONANT: {
                    int coordZ;
                    int coordX;
                    for (int i = 0; i < 2 && !FeatureHive.generateHiveResonant(world, random, coordX = chunkX * 16 + random.nextInt(16), coordZ = chunkZ * 16 + random.nextInt(16), initialGen); ++i) {
                    }
                    break;
                }
                case DEEP: {
                    int coordZ;
                    int coordX;
                    if (chunkX % 2 != 0 || chunkZ % 2 != 0) break;
                    for (int i = 0; i < 1 && !FeatureHive.generateHiveDeep(world, random, coordX = chunkX * 16 + random.nextInt(16), coordZ = chunkZ * 16 + random.nextInt(16), initialGen); ++i) {
                    }
                    break;
                }
                case INFERNAL: {
                    int coordZ;
                    int coordX;
                    for (int i = 0; i < 2 && !FeatureHive.generateHiveInfernal(world, random, coordX = chunkX * 16 + random.nextInt(16), coordZ = chunkZ * 16 + random.nextInt(16), initialGen); ++i) {
                    }
                    break;
                }
                case OBLIVION: {
                    int coordZ;
                    int coordX;
                    for (int i = 0; i < 3 && !FeatureHive.generateHiveOblivion(world, random, coordX = chunkX * 16 + random.nextInt(16), coordZ = chunkZ * 16 + random.nextInt(16), initialGen); ++i) {
                    }
                    break;
                }
            }
        }
    }

    public boolean spawnsInBiome(BiomeGenBase biomeGen) {
        boolean found = false;
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biomeGen);
        for (int i = 0; i < types.length; ++i) {
            if (!this.validBiomes.contains(types[i])) continue;
            found = true;
            break;
        }
        return found;
    }
}

