/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import magicbees.api.MagicBeesAPI;
import magicbees.api.bees.ITransmutationEffectController;
import magicbees.api.bees.ITransmutationEffectLogic;
import magicbees.bees.TransmutationEffectRailcraft;
import magicbees.bees.TransmutationEffectVanilla;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TransmutationEffectController
implements ITransmutationEffectController {
    private ArrayList<ITransmutationEffectLogic> logicObjects = new ArrayList();
    static TransmutationEffectController instance;

    public TransmutationEffectController() {
        this.logicObjects.add(new TransmutationEffectRailcraft());
        this.logicObjects.add(new TransmutationEffectVanilla());
        instance = this;
        MagicBeesAPI.transmutationEffectController = instance;
    }

    public void attemptTransmutations(World world, BiomeGenBase biome, ItemStack sourceBlock, int x, int y, int z) {
        boolean done = false;
        int i = 0;
        while (!done && i < this.logicObjects.size()) {
            ITransmutationEffectLogic logic = this.logicObjects.get(i++);
            try {
                done = logic.tryTransmutation(world, biome, sourceBlock, x, y, z);
            }
            catch (Exception e) {
                done = false;
                FMLLog.warning((String)"Magic Bees encountered an issue with an ITransmutationEffectLogic provider %s. Debug information follows.", (Object[])new Object[]{logic.getClass().getName()});
                FMLLog.info((String)e.getMessage(), (Object[])new Object[0]);
            }
            if (!done) continue;
            this.logicObjects.remove(i);
            this.logicObjects.add(logic);
            break;
        }
    }

    @Override
    public void addEffectLogic(ITransmutationEffectLogic logic) {
        if (logic != null && !this.logicObjects.contains(logic)) {
            this.logicObjects.add(logic);
        }
    }
}

