/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.resource.minecraft;

import binnie.core.resource.BinnieResource;
import binnie.core.resource.IBinnieTexture;
import binnie.craftgui.core.geometry.Direction;
import binnie.craftgui.resource.ITexture;

public class StandardTexture
implements ITexture {
    int u;
    int v;
    int w;
    int h;
    BinnieResource textureFile;

    public StandardTexture(int u, int v, int w, int h, IBinnieTexture textureFile) {
        this(u, v, w, h, 0, textureFile.getTexture());
    }

    public StandardTexture(int u, int v, int w, int h, int padding, IBinnieTexture textureFile) {
        this(u, v, w, h, padding, textureFile.getTexture());
    }

    public StandardTexture(int u, int v, int w, int h, BinnieResource textureFile) {
        this(u, v, w, h, 0, textureFile);
    }

    public StandardTexture(int u, int v, int w, int h, int padding, BinnieResource textureFile) {
        this.u = u;
        this.v = v;
        this.w = w;
        this.h = h;
        this.textureFile = textureFile;
    }

    @Override
    public int u() {
        return this.u;
    }

    @Override
    public int v() {
        return this.v;
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public int h() {
        return this.h;
    }

    public BinnieResource getTexture() {
        return this.textureFile;
    }

    @Override
    public ITexture subTexture(Direction direction, int distance) {
        switch (direction) {
            case Downwards: {
                return new StandardTexture(this.u(), this.v(), this.w, distance, 0, this.textureFile);
            }
            case Left: {
                return new StandardTexture(this.u(), this.v(), distance, this.h, 0, this.textureFile);
            }
            case Right: {
                return new StandardTexture(this.u() + this.w - distance, this.v(), distance, this.h, 0, this.textureFile);
            }
            case Upwards: {
                return new StandardTexture(this.u(), this.v() + this.h - distance, this.w(), distance, 0, this.textureFile);
            }
        }
        return this;
    }
}

