/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.kitchen;

import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.EventWidget;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.minecraft.MinecraftGUI;
import binnie.craftgui.window.Panel;

public class ControlDropDownMenu
extends Panel {
    float maxHeight = 0.0f;
    float focusChange = 0.0f;
    public boolean stayOpenOnChildClick = false;

    public ControlDropDownMenu(IWidget parent, float x, float y, float width, float height) {
        super(parent, x, y, width, 2.0f, MinecraftGUI.PanelType.Gray);
        this.addAttribute(Attribute.CanFocus);
        this.maxHeight = height;
    }

    @EventHandler(origin=EventHandler.Origin.Any)
    public void gainFocus(EventWidget.GainFocus event) {
        if (event.getOrigin().isDescendant(this)) {
            this.focusChange = this.maxHeight / 10.0f;
        } else if (!this.calculateIsMouseOver() && !this.stayOpenOnChildClick) {
            this.focusChange = -this.maxHeight / 10.0f;
        }
    }

    @EventHandler(origin=EventHandler.Origin.Any)
    public void loseFocus(EventWidget.LoseFocus event) {
        if (event.getOrigin().isDescendant(this) && !this.calculateIsMouseOver() && !this.stayOpenOnChildClick) {
            this.focusChange = -this.maxHeight / 10.0f;
        }
    }

    @EventHandler(origin=EventHandler.Origin.Any)
    public void loseFocus(EventMouse.Down event) {
    }

    @EventHandler(origin=EventHandler.Origin.Self)
    public void resize(EventWidget.ChangeSize event) {
        for (IWidget child : this.getWidgets()) {
            if (child.getCropWidget() != this) continue;
            child.setCroppedZone(this, this.getArea());
        }
    }

    @Override
    public void onUpdate() {
        if (this.focusChange > 0.0f && this.getSize().y() < this.maxHeight) {
            this.setSize(this.getSize().add(new Vector2f(0.0f, this.focusChange)));
        } else if (this.focusChange < 0.0f && this.getSize().y() > 2.0f) {
            this.setSize(this.getSize().add(new Vector2f(0.0f, this.focusChange)));
            if (this.getSize().y() <= 2.0f) {
                this.scheduleDeletion();
            }
        }
    }
}

