/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.core.geometry;

import binnie.craftgui.core.geometry.IOffset;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.Vector2f;

public class Offset
implements IOffset {
    public static Offset ZERO = new Offset(0.0f);
    float l = 0.0f;
    float r = 0.0f;
    float t = 0.0f;
    float b = 0.0f;

    public Offset(float l, float r, float t, float b) {
        this.l = l;
        this.r = r;
        this.t = t;
        this.b = b;
    }

    public Offset(float all) {
        this(all, all, all, all);
    }

    @Override
    public float t() {
        return this.t;
    }

    @Override
    public float l() {
        return this.l;
    }

    @Override
    public float r() {
        return this.r;
    }

    @Override
    public float b() {
        return this.b;
    }

    @Override
    public boolean isNonZero() {
        return this.t != 0.0f || this.r != 0.0f || this.l != 0.0f || this.r != 0.0f;
    }

    @Override
    public IPosition tl() {
        return new Vector2f(this.l(), this.t());
    }

    @Override
    public IPosition tr() {
        return new Vector2f(this.r(), this.t());
    }

    @Override
    public IPosition bl() {
        return new Vector2f(this.l(), this.b());
    }

    @Override
    public IPosition br() {
        return new Vector2f(this.r(), this.b());
    }
}

