/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.button;

import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.events.EventButtonClicked;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.core.EventHandler;

public class ControlButton
extends Control {
    private ControlText textWidget;
    private String text;

    @EventHandler(origin=EventHandler.Origin.Self)
    public void onMouseClick(EventMouse.Down event) {
        this.callEvent(new EventButtonClicked(this));
    }

    public ControlButton(IWidget parent, float x, float y, float width, float height) {
        super(parent, x, y, width, height);
        this.addAttribute(Attribute.MouseOver);
    }

    public ControlButton(IWidget parent, float x, float y, float width, float height, String text) {
        this(parent, x, y, width, height);
        int textHeight = (int)this.getSuperParent().getTextHeight();
        this.text = text;
        this.textWidget = new ControlText(this, this.getArea(), text, TextJustification.MiddleCenter);
    }

    @Override
    public void onUpdate() {
        if (this.textWidget != null) {
            this.textWidget.setValue(this.getText());
        }
    }

    public String getText() {
        return this.text;
    }
}

