/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IBuildcraft;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import binnie.core.triggers.BinnieAction;
import binnie.core.triggers.TriggerData;
import binnie.core.triggers.TriggerWorking;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ComponentProcess
extends MachineComponent
implements INetwork.GUI,
IProcess,
IBuildcraft.ActionProvider,
IBuildcraft.TriggerProvider,
IActionReceptor {
    protected float energyPerTick = 0.1f;
    protected float progressPerTick = 1.0f;
    float minimumEfficiency = 0.1f;
    LinkedList<Float> efficiencies = new LinkedList();
    float progressAmount = 0.0f;
    int processLength;
    int processEnergy;
    int guiProgressAmount;
    int guiEfficiency;
    int guiEnergyCost;
    int guiTimeTaken;
    float actionPauseProcess = 0.0f;
    float actionCancelTask = 0.0f;
    float clientEffeciency = -1.0f;

    public ComponentProcess(IMachine machine, int mjCost, int timePeriod) {
        super(machine);
        this.processLength = timePeriod;
        this.processEnergy = mjCost;
        this.guiProgressAmount = this.getUniqueProgressBarID();
        this.guiEfficiency = this.getUniqueProgressBarID();
        this.guiEnergyCost = this.getUniqueProgressBarID();
        this.guiTimeTaken = this.getUniqueProgressBarID();
    }

    private IPoweredMachine getPower() {
        return this.getMachine().getInterface(IPoweredMachine.class);
    }

    @Override
    public float getEnergyPerTick() {
        return (float)this.getProcessEnergy() / (float)this.getProcessLength();
    }

    @Override
    public float getProgressPerTick() {
        return 100.0f / (float)this.getProcessLength();
    }

    @Override
    public float getEfficiency() {
        if (this.clientEffeciency >= 0.0f) {
            return this.clientEffeciency;
        }
        if (this.efficiencies.size() == 0) {
            return 0.0f;
        }
        float f = 0.0f;
        for (Float f2 : this.efficiencies) {
            f += f2.floatValue();
        }
        return f /= (float)this.efficiencies.size();
    }

    @Override
    public void onUpdate() {
        this.progressPerTick = this.getProgressPerTick();
        this.energyPerTick = this.getEnergyPerTick();
        float energyAvailable = this.getPower().getPowerHandler().useEnergy(this.minimumEfficiency * this.energyPerTick, this.energyPerTick, false);
        float eff = energyAvailable / this.energyPerTick;
        this.efficiencies.add(Float.valueOf(eff));
        if (this.efficiencies.size() > 60) {
            this.efficiencies.poll();
        }
        if (this.canWork() == null) {
            if (!this.isInProgress() && this.canProgress() == null) {
                this.onStartTask();
                this.progressAmount += 0.01f;
            } else if (this.canProgress() == null) {
                this.progressTick();
                this.onTickTask();
            }
        } else if (this.isInProgress()) {
            this.onCancelTask();
            this.progressAmount = 0.0f;
            this.efficiencies.clear();
        }
        if (this.progressAmount >= 100.0f) {
            this.onFinishTask();
            this.progressAmount = 0.0f;
            this.efficiencies.clear();
        }
        if (this.actionPauseProcess > 0.0f) {
            this.actionPauseProcess -= 1.0f;
        }
        if (this.actionCancelTask > 0.0f) {
            this.actionCancelTask -= 1.0f;
        }
        super.onUpdate();
    }

    public void alterProgress(float f) {
        this.progressAmount += f;
    }

    public void setProgress(float f) {
        this.progressAmount = f;
    }

    private void progressTick() {
        this.getPower().getPowerHandler().useEnergy(this.minimumEfficiency * this.energyPerTick, this.energyPerTick, true);
        this.alterProgress(this.progressPerTick);
    }

    @Override
    public ErrorState canWork() {
        return this.actionCancelTask == 0.0f ? null : new ErrorState("Task Cancelled", "Cancelled by Buildcraft Gate");
    }

    @Override
    public ErrorState canProgress() {
        if (this.actionPauseProcess != 0.0f) {
            return new ErrorState("Process Paused", "Paused by Buildcraft Gate");
        }
        return this.getPower().getPowerHandler().getEnergyStored() < this.minimumEfficiency * this.energyPerTick ? new ErrorState.InsufficientPower() : null;
    }

    public boolean isInProgress() {
        return this.progressAmount > 0.0f;
    }

    @Override
    public float getProgress() {
        return this.progressAmount;
    }

    protected void onCancelTask() {
    }

    protected void onStartTask() {
    }

    protected void onFinishTask() {
    }

    protected void onTickTask() {
    }

    @Override
    public void addGUINetworkData(Map<Integer, Integer> data) {
        data.put(this.guiProgressAmount, (int)this.progressAmount * 100);
        data.put(this.guiEfficiency, (int)(this.getEfficiency() * 1000.0f));
        data.put(this.guiEnergyCost, this.getProcessEnergy());
        data.put(this.guiTimeTaken, this.getProcessLength());
    }

    @Override
    public void recieveGUINetworkData(int id, int data) {
        if (id == this.guiProgressAmount) {
            this.progressAmount = (float)data / 100.0f;
        }
        if (id == this.guiEfficiency) {
            this.clientEffeciency = (float)data / 1000.0f;
        }
        if (id == this.guiEnergyCost) {
            this.processEnergy = data;
        }
        if (id == this.guiTimeTaken) {
            this.processLength = data;
        }
    }

    @Override
    public int getProcessLength() {
        return this.processLength >= 0 ? this.processLength : 0;
    }

    @Override
    public int getProcessEnergy() {
        return this.processEnergy >= 0 ? this.processEnergy : 0;
    }

    @Override
    public String getTooltip() {
        return "Processing";
    }

    @Override
    public final void actionActivated(IAction action) {
        if (action == BinnieAction.actionCancelTask) {
            this.actionCancelTask = 20.0f;
            this.onCancelTask();
        } else if (action == BinnieAction.actionPauseProcess) {
            this.actionPauseProcess = 20.0f;
        }
    }

    @Override
    public void getTriggers(List<TriggerData> triggers) {
        triggers.add(TriggerWorking.canWork(this));
        triggers.add(TriggerWorking.cannotWork(this));
        triggers.add(TriggerWorking.isWorking(this));
        triggers.add(TriggerWorking.isNotWorking(this));
    }

    @Override
    public void getActions(List<IAction> actions) {
        actions.add(BinnieAction.actionPauseProcess);
        actions.add(BinnieAction.actionCancelTask);
    }
}

