/*
 * Decompiled with CFR 0.152.
 */
package binnie.core;

import binnie.core.BinnieCore;
import binnie.core.IBinnieMod;
import binnie.core.config.ConfigurationManager;
import binnie.core.gui.IBinnieGUID;
import binnie.core.network.BinniePacketHandler;
import binnie.core.network.IPacketID;
import binnie.core.plugin.IBinnieModule;
import binnie.core.proxy.IProxyCore;
import binnie.core.resource.IBinnieTexture;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;

public abstract class BinnieCoreMod
implements IBinnieMod {
    private Logger log;
    List<IBinnieModule> modules = new ArrayList<IBinnieModule>();

    public BinnieCoreMod() {
        BinnieCore.registerMod(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public abstract String getChannel();

    @Override
    public IPacketID[] getPacketIDs() {
        return new IPacketID[0];
    }

    @Override
    public IBinnieGUID[] getGUIDs() {
        return new IBinnieGUID[0];
    }

    @Override
    public IBinnieTexture[] getTextures() {
        return new IBinnieTexture[0];
    }

    @Override
    public Class[] getConfigs() {
        return new Class[0];
    }

    @Override
    public abstract IProxyCore getProxy();

    @Override
    public abstract String getId();

    @Override
    public void addModMetadata(ModMetadata metadata) {
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void init() {
        this.getProxy().doInit();
        this.log = Logger.getLogger(this.getId());
        this.log.setParent(FMLLog.getLogger());
        for (IBinnieModule module : this.modules) {
            module.doInit();
        }
    }

    @Override
    public void preInit() {
        if (this.getConfigs() != null) {
            for (Class cls : this.getConfigs()) {
                ConfigurationManager.registerConfiguration(cls, this);
            }
        }
        BinnieCore.loadModBlocksAndItems(this);
        this.registerModules(this.modules);
        this.getProxy().preInit();
        for (IBinnieModule module : this.modules) {
            module.preInit();
        }
        NetworkRegistry.instance().registerChannel((IPacketHandler)new BinniePacketHandler(this), this.getChannel());
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)this);
        ModContainer mcCore = FMLCommonHandler.instance().findContainerFor((Object)BinnieCore.instance);
        if (mc != null) {
            ModMetadata data = mc.getMetadata();
            data.autogenerated = false;
            data.description = "";
            data.authorList.add("Binnie");
            if (mc != mcCore) {
                mcCore.getMetadata().childMods.add(mc);
                data.parentMod = mcCore;
            }
            this.addModMetadata(data);
        }
        try {
            for (Field field : this.getClass().getFields()) {
                Item item;
                if (Item.class.isAssignableFrom(field.getType()) && (item = (Item)field.get(this)) != null) {
                    GameRegistry.registerItem((Item)item, (String)item.func_77658_a());
                }
                if (!Block.class.isAssignableFrom(field.getType())) continue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void postInit() {
        this.getProxy().postInit();
        for (IBinnieModule module : this.modules) {
            module.postInit();
        }
    }

    public abstract void registerModules(List<IBinnieModule> var1);
}

